/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.morph.api.morph.AttributeConfig;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.mode.MorphModeType;
import me.ichun.mods.morph.common.morph.MorphHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ConfigServer
extends ConfigBase {
    @CategoryDivider(name="morph")
    @Prop(min=1.0)
    public int morphTime = 100;
    public boolean aggressiveSizeRecalculation = false;
    private List<String> supportedAttributes = (List)Util.func_200696_a(new ArrayList(), list -> {
        list.add("minecraft:generic.max_health;more;20");
        list.add("minecraft:generic.knockback_resistance;more");
        list.add("minecraft:generic.movement_speed;more;0.1");
        list.add("minecraft:generic.attack_damage;more");
        list.add("minecraft:generic.attack_knockback;more");
        list.add("minecraft:generic.attack_speed;more");
        list.add("minecraft:generic.armor;more");
        list.add("minecraft:generic.luck;more");
        list.add("minecraft:horse.jump_strength;more");
        list.add("forge:swim_speed;more");
        list.add("forge:reach_distance;more");
    });
    public List<String> disabledTraits = new ArrayList<String>();
    public boolean silentMorphs = false;
    @CategoryDivider(name="biomass")
    @Prop(min=0.0)
    public double biomassValue = 0.3;
    public boolean biomassBypassAdvancement = false;
    @CategoryDivider(name="gameplay")
    private List<String> disabledMobs = (List)Util.func_200696_a(new ArrayList(), list -> list.add("minecraft:armor_stand"));
    public MorphModeType morphMode = MorphModeType.CLASSIC;
    public boolean biomassSkinWhilstInvisible = true;
    @CategoryDivider(name="morphMode")
    public boolean commandAllowSelector = false;
    public boolean classicUpgradeTraits = false;
    @CategoryDivider(name="playerFilter")
    public ConfigBase.FilterType biomassFilterType = ConfigBase.FilterType.DENY;
    public List<String> biomassFilterNames = new ArrayList<String>();
    public ConfigBase.FilterType morphFilterType = ConfigBase.FilterType.DENY;
    public List<String> morphFilterNames = new ArrayList<String>();
    public ConfigBase.FilterType selectorFilterType = ConfigBase.FilterType.DENY;
    public List<String> selectorFilterNames = new ArrayList<String>();
    public transient ArrayList<Pattern> disabledMobsID = new ArrayList();
    public transient HashMap<ResourceLocation, AttributeConfig> supportedAttributesMap = new HashMap();

    public void onConfigLoaded() {
        if (EffectiveSide.get().isClient() && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().func_71264_H()) {
            return;
        }
        MorphModeType morphMode = this.morphMode;
        if (morphMode == MorphModeType.DEFAULT) {
            morphMode = MorphModeType.CLASSIC;
        }
        MorphHandler.INSTANCE.setMorphMode(morphMode);
        this.parseDisabledMobs();
        this.parseSupportedAttributes();
    }

    private void parseDisabledMobs() {
        this.disabledMobsID.clear();
        for (String disabledMob : this.disabledMobs) {
            this.disabledMobsID.add(Pattern.compile(disabledMob));
        }
    }

    private void parseSupportedAttributes() {
        this.supportedAttributesMap.clear();
        for (String supportedAttribute : this.supportedAttributes) {
            List split = MorphHandler.ON_SEMI_COLON.splitToList((CharSequence)supportedAttribute);
            if (split.size() < 2) {
                Morph.LOGGER.error("Error parsing supported attribute config: {}", (Object)supportedAttribute);
                continue;
            }
            ResourceLocation rl = new ResourceLocation((String)split.get(0));
            boolean more = ((String)split.get(1)).equalsIgnoreCase("more");
            Double cap = null;
            if (split.size() == 3) {
                try {
                    cap = Double.parseDouble((String)split.get(2));
                }
                catch (NumberFormatException e) {
                    Morph.LOGGER.error("Error parsing supported attribute config, invalid cap: {}", (Object)supportedAttribute);
                }
            }
            this.supportedAttributesMap.put(rl, new AttributeConfig(more, cap));
        }
    }

    @Nonnull
    public String getModId() {
        return "morph";
    }

    @Nonnull
    public String getConfigName() {
        return "Morph";
    }

    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

