/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.UUID;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.save.PlayerMorphData;
import me.ichun.mods.morph.common.packet.PacketOpenGenerator;
import me.ichun.mods.morph.common.packet.PacketUpdateMorph;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySummonArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.command.arguments.UUIDArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandMorph {
    private static final SimpleCommandExceptionType EXTRACTION_ERROR = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.resources.error.extractionError"));
    private static final SimpleCommandExceptionType PLAYER_NO_NBT = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.resources.error.playerNoNbt"));
    private static final SimpleCommandExceptionType NOT_LIVING_ENTITY = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.notLivingEntity"));
    private static final SimpleCommandExceptionType ENTITY_COULD_NOT_BE_CREATED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.failedToCreateEntity"));
    private static final SimpleCommandExceptionType UNABLE_TO_ACQUIRE_MORPH = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.unableToAcquireMorph"));
    private static final SimpleCommandExceptionType UNABLE_TO_UNACQUIRE_CANNOT_FIND_ID = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.unableToUnacquireNoId"));
    private static final SimpleCommandExceptionType UNABLE_TO_UNACQUIRE_SELF_VARIANT = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.unableToUnacquireSelf"));
    private static final SimpleCommandExceptionType UNABLE_TO_UNACQUIRE_OUT_OF_BOUNDS = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.unableToUnacquireOOB"));
    private static final SimpleCommandExceptionType UNABLE_TO_MORPH_TO = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.unableToMorphTo"));
    private static final SimpleCommandExceptionType UNABLE_TO_DEMORPH = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.morph.morph.error.unableToDemorph"));
    private static final SuggestionProvider<CommandSource> MORPH_VARIANT_IDS = (context, builder) -> {
        ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)context, (String)"player");
        PlayerMorphData morphData = MorphHandler.INSTANCE.getPlayerMorphData((PlayerEntity)player);
        TreeSet variantIds = new TreeSet(Comparator.naturalOrder());
        for (MorphVariant morph : morphData.morphs) {
            variantIds.add(morph.id);
        }
        return ISuggestionProvider.func_197014_a(variantIds, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"morph").requires(p -> p.func_197034_c(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"resources").then(Commands.func_197057_a((String)"reload").executes(context -> {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.morph.resources.success.reloaded"), true);
            ResourceHandler.reloadAllResources();
            return 1;
        }))).then(Commands.func_197057_a((String)"reextract").executes(context -> {
            try {
                ResourceHandler.extractFiles(ResourceHandler.getMorphDir().resolve("2.extracted"));
                ResourceHandler.reloadAllResources();
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.morph.resources.success.reextract"), true);
                return 1;
            }
            catch (IOException e) {
                Morph.LOGGER.warn("Error extracting mod support files.", (Throwable)e);
                throw EXTRACTION_ERROR.create();
            }
        }))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"generate").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"nbt").executes(context -> {
            RayTraceResult entityLook = EntityHelper.getEntityLook((Entity)((CommandSource)context.getSource()).func_197035_h(), (double)5.0);
            if (entityLook.func_216346_c() == RayTraceResult.Type.ENTITY) {
                return CommandMorph.openNBTGenerator((CommandSource)context.getSource(), ((EntityRayTraceResult)entityLook).func_216348_a());
            }
            throw NOT_LIVING_ENTITY.create();
        })).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> CommandMorph.openNBTGenerator((CommandSource)context.getSource(), EntityArgument.func_197088_a((CommandContext)context, (String)"target")))))).then(Commands.func_197057_a((String)"mob").executes(context -> CommandMorph.openMobDataGerator((CommandSource)context.getSource())))))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"morph").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"acquire").then(Commands.func_197057_a((String)"entity").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> CommandMorph.createMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), EntityArgument.func_197088_a((CommandContext)context, (String)"target"), true))))).then(Commands.func_197057_a((String)"type").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity_type", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(SuggestionProviders.field_197505_d).then(Commands.func_197056_a((String)"nbt", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> CommandMorph.createMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity_type"), NBTCompoundTagArgument.func_218042_a((CommandContext)context, (String)"nbt"), true)))).executes(context -> CommandMorph.createMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity_type"), new CompoundNBT(), true))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").then(Commands.func_197057_a((String)"uuid").then(Commands.func_197056_a((String)"player_uuid", (ArgumentType)UUIDArgument.func_239194_a_()).executes(context -> CommandMorph.createPlayerMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), UUIDArgument.func_239195_a_((CommandContext)context, (String)"player_uuid"), true))))).then(Commands.func_197057_a((String)"name").then(Commands.func_197056_a((String)"player_name", (ArgumentType)StringArgumentType.word()).executes(context -> CommandMorph.createPlayerMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"player_name"), true))))))).then(Commands.func_197057_a((String)"unacquire").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"variant_id", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(MORPH_VARIANT_IDS).then(Commands.func_197056_a((String)"variant_index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CommandMorph.unacquire((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"variant_id"), IntegerArgumentType.getInteger((CommandContext)context, (String)"variant_index"))))).then(Commands.func_197057_a((String)"all").executes(context -> CommandMorph.unacquire((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"variant_id"), -1)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"morph").then(Commands.func_197057_a((String)"entity").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> CommandMorph.createMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), EntityArgument.func_197088_a((CommandContext)context, (String)"target"), false))))).then(Commands.func_197057_a((String)"type").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity_type", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(SuggestionProviders.field_197505_d).then(Commands.func_197056_a((String)"nbt", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> CommandMorph.createMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity_type"), NBTCompoundTagArgument.func_218042_a((CommandContext)context, (String)"nbt"), false)))).executes(context -> CommandMorph.createMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity_type"), new CompoundNBT(), false))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").then(Commands.func_197057_a((String)"uuid").then(Commands.func_197056_a((String)"player_uuid", (ArgumentType)UUIDArgument.func_239194_a_()).executes(context -> CommandMorph.createPlayerMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), UUIDArgument.func_239195_a_((CommandContext)context, (String)"player_uuid"), false))))).then(Commands.func_197057_a((String)"name").then(Commands.func_197056_a((String)"player_name", (ArgumentType)StringArgumentType.word()).executes(context -> CommandMorph.createPlayerMorph((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"player_name"), false))))))).then(Commands.func_197057_a((String)"demorph").executes(context -> CommandMorph.demorphPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))))));
    }

    private static int unacquire(CommandSource source, ServerPlayerEntity player, ResourceLocation variant_id, int i) throws CommandSyntaxException {
        PlayerMorphData morphData = MorphHandler.INSTANCE.getPlayerMorphData((PlayerEntity)player);
        for (MorphVariant morph : morphData.morphs) {
            if (!variant_id.equals((Object)morph.id)) continue;
            boolean updatePlayer = false;
            if (i >= 0) {
                if (i >= morph.variants.size()) {
                    throw UNABLE_TO_UNACQUIRE_OUT_OF_BOUNDS.create();
                }
                MorphVariant.Variant variant = morph.variants.get(i);
                if ("default_player_state".equals(variant.identifier)) {
                    throw UNABLE_TO_UNACQUIRE_SELF_VARIANT.create();
                }
                if (morph.removeVariant(variant)) {
                    updatePlayer = true;
                }
            } else {
                for (int i1 = morph.variants.size() - 1; i1 >= 0; --i1) {
                    MorphVariant.Variant variant = morph.variants.get(i1);
                    if ("default_player_state".equals(variant.identifier) || !morph.removeVariant(variant)) continue;
                    updatePlayer = true;
                }
            }
            if (updatePlayer) {
                MorphHandler.INSTANCE.getSaveData().func_76185_a();
                Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorph(morph.write(new CompoundNBT())), player);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.morph.morph.success.morphUnacquired", new Object[]{player.func_145748_c_()}), true);
            }
            return 1;
        }
        throw UNABLE_TO_UNACQUIRE_CANNOT_FIND_ID.create();
    }

    private static int openMobDataGerator(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        Morph.channel.sendTo((AbstractPacket)new PacketOpenGenerator(-1), player);
        return 1;
    }

    private static int openNBTGenerator(CommandSource source, Entity target) throws CommandSyntaxException {
        if (!(target instanceof LivingEntity)) {
            throw NOT_LIVING_ENTITY.create();
        }
        if (target instanceof PlayerEntity) {
            throw PLAYER_NO_NBT.create();
        }
        ServerPlayerEntity player = source.func_197035_h();
        Morph.channel.sendTo((AbstractPacket)new PacketOpenGenerator(target.func_145782_y()), player);
        return 1;
    }

    private static int setBiomass(CommandSource source, ServerPlayerEntity player, double value) {
        MorphHandler.INSTANCE.setBiomassAmount(player, value);
        return 1;
    }

    private static int createMorph(CommandSource source, ServerPlayerEntity player, Entity entity, boolean isAcquire) throws CommandSyntaxException {
        if (entity instanceof LivingEntity) {
            MorphVariant variant = MorphHandler.INSTANCE.createVariant((LivingEntity)entity);
            if (CommandMorph.createMorph(source, player, variant, isAcquire)) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent(isAcquire ? "command.morph.morph.success.morphAcquired" : "command.morph.morph.success.morphTo", new Object[]{player.func_145748_c_()}), true);
                return 1;
            }
            throw isAcquire ? UNABLE_TO_ACQUIRE_MORPH.create() : UNABLE_TO_MORPH_TO.create();
        }
        throw NOT_LIVING_ENTITY.create();
    }

    private static int createMorph(CommandSource source, ServerPlayerEntity player, ResourceLocation type, CompoundNBT nbt, boolean isAcquire) throws CommandSyntaxException {
        CompoundNBT compoundnbt = nbt.func_74737_b();
        compoundnbt.func_74778_a("id", type.toString());
        ServerWorld serverworld = source.func_197023_e();
        Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)serverworld, ent -> ent);
        if (entity == null) {
            throw ENTITY_COULD_NOT_BE_CREATED.create();
        }
        return CommandMorph.createMorph(source, player, entity, isAcquire);
    }

    private static int createPlayerMorph(CommandSource source, ServerPlayerEntity player, String name, boolean isAcquire) throws CommandSyntaxException {
        GameProfile gameProfile = EntityHelper.getGameProfile(null, (String)name);
        if (gameProfile.getId() == null) {
            throw isAcquire ? UNABLE_TO_ACQUIRE_MORPH.create() : UNABLE_TO_MORPH_TO.create();
        }
        MorphVariant variant = MorphVariant.createPlayerMorph(gameProfile.getId(), true);
        if (CommandMorph.createMorph(source, player, variant, isAcquire)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(isAcquire ? "command.morph.morph.success.morphAcquired" : "command.morph.morph.success.morphTo", new Object[]{player.func_145748_c_()}), true);
            return 1;
        }
        throw isAcquire ? UNABLE_TO_ACQUIRE_MORPH.create() : UNABLE_TO_MORPH_TO.create();
    }

    private static int createPlayerMorph(CommandSource source, ServerPlayerEntity player, UUID uuid, boolean isAcquire) throws CommandSyntaxException {
        MorphVariant variant = MorphVariant.createPlayerMorph(uuid, true);
        if (CommandMorph.createMorph(source, player, variant, isAcquire)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(isAcquire ? "command.morph.morph.success.morphAcquired" : "command.morph.morph.success.morphTo", new Object[]{player.func_145748_c_()}), true);
            return 1;
        }
        throw isAcquire ? UNABLE_TO_ACQUIRE_MORPH.create() : UNABLE_TO_MORPH_TO.create();
    }

    private static boolean createMorph(CommandSource source, ServerPlayerEntity player, MorphVariant variant, boolean isAcquire) {
        if (isAcquire) {
            return MorphHandler.INSTANCE.acquireMorph(player, variant);
        }
        return MorphHandler.INSTANCE.morphTo(player, variant);
    }

    private static int demorphPlayer(CommandSource source, ServerPlayerEntity player) throws CommandSyntaxException {
        if (MorphHandler.INSTANCE.demorph(player)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.morph.morph.success.demorph", new Object[]{player.func_145748_c_()}), true);
            return 1;
        }
        throw UNABLE_TO_DEMORPH.create();
    }
}

