/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.biomass;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import me.ichun.mods.morph.api.biomass.BiomassUpgradeInfo;
import me.ichun.mods.morph.api.event.MorphLoadResourceEvent;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.io.FileUtils;

public class BiomassUpgradeHandler {
    public static final HashMap<String, BiomassUpgradeInfo> BIOMASS_UPGRADES = new HashMap();

    public static void loadBiomassUpgrades() {
        BIOMASS_UPGRADES.clear();
        HashMap upgradeMap = new HashMap();
        try {
            IOUtil.scourDirectoryForFiles((Path)ResourceHandler.getMorphDir().resolve("biomass"), p -> {
                if (p.getFileName().toString().endsWith(".json")) {
                    File file = p.toFile();
                    try {
                        BiomassUpgradeInfo upgradeInfo = (BiomassUpgradeInfo)ResourceHandler.GSON.fromJson(FileUtils.readFileToString((File)file, (String)"UTF-8"), BiomassUpgradeInfo.class);
                        if (upgradeInfo.id == null) {
                            Morph.LOGGER.error("Biomass Upgrade has no id: {}", (Object)file);
                        } else if (upgradeInfo.parentId == null) {
                            Morph.LOGGER.error("Biomass Upgrade has no parent id: {}", (Object)file);
                        } else {
                            upgradeMap.put(upgradeInfo.id, upgradeInfo);
                        }
                        return true;
                    }
                    catch (JsonSyntaxException | IOException | IllegalStateException e) {
                        Morph.LOGGER.error("Error reading Biomass Upgrade file: {}", (Object)file);
                        e.printStackTrace();
                    }
                }
                return false;
            });
        }
        catch (IOException e2) {
            Morph.LOGGER.error("Error loading Biomass files.", (Throwable)e2);
        }
        upgradeMap.entrySet().removeIf(e -> {
            if (!((BiomassUpgradeInfo)e.getValue()).parentId.equals("root") && !upgradeMap.containsKey(((BiomassUpgradeInfo)e.getValue()).parentId)) {
                Morph.LOGGER.error("Removing biomass upgrade with ID {} as we cannot find their parent with ID {}", (Object)((BiomassUpgradeInfo)e.getValue()).id, (Object)((BiomassUpgradeInfo)e.getValue()).parentId);
                return true;
            }
            return false;
        });
        BIOMASS_UPGRADES.putAll(upgradeMap);
        Morph.LOGGER.info("Loaded {} Biomass Upgrade(s)", (Object)BIOMASS_UPGRADES.size());
        MinecraftForge.EVENT_BUS.post((Event)new MorphLoadResourceEvent(MorphLoadResourceEvent.Type.BIOMASS));
    }
}

