/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.data.AdvancementGen;
import me.ichun.mods.ichunutil.common.network.PacketChannel;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.mob.MobData;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.client.config.ConfigClient;
import me.ichun.mods.morph.client.core.EventHandlerClient;
import me.ichun.mods.morph.client.core.KeyBinds;
import me.ichun.mods.morph.client.entity.EntityAcquisition;
import me.ichun.mods.morph.client.entity.EntityBiomassAbility;
import me.ichun.mods.morph.client.render.RenderEntityAcquisition;
import me.ichun.mods.morph.client.render.RenderEntityBiomassAbility;
import me.ichun.mods.morph.common.config.ConfigServer;
import me.ichun.mods.morph.common.core.EventHandlerServer;
import me.ichun.mods.morph.common.mob.MobDataHandler;
import me.ichun.mods.morph.common.mob.TraitHandler;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.packet.PacketAcquisition;
import me.ichun.mods.morph.common.packet.PacketInvalidateClientHealth;
import me.ichun.mods.morph.common.packet.PacketMorphInfo;
import me.ichun.mods.morph.common.packet.PacketMorphInput;
import me.ichun.mods.morph.common.packet.PacketOpenGenerator;
import me.ichun.mods.morph.common.packet.PacketPlayerData;
import me.ichun.mods.morph.common.packet.PacketRequestMorphInfo;
import me.ichun.mods.morph.common.packet.PacketSessionSync;
import me.ichun.mods.morph.common.packet.PacketUpdateBiomassUpgrades;
import me.ichun.mods.morph.common.packet.PacketUpdateBiomassValue;
import me.ichun.mods.morph.common.packet.PacketUpdateMorph;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ChangeDimensionTrigger;
import net.minecraft.advancements.criterion.EffectsChangedTrigger;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MobEffectsPredicate;
import net.minecraft.advancements.criterion.PositionTrigger;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="morph")
public class Morph {
    public static final String MOD_NAME = "Morph";
    public static final String MOD_ID = "morph";
    public static final String PROTOCOL = "2";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ConfigServer configServer;
    public static ConfigClient configClient;
    public static EventHandlerClient eventHandlerClient;
    public static EventHandlerServer eventHandlerServer;
    public static PacketChannel channel;

    public Morph() {
        if (!ResourceHandler.setupEnv()) {
            LOGGER.fatal("Error initialising Morph Resource Handler! Terminating init.");
            return;
        }
        configServer = (ConfigServer)new ConfigServer().init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Sounds.REGISTRY.register(bus);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::processIMC);
        bus.addListener(this::finishLoading);
        eventHandlerServer = new EventHandlerServer();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerServer);
        MinecraftForge.EVENT_BUS.addListener(Advancements::onGatherData);
        MorphApi.setApiImpl(MorphHandler.INSTANCE);
        channel = new PacketChannel(new ResourceLocation(MOD_ID, "channel"), PROTOCOL, new Class[]{PacketPlayerData.class, PacketRequestMorphInfo.class, PacketMorphInfo.class, PacketUpdateMorph.class, PacketSessionSync.class, PacketMorphInput.class, PacketAcquisition.class, PacketUpdateBiomassValue.class, PacketUpdateBiomassUpgrades.class, PacketInvalidateClientHealth.class, PacketOpenGenerator.class});
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            configClient = (ConfigClient)((Object)((Object)((Object)new ConfigClient().init())));
            bus.addGenericListener(EntityType.class, x$0 -> EntityTypes.onEntityTypeRegistry(x$0));
            bus.addListener(this::onClientSetup);
            eventHandlerClient = new EventHandlerClient();
            MinecraftForge.EVENT_BUS.register((Object)eventHandlerClient);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> me.ichun.mods.ichunutil.client.core.EventHandlerClient::getConfigGui);
        });
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(MorphInfo.class, (Capability.IStorage)new Capability.IStorage<MorphInfo>(){

            @Nullable
            public INBT writeNBT(Capability<MorphInfo> capability, MorphInfo instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<MorphInfo> capability, MorphInfo instance, Direction side, INBT nbt) {
            }
        }, () -> null);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityTypes.ACQUISITION, (IRenderFactory)new RenderEntityAcquisition.RenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypes.BIOMASS_ABILITY, (IRenderFactory)new RenderEntityBiomassAbility.RenderFactory());
        KeyBinds.init();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream(m -> m.equalsIgnoreCase("trait")).forEach(msg -> {
            block7: {
                Object o = msg.getMessageSupplier().get();
                if (o instanceof Class) {
                    Class clz = (Class)o;
                    if (Trait.class.isAssignableFrom(clz)) {
                        try {
                            Trait t = (Trait)clz.newInstance();
                            if (t.type != null && !t.type.isEmpty()) {
                                TraitHandler.registerTrait(t.type, clz);
                                LOGGER.info("IMC: Registering trait type {} from mod {}", (Object)t.type, (Object)msg.getSenderModId());
                                break block7;
                            }
                            LOGGER.warn("IMC: Invalid trait type from {}", (Object)msg.getSenderModId());
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            LOGGER.error("IMC: Error retrieving trait type from {}", (Object)msg.getSenderModId());
                            e.printStackTrace();
                        }
                    } else {
                        LOGGER.warn("IMC: Non-Trait class type trait from {}", (Object)msg.getSenderModId());
                    }
                } else {
                    LOGGER.warn("IMC: Non-class type trait from {}", (Object)msg.getSenderModId());
                }
            }
        });
        event.getIMCStream(m -> m.equalsIgnoreCase("mob")).forEach(msg -> {
            Object o = msg.getMessageSupplier().get();
            if (o instanceof MobData) {
                MobData data = (MobData)o;
                if (data.forEntity != null && !data.forEntity.isEmpty()) {
                    ResourceLocation rl = new ResourceLocation(data.forEntity);
                    MobDataHandler.registerMobData(rl, data);
                    LOGGER.info("IMC: Registering MobData for {} from mod {}", (Object)rl.toString(), (Object)msg.getSenderModId());
                } else {
                    LOGGER.warn("IMC: Invalid MobData forEntity from {}", (Object)msg.getSenderModId());
                }
            } else {
                LOGGER.warn("IMC: Non-MobData object from {}", (Object)msg.getSenderModId());
            }
        });
        event.getIMCStream(m -> m.equalsIgnoreCase("morphSync")).forEach(msg -> {
            Object o = msg.getMessageSupplier().get();
            if (o instanceof BiConsumer) {
                BiConsumer consumer = (BiConsumer)o;
                MorphHandler.INSTANCE.getModPlayerMorphSyncConsumers().add(consumer);
                LOGGER.info("IMC: Registering morph sync BiConsumer from mod {}", (Object)msg.getSenderModId());
            } else {
                LOGGER.warn("IMC: Non-BiConsumer morph sync object from {}", (Object)msg.getSenderModId());
            }
        });
        event.getIMCStream(m -> m.equalsIgnoreCase("variantNbtSetter")).forEach(msg -> {
            Object o = msg.getMessageSupplier().get();
            if (o instanceof BiConsumer) {
                BiConsumer consumer = (BiConsumer)o;
                MorphHandler.INSTANCE.getVariantNbtTagSetters().add(consumer);
                LOGGER.info("IMC: Registering variant NBT setter BiConsumer from mod {}", (Object)msg.getSenderModId());
            } else {
                LOGGER.warn("IMC: Non-BiConsumer NBT setter object from {}", (Object)msg.getSenderModId());
            }
        });
        event.getIMCStream(m -> m.equalsIgnoreCase("variantNbtReader")).forEach(msg -> {
            Object o = msg.getMessageSupplier().get();
            if (o instanceof BiConsumer) {
                BiConsumer consumer = (BiConsumer)o;
                MorphHandler.INSTANCE.getVariantNbtTagReaders().add(consumer);
                LOGGER.info("IMC: Registering variant NBT reader BiConsumer from mod {}", (Object)msg.getSenderModId());
            } else {
                LOGGER.warn("IMC: Non-BiConsumer NBT reader object from {}", (Object)msg.getSenderModId());
            }
        });
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        ResourceHandler.loadResources();
    }

    public static class EntityTypes {
        public static EntityType<EntityAcquisition> ACQUISITION;
        public static EntityType<EntityBiomassAbility> BIOMASS_ABILITY;

        private static void onEntityTypeRegistry(RegistryEvent.Register<EntityType<?>> entityTypeRegistryEvent) {
            ACQUISITION = EntityType.Builder.func_220322_a(EntityAcquisition::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.1f, 0.1f).func_200706_c().func_200705_b().func_220320_c().func_206830_a("an entity from Morph. Ignore this.");
            BIOMASS_ABILITY = EntityType.Builder.func_220322_a(EntityBiomassAbility::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.1f, 0.1f).func_200706_c().func_200705_b().func_220320_c().func_206830_a("an entity from Morph. Ignore this.");
        }
    }

    public static class Sounds {
        private static final DeferredRegister<SoundEvent> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"morph");
        public static final RegistryObject<SoundEvent> MORPH = REGISTRY.register("morph", () -> new SoundEvent(new ResourceLocation(Morph.MOD_ID, Morph.MOD_ID)));
    }

    public static class Advancements
    implements Consumer<Consumer<Advancement>> {
        public static final ResourceLocation UNLOCK_BIOMASS = new ResourceLocation("morph", "morph/unlock_biomass");

        @SubscribeEvent
        public static void onGatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            if (event.includeServer()) {
                gen.func_200390_a((IDataProvider)new AdvancementGen(gen, (Consumer)new Advancements()));
            }
        }

        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement advancement = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)Blocks.field_196817_hS, (ITextComponent)new TranslationTextComponent("advancements.nether.root.title"), (ITextComponent)new TranslationTextComponent("advancements.nether.root.description"), new ResourceLocation("textures/gui/advancements/backgrounds/nether.png"), FrameType.TASK, false, false, false).func_200275_a("entered_nether", (ICriterionInstance)ChangeDimensionTrigger.Instance.func_233552_a_((RegistryKey)World.field_234919_h_)).func_203904_a(consumer, "nether/root");
            Advancement advancement2 = Advancement.Builder.func_200278_a().func_203905_a(advancement).func_203902_a((IItemProvider)Blocks.field_196653_dH, (ITextComponent)new TranslationTextComponent("advancements.nether.find_fortress.title"), (ITextComponent)new TranslationTextComponent("advancements.nether.find_fortress.description"), (ResourceLocation)null, FrameType.TASK, true, true, false).func_200275_a("fortress", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)Structure.field_236378_n_))).func_203904_a(consumer, "nether/find_fortress");
            Advancement.Builder.func_200278_a().func_203905_a(advancement2).func_203902_a((IItemProvider)Items.field_221690_bg, (ITextComponent)new TranslationTextComponent("morph.advancement.unlock_biomass.title"), (ITextComponent)new TranslationTextComponent("morph.advancement.unlock_biomass.description"), null, FrameType.CHALLENGE, true, true, false).func_200275_a("wither_and_regen", (ICriterionInstance)EffectsChangedTrigger.Instance.func_203917_a((MobEffectsPredicate)MobEffectsPredicate.func_204014_a().func_204015_a(Effects.field_82731_v).func_204015_a(Effects.field_76428_l))).func_203904_a(consumer, UNLOCK_BIOMASS.toString());
        }
    }
}

