/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.render.hand;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.api.client.hand.HandInfo;
import me.ichun.mods.ichunutil.api.common.PlacementCorrector;
import me.ichun.mods.ichunutil.client.model.util.ModelHelper;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import me.ichun.mods.morph.api.event.MorphLoadResourceEvent;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.client.render.MorphRenderHandler;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.io.FileUtils;

@OnlyIn(value=Dist.CLIENT)
public final class HandHandler {
    private static final HashMap<Class<? extends EntityModel>, HandInfo> MODEL_HAND_INFO = new HashMap();
    private static final Gson GSON = new Gson();
    public static HandHandler instance;
    private MorphInfo lastMorphInfo;
    private float lastPartialTick;

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.field_70128_L) {
            this.lastMorphInfo = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)mc.field_71439_g);
            this.lastPartialTick = event.getPartialTicks();
        }
    }

    public boolean renderHand(PlayerRenderer playerRenderer, MatrixStack stack, IRenderTypeBuffer buffer, int light, AbstractClientPlayerEntity player, ModelRenderer arm, ModelRenderer armwear) {
        float partialTick;
        MorphInfo info;
        float skinAlpha;
        if (player == Minecraft.func_71410_x().func_175606_aa() && this.lastMorphInfo != null && !MorphRenderHandler.isRenderingMorph && ((skinAlpha = (info = this.lastMorphInfo).getMorphSkinAlpha(partialTick = this.lastPartialTick)) > 0.0f || info.isMorphed())) {
            Minecraft mc = Minecraft.func_71410_x();
            ModelRenderer[] handParts = null;
            MatrixStack[] stacks = null;
            ResourceLocation texture = null;
            HandSide handSide = ((PlayerModel)playerRenderer.field_77045_g).field_178723_h != arm ? HandSide.LEFT : HandSide.RIGHT;
            float morphProg = info.getMorphProgress(partialTick);
            float transitionProg = info.getTransitionProgressSine(partialTick);
            if (morphProg < 1.0f && transitionProg < 1.0f) {
                if (transitionProg <= 0.0f) {
                    LivingEntity livingInstance = info.prevState.getEntityInstance(mc.field_71439_g.field_70170_p, (PlayerEntity)mc.field_71439_g);
                    EntityRenderer entRenderer = playerRenderer.func_177068_d().func_78713_a((Entity)livingInstance);
                    if (entRenderer instanceof LivingRenderer) {
                        stack.func_227860_a_();
                        stack.func_227861_a_(0.0, -500.0, 0.0);
                        MorphRenderHandler.renderLiving((EntityRenderer<? super LivingEntity>)entRenderer, livingInstance, stack, buffer, light, partialTick);
                        stack.func_227865_b_();
                        LivingRenderer livingRenderer = (LivingRenderer)entRenderer;
                        EntityModel entityModel = livingRenderer.func_217764_d();
                        HandInfo handInfo = HandHandler.getHandInfo(entityModel.getClass());
                        if (handInfo != null) {
                            HandHandler.renderModelPreHandModelRendererCopy(entityModel, livingInstance);
                            handParts = handInfo.getHandParts(handSide, entityModel);
                            stacks = handInfo.getPlacementCorrectors(handSide);
                            texture = entRenderer.func_110775_a((Entity)livingInstance);
                        }
                    }
                } else {
                    HandInfo handInfo;
                    EntityModel entityModel;
                    LivingRenderer livingRenderer;
                    ModelRenderer[] prevHandParts = null;
                    MatrixStack[] prevStacks = null;
                    ModelRenderer[] nextHandParts = null;
                    MatrixStack[] nextStacks = null;
                    LivingEntity prevInstance = info.prevState.getEntityInstance(mc.field_71439_g.field_70170_p, (PlayerEntity)mc.field_71439_g);
                    EntityRenderer prevRenderer = playerRenderer.func_177068_d().func_78713_a((Entity)prevInstance);
                    LivingEntity nextInstance = info.nextState.getEntityInstance(mc.field_71439_g.field_70170_p, (PlayerEntity)mc.field_71439_g);
                    EntityRenderer nextRenderer = playerRenderer.func_177068_d().func_78713_a((Entity)nextInstance);
                    stack.func_227860_a_();
                    stack.func_227861_a_(0.0, -500.0, 0.0);
                    if (prevRenderer instanceof LivingRenderer) {
                        MorphRenderHandler.renderLiving((EntityRenderer<? super LivingEntity>)prevRenderer, prevInstance, stack, buffer, light, partialTick);
                        livingRenderer = (LivingRenderer)prevRenderer;
                        entityModel = livingRenderer.func_217764_d();
                        handInfo = HandHandler.getHandInfo(entityModel.getClass());
                        if (handInfo != null) {
                            HandHandler.renderModelPreHandModelRendererCopy(entityModel, prevInstance);
                            prevHandParts = handInfo.getHandParts(handSide, entityModel);
                            prevStacks = handInfo.getPlacementCorrectors(handSide);
                        }
                    }
                    if (nextRenderer instanceof LivingRenderer) {
                        MorphRenderHandler.renderLiving((EntityRenderer<? super LivingEntity>)nextRenderer, nextInstance, stack, buffer, light, partialTick);
                        livingRenderer = (LivingRenderer)nextRenderer;
                        entityModel = livingRenderer.func_217764_d();
                        handInfo = HandHandler.getHandInfo(entityModel.getClass());
                        if (handInfo != null) {
                            HandHandler.renderModelPreHandModelRendererCopy(entityModel, nextInstance);
                            nextHandParts = handInfo.getHandParts(handSide, entityModel);
                            nextStacks = handInfo.getPlacementCorrectors(handSide);
                        }
                    }
                    stack.func_227865_b_();
                    if (prevHandParts != null || nextHandParts != null) {
                        if (prevHandParts == null) {
                            prevHandParts = new ModelRenderer[nextHandParts.length];
                            prevStacks = new MatrixStack[nextHandParts.length];
                        }
                        if (nextHandParts == null) {
                            nextHandParts = new ModelRenderer[prevHandParts.length];
                            nextStacks = new MatrixStack[prevHandParts.length];
                        }
                        if (prevHandParts.length < nextHandParts.length) {
                            prevHandParts = Arrays.copyOf(prevHandParts, nextHandParts.length);
                            prevStacks = Arrays.copyOf(prevStacks, nextHandParts.length);
                        }
                        if (nextHandParts.length < prevHandParts.length) {
                            nextHandParts = Arrays.copyOf(nextHandParts, prevHandParts.length);
                            nextStacks = Arrays.copyOf(nextStacks, prevHandParts.length);
                        }
                        handParts = new ModelRenderer[prevHandParts.length];
                        stacks = new MatrixStack[prevHandParts.length];
                        for (int i = 0; i < handParts.length; ++i) {
                            Project.Part oldPart = ModelHelper.createPartFor((ModelRenderer)prevHandParts[i], (boolean)true);
                            Project.Part newPart = ModelHelper.createPartFor((ModelRenderer)nextHandParts[i], (boolean)true);
                            ModelHelper.matchBoxAndChildrenCount((Project.Part)oldPart, (Project.Part)newPart);
                            ModelHelper.matchBoxAndChildrenCount((Project.Part)newPart, (Project.Part)oldPart);
                            handParts[i] = ModelHelper.createModelRenderer((Project.Part)ModelHelper.createInterimPart((Project.Part)oldPart, (Project.Part)newPart, (float)transitionProg), (boolean)true);
                            if (prevStacks[i] != null || nextStacks[i] != null) {
                                MatrixStack.Entry interimStackEntry = RenderHelper.createInterimStackEntry((MatrixStack.Entry)(prevStacks[i] != null ? prevStacks[i].func_227866_c_() : new MatrixStack().func_227866_c_()), (MatrixStack.Entry)(nextStacks[i] != null ? nextStacks[i].func_227866_c_() : new MatrixStack().func_227866_c_()), (float)transitionProg);
                                MatrixStack interimStack = new MatrixStack();
                                MatrixStack.Entry last = interimStack.func_227866_c_();
                                last.func_227870_a_().func_226595_a_(interimStackEntry.func_227870_a_());
                                last.func_227872_b_().func_226118_b_(interimStackEntry.func_227872_b_());
                                stacks[i] = interimStack;
                                continue;
                            }
                            stacks[i] = null;
                        }
                    }
                }
            } else {
                ClientPlayerEntity livingInstance = info.isMorphed() ? info.nextState.getEntityInstance(mc.field_71439_g.field_70170_p, (PlayerEntity)mc.field_71439_g) : mc.field_71439_g;
                EntityRenderer entRenderer = playerRenderer.func_177068_d().func_78713_a((Entity)livingInstance);
                if (entRenderer instanceof LivingRenderer) {
                    stack.func_227860_a_();
                    stack.func_227861_a_(0.0, -500.0, 0.0);
                    MorphRenderHandler.renderLiving((EntityRenderer<? super LivingEntity>)entRenderer, (LivingEntity)livingInstance, stack, buffer, light, partialTick);
                    stack.func_227865_b_();
                    LivingRenderer livingRenderer = (LivingRenderer)entRenderer;
                    EntityModel entityModel = livingRenderer.func_217764_d();
                    HandInfo handInfo = HandHandler.getHandInfo(entityModel.getClass());
                    if (handInfo != null) {
                        HandHandler.renderModelPreHandModelRendererCopy(entityModel, (LivingEntity)livingInstance);
                        handParts = handInfo.getHandParts(handSide, entityModel);
                        stacks = handInfo.getPlacementCorrectors(handSide);
                        texture = entRenderer.func_110775_a((Entity)livingInstance);
                    }
                }
                if (entRenderer instanceof PlayerRenderer && livingInstance instanceof AbstractClientPlayerEntity) {
                    MorphRenderHandler.isRenderingMorph = true;
                    PlayerRenderer morphPlayerRenderer = (PlayerRenderer)entRenderer;
                    if (handSide == HandSide.LEFT) {
                        morphPlayerRenderer.func_229146_b_(stack, buffer, light, (AbstractClientPlayerEntity)livingInstance);
                    } else {
                        morphPlayerRenderer.func_229144_a_(stack, buffer, light, (AbstractClientPlayerEntity)livingInstance);
                    }
                    MorphRenderHandler.isRenderingMorph = false;
                    if (handParts != null && skinAlpha > 0.0f) {
                        HandHandler.renderModelPartsWithTexture(handParts, stacks, stack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)MorphHandler.INSTANCE.getMorphSkinTexture())), light, skinAlpha);
                    }
                    return true;
                }
            }
            if (handParts != null) {
                if (texture != null) {
                    HandHandler.renderModelPartsWithTexture(handParts, stacks, stack, buffer.getBuffer(RenderType.func_228644_e_(texture)), light, 1.0f);
                }
                if (skinAlpha > 0.0f) {
                    HandHandler.renderModelPartsWithTexture(handParts, stacks, stack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)MorphHandler.INSTANCE.getMorphSkinTexture())), light, skinAlpha);
                }
            }
            return true;
        }
        return false;
    }

    private static void renderModelPreHandModelRendererCopy(EntityModel entityModel, LivingEntity livingInstance) {
        entityModel.field_217112_c = 0.0f;
        if (entityModel instanceof BipedModel) {
            ((BipedModel)entityModel).field_228270_o_ = false;
            ((BipedModel)entityModel).field_205061_a = 0.0f;
        }
        float limbSwing = livingInstance.field_184619_aG;
        float prevLimbSwingAmount = livingInstance.field_184618_aE;
        float limbSwingAmount = livingInstance.field_70721_aZ;
        livingInstance.field_184619_aG = 0.0f;
        livingInstance.field_184618_aE = 0.0f;
        livingInstance.field_70721_aZ = 0.0f;
        entityModel.func_225597_a_((Entity)livingInstance, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        livingInstance.field_184619_aG = limbSwing;
        livingInstance.field_184618_aE = prevLimbSwingAmount;
        livingInstance.field_70721_aZ = limbSwingAmount;
    }

    private static void renderModelPartsWithTexture(ModelRenderer[] parts, MatrixStack[] stacks, MatrixStack stack, IVertexBuilder buffer, int light, float alpha) {
        for (int i = 0; i < parts.length; ++i) {
            ModelRenderer part = parts[i];
            if (part == null) continue;
            float prevX = part.field_78795_f;
            part.field_78795_f = 0.0f;
            if (!(!part.field_78806_j || part.field_78804_l.isEmpty() && part.field_78805_m.isEmpty())) {
                stack.func_227860_a_();
                part.func_228307_a_(stack);
                if (stacks[i] != null) {
                    PlacementCorrector.multiplyStackWithStack((MatrixStack)stack, (MatrixStack)stacks[i]);
                }
                part.func_228306_a_(stack.func_227866_c_(), buffer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
                for (ModelRenderer modelrenderer : part.field_78805_m) {
                    modelrenderer.func_228309_a_(stack, buffer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
                }
                stack.func_227865_b_();
            }
            part.field_78795_f = prevX;
        }
    }

    public static void setState(boolean allowed) {
        if (allowed) {
            if (instance == null) {
                instance = new HandHandler();
                MinecraftForge.EVENT_BUS.register((Object)instance);
            }
        } else if (instance != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)instance);
            instance = null;
        }
    }

    @Nullable
    private static HandInfo getHandInfo(Class<? extends EntityModel> clz) {
        if (MODEL_HAND_INFO.containsKey(clz)) {
            return MODEL_HAND_INFO.get(clz);
        }
        HandInfo helper = null;
        Class<? extends EntityModel> clzz = clz.getSuperclass();
        if (clzz != EntityModel.class) {
            helper = HandHandler.getHandInfo(clzz);
        }
        MODEL_HAND_INFO.put(clz, helper);
        return helper;
    }

    public static void loadHandInfos() {
        MODEL_HAND_INFO.clear();
        ArrayList infos = new ArrayList();
        try {
            IOUtil.scourDirectoryForFiles((Path)ResourceHandler.getMorphDir().resolve("hand"), p -> {
                if (p.getFileName().toString().endsWith(".json")) {
                    try {
                        HandInfo handInfo = (HandInfo)GSON.fromJson(FileUtils.readFileToString((File)p.toFile(), (String)"UTF-8"), HandInfo.class);
                        if (handInfo.setup()) {
                            infos.add(handInfo);
                            return true;
                        }
                    }
                    catch (JsonSyntaxException | IOException | IllegalStateException e) {
                        Morph.LOGGER.error("Error reading file: {}", p);
                        e.printStackTrace();
                    }
                    return false;
                }
                return false;
            });
        }
        catch (IOException e) {
            Morph.LOGGER.error("Error reading Hand Infos");
            e.printStackTrace();
        }
        for (HandInfo info : infos) {
            if (MODEL_HAND_INFO.containsKey(info.modelClass)) {
                Morph.LOGGER.warn("Hand Info for {} already exists!", (Object)info.modelClass);
            }
            MODEL_HAND_INFO.put(info.modelClass, info);
        }
        Morph.LOGGER.info("Loaded {} Hand Info(s)", (Object)MODEL_HAND_INFO.size());
        MinecraftForge.EVENT_BUS.post((Event)new MorphLoadResourceEvent(MorphLoadResourceEvent.Type.HAND));
    }
}

