/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.ichun.mods.morph.client.entity.EntityAcquisition;
import me.ichun.mods.morph.client.model.ModelAcquisition;
import me.ichun.mods.morph.client.render.MorphRenderHandler;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class RenderEntityAcquisition
extends EntityRenderer<EntityAcquisition> {
    private final ModelAcquisition model = new ModelAcquisition();

    protected RenderEntityAcquisition(EntityRendererManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.0f;
    }

    public void render(EntityAcquisition acquisition, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        if (acquisition.acquiredCapture != null) {
            EntityRenderer renderer = this.field_76990_c.func_78713_a((Entity)acquisition.livingAcquired);
            Vector3d vector3d = renderer.func_225627_b_((Entity)acquisition.livingAcquired, partialTicks);
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)(acquisition.livingAcquired.field_70142_S - acquisition.field_70142_S), (double)(acquisition.livingAcquired.func_226277_ct_() - acquisition.func_226277_ct_())) + vector3d.func_82615_a();
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)(acquisition.livingAcquired.field_70137_T - acquisition.field_70137_T), (double)(acquisition.livingAcquired.func_226278_cu_() - acquisition.func_226278_cu_())) + vector3d.func_82617_b();
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)(acquisition.livingAcquired.field_70136_U - acquisition.field_70136_U), (double)(acquisition.livingAcquired.func_226281_cx_() - acquisition.func_226281_cx_())) + vector3d.func_82616_c();
            if (acquisition.age <= 10) {
                stack.func_227860_a_();
                stack.func_227861_a_(d0, d1, d2);
                MorphRenderHandler.renderLiving((EntityRenderer<? super LivingEntity>)renderer, acquisition.livingAcquired, stack, buffer, this.field_76990_c.func_229085_a_((Entity)acquisition.livingAcquired, partialTicks), partialTicks);
                stack.func_227865_b_();
                MorphRenderHandler.currentCapture = acquisition.acquiredCapture;
                MorphRenderHandler.currentCapture.infos.clear();
                MorphRenderHandler.renderLiving((EntityRenderer<? super LivingEntity>)renderer, acquisition.livingAcquired, new MatrixStack(), buffer, this.field_76990_c.func_229085_a_((Entity)acquisition.livingAcquired, partialTicks), partialTicks, Morph.configServer.biomassSkinWhilstInvisible);
                MorphRenderHandler.currentCapture = null;
                acquisition.maxRequiredTendrils = acquisition.acquiredCapture.infos.size();
            }
            float skinAlpha = MathHelper.func_76131_a((float)(((float)acquisition.age + partialTicks) / 10.0f), (float)0.0f, (float)1.0f);
            stack.func_227860_a_();
            stack.func_227861_a_(d0, d1, d2);
            acquisition.acquiredCapture.render(stack, buffer, light, OverlayTexture.field_229196_a_, skinAlpha);
            stack.func_227865_b_();
        }
        this.model.render(acquisition, partialTicks, stack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getEntityTexture(acquisition))), light, LivingRenderer.func_229117_c_((LivingEntity)acquisition.livingOrigin, (float)0.0f));
    }

    public boolean shouldRender(EntityAcquisition livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        livingEntityIn.syncWithOriginPosition();
        return super.func_225626_a_((Entity)livingEntityIn, camera, camX, camY, camZ);
    }

    public ResourceLocation getEntityTexture(EntityAcquisition entity) {
        return MorphHandler.INSTANCE.getMorphSkinTexture();
    }

    public static class RenderFactory
    implements IRenderFactory<EntityAcquisition> {
        public EntityRenderer<? super EntityAcquisition> createRenderFor(EntityRendererManager manager) {
            return new RenderEntityAcquisition(manager);
        }
    }
}

