/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.ichun.mods.ichunutil.client.model.util.ModelHelper;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.api.morph.MorphState;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.MorphInfoImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MorphRenderHandler {
    private static float playerShadowSize = -1.0f;
    private static boolean changedShadowSize = false;
    public static ModelRendererCapture currentCapture = null;
    public static boolean isRenderingMorph = false;
    public static boolean denyRenderNameplate = false;

    public static void renderMorphInfo(PlayerEntity player, MorphInfoImpl info, MatrixStack stack, IRenderTypeBuffer buffer, int light, float partialTick) {
        isRenderingMorph = true;
        float morphProgress = info.getMorphProgress(partialTick);
        if (morphProgress < 1.0f) {
            LivingEntity entInstance;
            float skinProg = 1.0f;
            float transitionProgress = info.getTransitionProgressSine(partialTick);
            if (transitionProgress <= 0.0f) {
                entInstance = info.prevState.getEntityInstance(player.field_70170_p, player);
                UUID morphUniqueId = entInstance.func_110124_au();
                entInstance.func_184221_a(player.func_110124_au());
                MorphState.syncEntityWithPlayer(entInstance, player);
                MorphRenderHandler.renderLiving(info.prevState, entInstance, stack, buffer, light, partialTick);
                entInstance.func_184221_a(morphUniqueId);
                skinProg = EntityHelper.sineifyProgress((float)(morphProgress / 0.125f));
            } else if (transitionProgress >= 1.0f) {
                entInstance = info.nextState.getEntityInstance(player.field_70170_p, player);
                UUID morphUniqueId = entInstance.func_110124_au();
                entInstance.func_184221_a(player.func_110124_au());
                MorphState.syncEntityWithPlayer(entInstance, player);
                MorphRenderHandler.renderLiving(info.nextState, entInstance, stack, buffer, light, partialTick);
                entInstance.func_184221_a(morphUniqueId);
                skinProg = 1.0f - EntityHelper.sineifyProgress((float)((morphProgress - 0.875f) / 0.125f));
            }
            int overlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
            MorphRenderHandler.renderTransitionState(player, info, stack, buffer, light, overlay, partialTick, transitionProgress, skinProg);
        } else {
            LivingEntity entInstance = info.nextState.getEntityInstance(player.field_70170_p, player);
            UUID morphUniqueId = entInstance.func_110124_au();
            entInstance.func_184221_a(player.func_110124_au());
            MorphState.syncEntityWithPlayer(entInstance, player);
            entInstance.func_184221_a(morphUniqueId);
            MorphRenderHandler.renderLiving(info.nextState, entInstance, stack, buffer, light, partialTick);
        }
        isRenderingMorph = false;
    }

    private static void renderLiving(MorphState state, LivingEntity living, MatrixStack stack, IRenderTypeBuffer buffer, int light, float partialTick) {
        MorphRenderHandler.renderLiving(state, living, stack, buffer, light, partialTick, false);
    }

    private static void renderLiving(MorphState state, LivingEntity living, MatrixStack stack, IRenderTypeBuffer buffer, int light, float partialTick, boolean forceDuringInvisibility) {
        EntityRenderer livingRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)living);
        if (livingRenderer != null) {
            MorphRenderHandler.renderLiving((EntityRenderer<? super LivingEntity>)livingRenderer, living, stack, buffer, light, partialTick, forceDuringInvisibility);
            state.renderedShadowSize = living instanceof MobEntity && living.func_70631_g_() ? livingRenderer.field_76989_e * 0.5f : livingRenderer.field_76989_e;
        }
    }

    public static void renderLiving(EntityRenderer<? super LivingEntity> renderer, LivingEntity living, MatrixStack stack, IRenderTypeBuffer buffer, int light, float partialTick, boolean forceDuringInvisibility) {
        boolean isInvisible = living.func_82150_aj();
        if (forceDuringInvisibility && isInvisible) {
            living.func_82142_c(false);
        }
        MorphRenderHandler.renderLiving(renderer, living, stack, buffer, light, partialTick);
        if (forceDuringInvisibility && isInvisible) {
            living.func_82142_c(true);
        }
    }

    public static void renderLiving(EntityRenderer<? super LivingEntity> renderer, LivingEntity living, MatrixStack stack, IRenderTypeBuffer buffer, int light, float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        if (living instanceof AbstractClientPlayerEntity) {
            final AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)living;
            if (mc.func_147114_u().func_175102_a(player.func_146103_bH().getId()) == null) {
                SPlayerListItemPacket spoof = new SPlayerListItemPacket(){

                    public List<SPlayerListItemPacket.AddPlayerData> func_179767_a() {
                        return Lists.newArrayList((Object[])new SPlayerListItemPacket.AddPlayerData[]{new SPlayerListItemPacket.AddPlayerData((SPlayerListItemPacket)this, player.func_146103_bH(), -100, GameType.ADVENTURE, (ITextComponent)new StringTextComponent(player.func_146103_bH().getName()))});
                    }
                };
                NetworkPlayerInfo info = new NetworkPlayerInfo((SPlayerListItemPacket.AddPlayerData)spoof.func_179767_a().get(0));
                mc.func_147114_u().field_147310_i.put(player.func_146103_bH().getId(), info);
            }
        }
        float yaw = MathHelper.func_219799_g((float)partialTick, (float)living.field_70126_B, (float)living.field_70177_z);
        stack.func_227860_a_();
        if (living instanceof EnderDragonEntity) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        renderer.func_225623_a_((Entity)living, yaw, partialTick, stack, buffer, light);
        stack.func_227865_b_();
        if (living instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)living;
            NetworkPlayerInfo playerInfo = mc.func_147114_u().func_175102_a(player.func_146103_bH().getId());
            if (playerInfo != null && playerInfo.func_178853_c() == -100 && playerInfo.func_178848_b() == GameType.ADVENTURE) {
                mc.func_147114_u().field_147310_i.remove(player.func_146103_bH().getId());
            }
        }
    }

    public static void renderTransitionState(PlayerEntity player, MorphInfoImpl info, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay, float partialTick, float transitionProgress, float skinAlpha) {
        if (info.transitionState == null) {
            info.transitionState = new MorphTransitionState();
        }
        info.transitionState.renderTransitionState(player, info, stack, buffer, light, overlay, partialTick, transitionProgress, skinAlpha);
    }

    public static void restoreShadowSize(PlayerRenderer renderer) {
        if (playerShadowSize == -1.0f) {
            playerShadowSize = renderer.field_76989_e;
        }
        if (changedShadowSize) {
            changedShadowSize = false;
            renderer.field_76989_e = playerShadowSize;
        }
    }

    public static void setShadowSize(PlayerRenderer renderer, MorphInfo info, float partialTick) {
        float morphProgress = info.getMorphProgress(partialTick);
        if (morphProgress < 1.0f) {
            float prevSize = info.prevState.renderedShadowSize;
            float nextSize = info.nextState.renderedShadowSize;
            renderer.field_76989_e = prevSize + (nextSize - prevSize) * info.getTransitionProgressSine(partialTick);
        } else {
            renderer.field_76989_e = info.nextState.renderedShadowSize;
        }
        changedShadowSize = true;
    }

    public static class ModelRendererCapture {
        private final HashMap<ModelRenderer, CaptureInfo.ModelPart> modelToPart = new HashMap();
        public ArrayList<CaptureInfo> infos = new ArrayList();

        public void capture(ModelRenderer renderer, MatrixStack stack) {
            if (this.modelToPart.containsKey(renderer)) {
                this.infos.add(new CaptureInfo(stack.func_227866_c_(), this.modelToPart.get(renderer)));
            } else {
                Project.Part part = ModelHelper.createPartFor((ModelRenderer)renderer, (boolean)false);
                part.rotAZ = 0.0f;
                part.rotAY = 0.0f;
                part.rotAX = 0.0f;
                part.rotPZ = 0.0f;
                part.rotPY = 0.0f;
                part.rotPX = 0.0f;
                part.children.clear();
                CaptureInfo.ModelPart modelPart = new CaptureInfo.ModelPart(part);
                this.infos.add(new CaptureInfo(stack.func_227866_c_(), modelPart));
                this.modelToPart.put(renderer, modelPart);
                for (Project.Part.Box box : part.boxes) {
                    box.expandX += 0.002f;
                    box.expandY += 0.002f;
                    box.expandZ += 0.002f;
                }
            }
        }

        public ArrayList<CaptureInfo> combineTowards(MatrixStack.Entry prevMid, MatrixStack.Entry nextMid, ModelRendererCapture other, float transitionProgress) {
            Project.Part part;
            ArrayList<CaptureInfo> prevInfo = this.infos;
            ArrayList<CaptureInfo> nextInfo = other.infos;
            while (prevInfo.size() < nextInfo.size()) {
                part = new Project.Part(null, 0);
                part.boxes.clear();
                prevInfo.add(new CaptureInfo(prevMid, new CaptureInfo.ModelPart(part)));
            }
            while (nextInfo.size() < prevInfo.size()) {
                part = new Project.Part(null, 0);
                part.boxes.clear();
                nextInfo.add(new CaptureInfo(nextMid, new CaptureInfo.ModelPart(part)));
            }
            ArrayList<CaptureInfo> transitionInfos = new ArrayList<CaptureInfo>();
            for (int i = 0; i < prevInfo.size(); ++i) {
                Project.Part oldPart = prevInfo.get((int)i).modelPart.part;
                Project.Part newPart = nextInfo.get((int)i).modelPart.part;
                ModelHelper.matchBoxesCount((Project.Part)oldPart, (Project.Part)newPart);
                ModelHelper.matchBoxesCount((Project.Part)newPart, (Project.Part)oldPart);
                transitionInfos.add(new CaptureInfo(RenderHelper.createInterimStackEntry((MatrixStack.Entry)prevInfo.get((int)i).e, (MatrixStack.Entry)nextInfo.get((int)i).e, (float)transitionProgress), new CaptureInfo.ModelPart(ModelHelper.createInterimPart((Project.Part)oldPart, (Project.Part)newPart, (float)transitionProgress))));
            }
            return transitionInfos;
        }

        public void render(MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay, float skinAlpha) {
            this.render(stack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)MorphHandler.INSTANCE.getMorphSkinTexture())), light, overlay, skinAlpha);
        }

        public void render(MatrixStack stack, IVertexBuilder vertexBuilder, int light, int overlay, float skinAlpha) {
            MatrixStack newStack = stack != null ? stack : new MatrixStack();
            for (CaptureInfo info : this.infos) {
                newStack.func_227860_a_();
                MatrixStack.Entry entLast = newStack.func_227866_c_();
                MatrixStack.Entry correctorLast = info.e;
                entLast.func_227870_a_().func_226595_a_(correctorLast.func_227870_a_());
                entLast.func_227872_b_().func_226118_b_(correctorLast.func_227872_b_());
                info.createAndRender(newStack, vertexBuilder, light, overlay, 1.0f, 1.0f, 1.0f, skinAlpha);
                newStack.func_227865_b_();
            }
        }

        public static class CaptureInfo {
            public final MatrixStack.Entry e;
            public final ModelPart modelPart;

            public CaptureInfo(MatrixStack.Entry e, ModelPart modelPart) {
                this.e = e;
                this.modelPart = modelPart;
            }

            public void createAndRender(MatrixStack stack, IVertexBuilder buffer, int light, int overlay, float red, float green, float blue, float alpha) {
                if (this.modelPart.model == null) {
                    this.modelPart.model = ModelHelper.createModelRenderer((Project.Part)this.modelPart.part);
                }
                this.modelPart.model.func_228309_a_(stack, buffer, light, overlay, red, green, blue, alpha);
            }

            private static class ModelPart {
                public final Project.Part part;
                public ModelRenderer model;

                private ModelPart(Project.Part part) {
                    this.part = part;
                }
            }
        }
    }

    public static class MorphTransitionState {
        protected ModelRendererCapture prevModel;
        protected ModelRendererCapture nextModel;

        public void renderTransitionState(PlayerEntity player, MorphInfo info, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay, float partialTick, float transitionProgress, float skinAlpha) {
            if (transitionProgress <= 0.0f) {
                if (this.prevModel == null) {
                    currentCapture = this.prevModel = new ModelRendererCapture();
                } else {
                    currentCapture = this.prevModel;
                    MorphRenderHandler.currentCapture.infos.clear();
                }
                LivingEntity livingInstance = info.prevState.getEntityInstance(player.field_70170_p, player);
                MorphRenderHandler.renderLiving(info.prevState, livingInstance, stack, buffer, light, partialTick, Morph.configServer.biomassSkinWhilstInvisible);
                currentCapture = null;
                this.prevModel.render(null, buffer, light, overlay, skinAlpha);
            } else if (transitionProgress >= 1.0f) {
                if (this.nextModel == null) {
                    currentCapture = this.nextModel = new ModelRendererCapture();
                } else {
                    currentCapture = this.nextModel;
                    MorphRenderHandler.currentCapture.infos.clear();
                }
                LivingEntity livingInstance = info.nextState.getEntityInstance(player.field_70170_p, player);
                MorphRenderHandler.renderLiving(info.nextState, livingInstance, stack, buffer, light, partialTick, Morph.configServer.biomassSkinWhilstInvisible);
                currentCapture = null;
                this.nextModel.render(null, buffer, light, overlay, skinAlpha);
            } else {
                denyRenderNameplate = true;
                if (this.prevModel == null) {
                    currentCapture = this.prevModel = new ModelRendererCapture();
                } else {
                    currentCapture = this.prevModel;
                    MorphRenderHandler.currentCapture.infos.clear();
                }
                LivingEntity prevLivingInstance = info.prevState.getEntityInstance(player.field_70170_p, player);
                MorphRenderHandler.renderLiving(info.prevState, prevLivingInstance, stack, buffer, light, partialTick, Morph.configServer.biomassSkinWhilstInvisible);
                if (this.nextModel == null) {
                    currentCapture = this.nextModel = new ModelRendererCapture();
                } else {
                    currentCapture = this.nextModel;
                    MorphRenderHandler.currentCapture.infos.clear();
                }
                LivingEntity nextLivingInstance = info.nextState.getEntityInstance(player.field_70170_p, player);
                MorphRenderHandler.renderLiving(info.nextState, nextLivingInstance, stack, buffer, light, partialTick, Morph.configServer.biomassSkinWhilstInvisible);
                currentCapture = null;
                denyRenderNameplate = false;
                stack.func_227860_a_();
                stack.func_227861_a_(0.0, (double)(prevLivingInstance.func_213302_cg() / 2.0f), 0.0);
                MatrixStack.Entry prevMid = stack.func_227866_c_();
                stack.func_227865_b_();
                stack.func_227860_a_();
                stack.func_227861_a_(0.0, (double)(nextLivingInstance.func_213302_cg() / 2.0f), 0.0);
                MatrixStack.Entry nextMid = stack.func_227866_c_();
                stack.func_227865_b_();
                ModelRendererCapture transitionCapture = new ModelRendererCapture();
                transitionCapture.infos = this.prevModel.combineTowards(prevMid, nextMid, this.nextModel, transitionProgress);
                transitionCapture.render(null, buffer, light, overlay, skinAlpha);
            }
        }
    }
}

