/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.gui.nbt.window;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementCheckbox;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextField;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.morph.api.mob.nbt.NbtModifier;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.client.gui.mob.window.WindowMobData;
import me.ichun.mods.morph.client.gui.nbt.WorkspaceNbt;
import me.ichun.mods.morph.client.gui.window.element.ElementRenderEntity;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.nbt.NbtHandler;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.io.FileUtils;

public class WindowNbt
extends Window<WorkspaceNbt> {
    public WindowNbt(WorkspaceNbt parent) {
        super((IWindows)parent);
        this.disableBringToFront();
        this.disableDockingEntirely();
        this.disableDrag();
        this.disableDragResize();
        this.disableTitle();
        this.setId("windowNbt");
        this.setView(new ViewNbt(this));
    }

    public ViewNbt getCurrentView() {
        return (ViewNbt)this.currentView;
    }

    public static class ViewNbt
    extends View<WindowNbt> {
        public NbtModifier parentModifier;
        public NbtModifier targetModifier;
        public CompoundNBT targetTag;
        public ElementList<?> listClass;
        public ElementList<?> listKeys;
        public ElementRenderEntity rendModEnt;

        public ViewNbt(@Nonnull WindowNbt parent) {
            super((Window)parent, "morph.gui.workspace.nbt.title");
            LivingEntity target = ((WorkspaceNbt)parent.parent).target;
            this.parentModifier = NbtHandler.getModifierFor(target.getClass().getSuperclass());
            this.targetModifier = (NbtModifier)ResourceHandler.GSON.fromJson(ResourceHandler.GSON.toJson((Object)NbtHandler.getModifierFor(target)), NbtModifier.class);
            this.targetModifier.toKeep = new HashSet<String>(this.parentModifier.toKeep);
            this.targetModifier.keyToModifier = (HashMap)ResourceHandler.GSON.fromJson(ResourceHandler.GSON.toJson(this.parentModifier.keyToModifier), new TypeToken<HashMap<String, NbtModifier.Modifier>>(){}.getType());
            int padding = 6;
            this.rendModEnt = new ElementRenderEntity((Fragment)this);
            this.rendModEnt.setSize(80, 80);
            this.rendModEnt.constraints().right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding).top((IConstrainable)this, Constraint.Property.Type.TOP, padding + 10);
            this.elements.add(this.rendModEnt);
            ElementRenderEntity rendEnt = new ElementRenderEntity((Fragment)this);
            rendEnt.setSize(80, 80);
            rendEnt.setEntityToRender(((WorkspaceNbt)parent.parent).target);
            rendEnt.constraints().right((IConstrainable)this.rendModEnt, Constraint.Property.Type.LEFT, padding).top((IConstrainable)this.rendModEnt, Constraint.Property.Type.TOP, 0);
            this.elements.add(rendEnt);
            ElementTextWrapper textModEnt = new ElementTextWrapper((Fragment)this);
            textModEnt.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.asMorphEntity", (Object[])new Object[0]));
            textModEnt.constraints().left((IConstrainable)this.rendModEnt, Constraint.Property.Type.LEFT, -1).bottom((IConstrainable)this.rendModEnt, Constraint.Property.Type.TOP, 0).right((IConstrainable)this.rendModEnt, Constraint.Property.Type.RIGHT, 0);
            this.elements.add(textModEnt);
            ElementTextWrapper textEnt = new ElementTextWrapper((Fragment)this);
            textEnt.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.targetEntity", (Object[])new Object[0]));
            textEnt.constraints().left((IConstrainable)rendEnt, Constraint.Property.Type.LEFT, -1).bottom((IConstrainable)rendEnt, Constraint.Property.Type.TOP, 0).right((IConstrainable)rendEnt, Constraint.Property.Type.RIGHT, 0);
            this.elements.add(textEnt);
            ElementButton buttonCancel = new ElementButton((Fragment)this, "gui.cancel", btn -> ((WorkspaceNbt)parent.parent).func_231175_as__());
            buttonCancel.setSize(60, 20);
            buttonCancel.constraints().bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding);
            this.elements.add(buttonCancel);
            ElementButton buttonExport = new ElementButton((Fragment)this, "morph.gui.workspace.resources.export", btn -> {
                if (this.export()) {
                    if (Screen.func_231173_s_()) {
                        Path dir = ResourceHandler.getMorphDir().resolve("export");
                        Util.func_110647_a().func_195641_a(dir.toFile());
                    }
                    ((WorkspaceNbt)parent.parent).func_231175_as__();
                }
            });
            buttonExport.setSize(60, 20);
            buttonExport.constraints().bottom((IConstrainable)buttonCancel, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)buttonCancel, Constraint.Property.Type.LEFT, 6);
            this.elements.add(buttonExport);
            ElementButton buttonHelp = new ElementButton((Fragment)this, "?", btn -> {
                if (Screen.func_231173_s_()) {
                    Path dir = ResourceHandler.getMorphDir().resolve("export");
                    if (!Files.exists(dir, new LinkOption[0])) {
                        dir = ResourceHandler.getMorphDir();
                    }
                    Util.func_110647_a().func_195641_a(dir.toFile());
                } else {
                    WindowPopup.popup((Workspace)((Workspace)parent.parent), (double)0.7, (double)190.0, null, (String[])new String[]{I18n.func_135052_a((String)"morph.gui.workspace.nbt.help", (Object[])new Object[0])});
                }
            });
            buttonHelp.setSize(20, 20);
            buttonHelp.constraints().bottom((IConstrainable)buttonCancel, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)buttonExport, Constraint.Property.Type.LEFT, 6);
            this.elements.add(buttonHelp);
            ElementTextWrapper textClass = new ElementTextWrapper((Fragment)this);
            textClass.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.forClass", (Object[])new Object[0]));
            textClass.constraints().left((IConstrainable)this, Constraint.Property.Type.LEFT, padding - 1).top((IConstrainable)textModEnt, Constraint.Property.Type.TOP, 0);
            this.elements.add(textClass);
            ElementScrollBar svClass = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            svClass.constraints().top((IConstrainable)textClass, Constraint.Property.Type.BOTTOM, -1).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)textClass, Constraint.Property.Type.LEFT, -100);
            this.elements.add(svClass);
            this.listClass = new ElementList((Fragment)this).setScrollVertical(svClass);
            this.listClass.setSize(80, 20);
            this.listClass.constraints().left((IConstrainable)textClass, Constraint.Property.Type.LEFT, 0).top((IConstrainable)textClass, Constraint.Property.Type.BOTTOM, -1).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)svClass, Constraint.Property.Type.LEFT, 0);
            for (Class<?> clz = target.getClass(); clz != Entity.class; clz = clz.getSuperclass()) {
                ElementList.Item item = this.listClass.addItem(clz).addTextWrapper(clz.getSimpleName());
                if (clz == target.getClass()) {
                    item.selected = true;
                    this.listClass.func_231035_a_((IGuiEventListener)item);
                }
                ElementTextWrapper text = (ElementTextWrapper)item.elements.get(0);
                text.setTooltip(clz.getName());
            }
            this.elements.add(this.listClass);
            ElementScrollBar svKeys = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            svKeys.constraints().top((IConstrainable)svClass, Constraint.Property.Type.TOP, 0).bottom((IConstrainable)svClass, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)rendEnt, Constraint.Property.Type.LEFT, padding);
            this.elements.add(svKeys);
            this.listKeys = new ElementList((Fragment)this).setScrollVertical(svKeys);
            this.listKeys.constraints().left((IConstrainable)svClass, Constraint.Property.Type.RIGHT, padding).right((IConstrainable)svKeys, Constraint.Property.Type.LEFT, 0).top(this.listClass, Constraint.Property.Type.TOP, 0).bottom(this.listClass, Constraint.Property.Type.BOTTOM, 0);
            this.elements.add(this.listKeys);
            ElementTextWrapper textKeys = new ElementTextWrapper((Fragment)this);
            textKeys.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.nbtKeys", (Object[])new Object[0]));
            textKeys.constraints().left(this.listKeys, Constraint.Property.Type.LEFT, -1).bottom(this.listKeys, Constraint.Property.Type.TOP, -1);
            this.elements.add(textKeys);
            ElementTextWrapper textKeep = new ElementTextWrapper((Fragment)this);
            textKeep.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.keep", (Object[])new Object[0]));
            textKeep.setTooltip(I18n.func_135052_a((String)"morph.gui.workspace.nbt.keep.tooltip", (Object[])new Object[0]));
            textKeep.constraints().left((IConstrainable)rendEnt, Constraint.Property.Type.LEFT, 1).top((IConstrainable)rendEnt, Constraint.Property.Type.BOTTOM, padding);
            this.elements.add(textKeep);
            ElementCheckbox checkKeep = new ElementCheckbox((Fragment)this, I18n.func_135052_a((String)"morph.gui.workspace.nbt.keep.tooltip", (Object[])new Object[0]), c -> {
                if (!c.toggleState && !((ElementTextField)this.getById("fieldValue")).getText().isEmpty()) {
                    c.toggleState = true;
                }
                this.setModifierFields();
            });
            checkKeep.constraints().left((IConstrainable)textKeep, Constraint.Property.Type.RIGHT, 4).top((IConstrainable)textKeep, Constraint.Property.Type.TOP, 4);
            checkKeep.setId("checkKeep");
            this.elements.add(checkKeep);
            ElementTextWrapper textRemove = new ElementTextWrapper((Fragment)this);
            textRemove.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.forceRemove", (Object[])new Object[0]));
            textRemove.setTooltip(I18n.func_135052_a((String)"morph.gui.workspace.nbt.forceRemove.tooltip", (Object[])new Object[0]));
            textRemove.constraints().left((IConstrainable)checkKeep, Constraint.Property.Type.RIGHT, padding).top((IConstrainable)textKeep, Constraint.Property.Type.TOP, 0);
            this.elements.add(textRemove);
            ElementCheckbox checkRemove = new ElementCheckbox((Fragment)this, I18n.func_135052_a((String)"morph.gui.workspace.nbt.forceRemove.tooltip", (Object[])new Object[0]), c -> {
                if (c.toggleState) {
                    ElementCheckbox keep = (ElementCheckbox)this.getById("checkKeep");
                    keep.toggleState = true;
                    ((ElementTextField)this.getById("fieldValue")).setText("");
                }
                this.setModifierFields();
            });
            checkRemove.constraints().left((IConstrainable)textRemove, Constraint.Property.Type.RIGHT, 4).top((IConstrainable)checkKeep, Constraint.Property.Type.TOP, 0);
            checkRemove.setId("checkRemove");
            this.elements.add(checkRemove);
            ElementTextWrapper textValue = new ElementTextWrapper((Fragment)this);
            textValue.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.forceValue", (Object[])new Object[0]));
            textValue.setTooltip(I18n.func_135052_a((String)"morph.gui.workspace.nbt.forceValue.tooltip", (Object[])new Object[0]));
            textValue.constraints().left((IConstrainable)textKeep, Constraint.Property.Type.LEFT, 0).top((IConstrainable)textKeep, Constraint.Property.Type.BOTTOM, 4);
            this.elements.add(textValue);
            Consumer<String> responder = s -> this.setModifierFields();
            ElementTextField fieldValue = new ElementTextField((Fragment)this);
            fieldValue.setTooltip(I18n.func_135052_a((String)"morph.gui.workspace.nbt.forceValue.tooltip", (Object[])new Object[0]));
            fieldValue.setId("fieldValue");
            fieldValue.setResponder(responder).setEnterResponder(responder);
            fieldValue.constraints().left((IConstrainable)textValue, Constraint.Property.Type.LEFT, 0).top((IConstrainable)textValue, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)this.rendModEnt, Constraint.Property.Type.RIGHT, 0);
            this.elements.add(fieldValue);
            ElementTextWrapper textMod = new ElementTextWrapper((Fragment)this);
            textMod.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.nbt.modRequired", (Object[])new Object[0]));
            textMod.setTooltip(I18n.func_135052_a((String)"morph.gui.workspace.nbt.modRequired.tooltip", (Object[])new Object[0]));
            textMod.constraints().left((IConstrainable)textValue, Constraint.Property.Type.LEFT, 0).top((IConstrainable)fieldValue, Constraint.Property.Type.BOTTOM, 4);
            this.elements.add(textMod);
            ElementTextField fieldMod = new ElementTextField((Fragment)this);
            fieldMod.setTooltip(I18n.func_135052_a((String)"morph.gui.workspace.nbt.modRequired.tooltip", (Object[])new Object[0]));
            fieldMod.setId("fieldMod");
            fieldMod.setResponder(responder).setEnterResponder(responder);
            fieldMod.constraints().left((IConstrainable)textValue, Constraint.Property.Type.LEFT, 0).top((IConstrainable)textMod, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)this.rendModEnt, Constraint.Property.Type.RIGHT, 0);
            this.elements.add(fieldMod);
            this.targetTag = new CompoundNBT();
            MorphVariant.writeDefaults(target, this.targetTag);
            target.func_213281_b(this.targetTag);
            this.addModifierKeys(this.targetModifier, this.listKeys);
            this.updateListKeyColours();
            this.rendModEnt.setEntityToRender(this.compileAndApply());
        }

        public void addModifierKeys(NbtModifier modifier, ElementList elementList) {
            LinkedHashMap<String, ArrayList<NbtModifier.Modifier>> modifiers = new LinkedHashMap<String, ArrayList<NbtModifier.Modifier>>();
            modifiers.computeIfAbsent("", k -> {
                ArrayList<NbtModifier.Modifier> list = new ArrayList<NbtModifier.Modifier>();
                for (String s : modifier.toKeep) {
                    NbtModifier.Modifier m = new NbtModifier.Modifier();
                    m.key = s;
                    m.keep = true;
                    list.add(m);
                }
                list.addAll(modifier.keyToModifier.values());
                NbtModifier.Modifier m = new NbtModifier.Modifier();
                m.value = "PARENT_BREAK";
                m.key = "PARENT_BREAK";
                list.add(m);
                list.addAll(modifier.modifiers);
                return list;
            });
            modifiers.putAll(modifier.modSpecificModifiers);
            this.addModifierInfo(modifiers, this.targetTag, elementList, null, 0);
        }

        public void addModifierInfo(LinkedHashMap<String, ArrayList<NbtModifier.Modifier>> modifiers, CompoundNBT tag, ElementList<?> list, ModifierInfo parentInfo, int depth) {
            for (Map.Entry e : tag.field_74784_a.entrySet()) {
                boolean handledElsewhere = true;
                String key = (String)e.getKey();
                ModifierInfo info = null;
                for (Map.Entry<String, ArrayList<NbtModifier.Modifier>> me : modifiers.entrySet()) {
                    String mod = me.getKey().isEmpty() ? null : me.getKey();
                    ArrayList<NbtModifier.Modifier> mods = me.getValue();
                    for (NbtModifier.Modifier modifier : mods) {
                        if (key.equals(modifier.key)) {
                            info = new ModifierInfo(parentInfo, key, (INBT)e.getValue(), new ModifierInfo.Info(mod, modifier, handledElsewhere));
                            continue;
                        }
                        if (!"PARENT_BREAK".equals(modifier.key) || !modifier.key.equals(modifier.value)) continue;
                        handledElsewhere = false;
                    }
                }
                if (info == null) {
                    info = new ModifierInfo(parentInfo, (String)e.getKey(), (INBT)e.getValue(), new ModifierInfo.Info(null, null, false));
                }
                if (parentInfo != null) {
                    parentInfo.addChild(info);
                }
                StringBuilder prefix = new StringBuilder();
                for (int i = 0; i < depth; ++i) {
                    prefix.append("- ");
                }
                list.addItem(info).addTextWrapper(prefix + (String)e.getKey()).setSelectionHandler(this::updateModifierInputs);
                if (!(e.getValue() instanceof CompoundNBT)) continue;
                LinkedHashMap<String, ArrayList<NbtModifier.Modifier>> babyMods = new LinkedHashMap<String, ArrayList<NbtModifier.Modifier>>();
                if (info.currentInfo.modifier != null && info.currentInfo.modifier.nestedModifiers != null) {
                    babyMods.put(info.currentInfo.requiredMod == null ? "" : info.currentInfo.requiredMod, info.currentInfo.modifier.nestedModifiers);
                }
                this.addModifierInfo(babyMods, (CompoundNBT)e.getValue(), list, info, depth + 1);
            }
        }

        public void updateModifierInputs(ElementList.Item<ModifierInfo> item) {
            if (!item.selected) {
                ((ElementCheckbox)this.getById((String)"checkKeep")).toggleState = false;
                ((ElementCheckbox)this.getById((String)"checkRemove")).toggleState = false;
                ((ElementTextField)this.getById("fieldValue")).setText("");
                ((ElementTextField)this.getById("fieldMod")).setText("");
                return;
            }
            ModifierInfo info = (ModifierInfo)item.getObject();
            NbtModifier.Modifier modifier = info.currentInfo.modifier;
            ((ElementCheckbox)this.getById((String)"checkKeep")).toggleState = modifier != null && modifier.keep != null || modifier != null && modifier.value != null;
            ((ElementCheckbox)this.getById((String)"checkRemove")).toggleState = modifier != null && modifier.keep != null && modifier.keep == false;
            ((ElementTextField)this.getById("fieldValue")).setText(modifier != null && modifier.value != null ? modifier.value : "");
            ((ElementTextField)this.getById("fieldMod")).setText(info.currentInfo.requiredMod != null ? info.currentInfo.requiredMod : "");
        }

        public void setModifierFields() {
            String mod = ((ElementTextField)this.getById("fieldMod")).getText();
            if (mod.isEmpty()) {
                mod = null;
            }
            NbtModifier.Modifier modifier = new NbtModifier.Modifier();
            modifier.value = ((ElementTextField)this.getById("fieldValue")).getText();
            if (modifier.value.isEmpty()) {
                modifier.value = null;
            }
            modifier.keep = modifier.value == null && ((ElementCheckbox)this.getById((String)"checkKeep")).toggleState ? Boolean.valueOf(!((ElementCheckbox)this.getById((String)"checkRemove")).toggleState) : null;
            ModifierInfo.Info newInfo = new ModifierInfo.Info(mod, modifier, false);
            for (ElementList.Item item : this.listKeys.items) {
                if (!item.selected) continue;
                ModifierInfo info = (ModifierInfo)item.getObject();
                modifier.key = info.key;
                if (info.originalInfo.handledElsewhere) {
                    boolean sameValue;
                    boolean sameMod = info.originalInfo.requiredMod == null && newInfo.requiredMod == null || info.originalInfo.requiredMod != null && info.originalInfo.requiredMod.equals(newInfo.requiredMod);
                    boolean bl = sameValue = info.originalInfo.modifier.value == null && modifier.value == null || info.originalInfo.modifier.value != null && info.originalInfo.modifier.value.equals(modifier.value);
                    if (modifier.keep == null && modifier.value == null || sameMod && info.originalInfo.modifier.keep == modifier.keep && sameValue) {
                        info.currentInfo = info.originalInfo;
                        break;
                    }
                }
                if (modifier.keep == null && modifier.value == null) {
                    newInfo = new ModifierInfo.Info(mod, null, false);
                }
                info.currentInfo = newInfo;
                break;
            }
            this.updateListKeyColours();
            this.rendModEnt.setEntityToRender(this.compileAndApply());
        }

        private void updateListKeyColours() {
            for (ElementList.Item item : this.listKeys.items) {
                ElementTextWrapper text = (ElementTextWrapper)item.elements.get(0);
                ModifierInfo modInfo = (ModifierInfo)item.getObject();
                if (modInfo.currentInfo.modifier == null) {
                    text.setColor(Integer.valueOf(0xAAAAAA));
                    text.setTooltip((String)text.getText().get(0) + "\n\n" + I18n.func_135052_a((String)"morph.gui.workspace.nbt.nbtType", (Object[])new Object[0]) + modInfo.inbt.func_225647_b_().func_225648_a_() + "\n\n" + I18n.func_135052_a((String)"morph.gui.workspace.nbt.stripped", (Object[])new Object[0]));
                    continue;
                }
                if (modInfo.currentInfo.handledElsewhere) {
                    text.setColor(Integer.valueOf(0xFFFF55));
                    text.setTooltip((String)text.getText().get(0) + "\n\n" + I18n.func_135052_a((String)"morph.gui.workspace.nbt.nbtType", (Object[])new Object[0]) + modInfo.inbt.func_225647_b_().func_225648_a_() + "\n\n" + I18n.func_135052_a((String)"morph.gui.workspace.nbt.handledElsewhere", (Object[])new Object[0]));
                    continue;
                }
                text.setColor(null);
                text.setTooltip((String)text.getText().get(0) + "\n\n" + I18n.func_135052_a((String)"morph.gui.workspace.nbt.nbtType", (Object[])new Object[0]) + modInfo.inbt.func_225647_b_().func_225648_a_() + "\n\n" + I18n.func_135052_a((String)"morph.gui.workspace.nbt.kept", (Object[])new Object[0]));
            }
        }

        public LivingEntity compileAndApply() {
            LivingEntity target = ((WorkspaceNbt)((WindowNbt)this.parentFragment).parent).target;
            Class<?> clz = target.getClass();
            NbtModifier modifier = this.compileModifier();
            NbtModifier ori = NbtHandler.NBT_MODIFIERS.get(clz);
            NbtHandler.NBT_MODIFIERS.put(clz, modifier);
            MorphVariant variant = MorphHandler.INSTANCE.createVariant(target);
            NbtHandler.NBT_MODIFIERS.put(clz, ori);
            if (variant != null) {
                return variant.createEntityInstance(Minecraft.func_71410_x().field_71439_g.field_70170_p, (PlayerEntity)null);
            }
            LivingEntity entInstance = (LivingEntity)EntityType.field_200784_X.func_200721_a(target.field_70170_p);
            entInstance.func_200203_b((ITextComponent)new StringTextComponent("Invalid Morph Pig"));
            return entInstance;
        }

        public NbtModifier compileModifier() {
            LivingEntity target = ((WorkspaceNbt)((WindowNbt)this.parentFragment).parent).target;
            Class<?> clz = target.getClass();
            NbtModifier modifier = new NbtModifier();
            modifier.toKeep = new HashSet<String>(this.parentModifier.toKeep);
            modifier.keyToModifier = (HashMap)ResourceHandler.GSON.fromJson(ResourceHandler.GSON.toJson(this.parentModifier.keyToModifier), new TypeToken<HashMap<String, NbtModifier.Modifier>>(){}.getType());
            for (Map.Entry<Class<?>, NbtModifier> e : NbtHandler.NBT_MODIFIERS_INTERFACES.entrySet()) {
                if (!e.getKey().isAssignableFrom(clz)) continue;
                modifier.toKeep.addAll(e.getValue().toKeep);
                modifier.keyToModifier.putAll(e.getValue().keyToModifier);
            }
            HashMap<ModifierInfo, NbtModifier.Modifier> modifiers = new HashMap<ModifierInfo, NbtModifier.Modifier>();
            for (ElementList.Item item : this.listKeys.items) {
                ModifierInfo modInfo = (ModifierInfo)item.getObject();
                modifiers.put(modInfo, modInfo.currentInfo.modifier);
                if (modInfo.currentInfo.handledElsewhere || modInfo.currentInfo.modifier == null) continue;
                if (modInfo.currentInfo.requiredMod == null) {
                    if (modInfo.parent != null) {
                        ModifierInfo parent = modInfo.parent;
                        NbtModifier.Modifier rootMod = modInfo.currentInfo.modifier;
                        while (parent != null) {
                            NbtModifier.Modifier parentMod = modifiers.computeIfAbsent(parent, parentKey -> {
                                NbtModifier.Modifier mod = new NbtModifier.Modifier();
                                mod.key = parentKey.key;
                                return mod;
                            });
                            if (parentMod.nestedModifiers == null) {
                                parentMod.nestedModifiers = new ArrayList();
                            }
                            if (!parentMod.nestedModifiers.contains(rootMod)) {
                                parentMod.nestedModifiers.add(rootMod);
                            }
                            rootMod = parentMod;
                            parent = parent.parent;
                        }
                        modifier.modifiers.add(rootMod);
                        this.combineChildMods(modifier.modifiers);
                        continue;
                    }
                    modifier.modifiers.add(modInfo.currentInfo.modifier);
                    continue;
                }
                ArrayList modModifiers = modifier.modSpecificModifiers.computeIfAbsent(modInfo.currentInfo.requiredMod, k -> new ArrayList());
                ModifierInfo parent = modInfo.parent;
                if (parent != null) {
                    NbtModifier.Modifier rootMod = modInfo.currentInfo.modifier;
                    while (parent != null) {
                        NbtModifier.Modifier parentMod = new NbtModifier.Modifier();
                        parentMod.key = parent.key;
                        parentMod.nestedModifiers = new ArrayList();
                        parentMod.nestedModifiers.add(rootMod);
                        rootMod = parentMod;
                        parent = parent.parent;
                    }
                    modModifiers.add(rootMod);
                    this.combineChildMods(modModifiers);
                    continue;
                }
                modModifiers.add(modInfo.currentInfo.modifier);
            }
            if (modifier.modifiers.isEmpty()) {
                modifier.modifiers = null;
            }
            if (modifier.modSpecificModifiers.isEmpty()) {
                modifier.modSpecificModifiers = null;
            }
            modifier.setup();
            modifier.setupValues();
            return modifier;
        }

        private void combineChildMods(ArrayList<NbtModifier.Modifier> mods) {
            HashMap<String, NbtModifier.Modifier> keys = new HashMap<String, NbtModifier.Modifier>();
            for (int i = mods.size() - 1; i >= 0; --i) {
                NbtModifier.Modifier mod = mods.get(i);
                if (keys.containsKey(mod.key)) {
                    NbtModifier.Modifier oldMod = (NbtModifier.Modifier)keys.get(mod.key);
                    if (oldMod.nestedModifiers == null || mod.nestedModifiers == null) continue;
                    for (NbtModifier.Modifier nestedModifier : mod.nestedModifiers) {
                        if (oldMod.nestedModifiers.contains(nestedModifier)) continue;
                        oldMod.nestedModifiers.add(nestedModifier);
                    }
                    mods.remove(i);
                    continue;
                }
                keys.put(mod.key, mod);
            }
            for (NbtModifier.Modifier mod : mods) {
                if (mod.nestedModifiers == null) continue;
                this.combineChildMods(mod.nestedModifiers);
            }
        }

        public boolean export() {
            Path dir = ResourceHandler.getMorphDir().resolve("export");
            try {
                ResourceLocation rl;
                if (!Files.exists(dir, new LinkOption[0])) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                if (!(rl = this.rendModEnt.entToRender.func_200600_R().getRegistryName()).func_110624_b().equals("minecraft") && !Files.exists(dir = dir.resolve(WindowMobData.ViewMobData.capitaliseWords(rl.func_110624_b(), true)), new LinkOption[0])) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                Class clz = null;
                for (ElementList.Item item : this.listClass.items) {
                    if (!item.selected) continue;
                    clz = (Class)item.getObject();
                    break;
                }
                if (clz == null) {
                    WindowPopup.popup((Workspace)((Workspace)((WindowNbt)this.parentFragment).parent), (double)0.6, (double)180.0, null, (String[])new String[]{I18n.func_135052_a((String)"morph.gui.workspace.nbt.classRequired", (Object[])new Object[0])});
                    return false;
                }
                NbtModifier modifier = this.compileModifier();
                if (!Minecraft.func_71410_x().func_110432_I().func_111285_a().equals("Dev")) {
                    modifier.author = Minecraft.func_71410_x().func_110432_I().func_111285_a();
                }
                modifier.forClass = clz.getName();
                Path file = dir.resolve(clz.getSimpleName() + ".json");
                String json = ResourceHandler.GSON.toJson((Object)modifier);
                FileUtils.writeStringToFile((File)file.toFile(), (String)json, (String)"UTF-8");
                return true;
            }
            catch (Throwable e) {
                Morph.LOGGER.error("Error exporting NBT Modifier file.", e);
                return false;
            }
        }

        public static class ModifierInfo {
            public ModifierInfo parent;
            public ArrayList<ModifierInfo> children;
            public String key;
            public INBT inbt;
            public Info originalInfo;
            public Info currentInfo;

            public ModifierInfo(ModifierInfo parent, String key, INBT inbt, Info info) {
                this.parent = parent;
                this.children = new ArrayList();
                this.key = key;
                this.inbt = inbt;
                this.originalInfo = info;
                this.currentInfo = info;
            }

            public void addChild(ModifierInfo info) {
                this.children.add(info);
            }

            public static class Info {
                @Nullable
                public String requiredMod;
                @Nullable
                public NbtModifier.Modifier modifier;
                public boolean handledElsewhere;

                public Info(@Nullable String requiredMod, @Nullable NbtModifier.Modifier modifier, boolean handledElsewhere) {
                    this.requiredMod = requiredMod;
                    this.modifier = modifier;
                    this.handledElsewhere = handledElsewhere;
                }
            }
        }
    }
}

