/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.gui.mob.window;

import com.google.common.base.Splitter;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.morph.api.mob.MobData;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.client.gui.mob.WorkspaceMobData;
import me.ichun.mods.morph.client.gui.mob.window.WindowAddTrait;
import me.ichun.mods.morph.client.gui.mob.window.WindowEditNumber;
import me.ichun.mods.morph.client.gui.mob.window.WindowEditString;
import me.ichun.mods.morph.client.gui.window.element.ElementRenderEntity;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.mob.MobDataHandler;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class WindowMobData
extends Window<WorkspaceMobData> {
    public WindowMobData(WorkspaceMobData parent) {
        super((IWindows)parent);
        this.disableBringToFront();
        this.disableDockingEntirely();
        this.disableDrag();
        this.disableDragResize();
        this.disableTitle();
        this.setId("windowMobData");
        this.setView(new ViewMobData(this));
    }

    public ViewMobData getCurrentView() {
        return (ViewMobData)this.currentView;
    }

    public static class ViewMobData
    extends View<WindowMobData> {
        public ElementList<?> listMorphs;
        public ElementList<?> listTraits;
        public ElementList<?> listTraitInfo;
        public ElementTextWrapper textFieldDesc;
        public MobData selectedMobData;

        public ViewMobData(@Nonnull WindowMobData parent) {
            super((Window)parent, "morph.gui.workspace.mobData.title");
            int padding = 6;
            ElementButton buttonCancel = new ElementButton((Fragment)this, "gui.cancel", btn -> ((WorkspaceMobData)parent.parent).func_231175_as__());
            buttonCancel.setSize(60, 20);
            buttonCancel.constraints().bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding);
            this.elements.add(buttonCancel);
            ElementButton buttonExport = new ElementButton((Fragment)this, "morph.gui.workspace.resources.export", btn -> {
                if (this.export()) {
                    if (Screen.func_231173_s_()) {
                        Path dir = ResourceHandler.getMorphDir().resolve("export");
                        Util.func_110647_a().func_195641_a(dir.toFile());
                    }
                    ((WorkspaceMobData)parent.parent).func_231175_as__();
                }
            });
            buttonExport.setSize(60, 20);
            buttonExport.constraints().bottom((IConstrainable)buttonCancel, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)buttonCancel, Constraint.Property.Type.LEFT, 6);
            this.elements.add(buttonExport);
            ElementButton buttonHelp = new ElementButton((Fragment)this, "?", btn -> {
                if (Screen.func_231173_s_()) {
                    Path dir = ResourceHandler.getMorphDir().resolve("export");
                    if (!Files.exists(dir, new LinkOption[0])) {
                        dir = ResourceHandler.getMorphDir();
                    }
                    Util.func_110647_a().func_195641_a(dir.toFile());
                } else {
                    WindowPopup.popup((Workspace)((Workspace)parent.parent), (double)0.7, (double)190.0, null, (String[])new String[]{I18n.func_135052_a((String)"morph.gui.workspace.mobData.help", (Object[])new Object[0])});
                }
            });
            buttonHelp.setSize(20, 20);
            buttonHelp.constraints().bottom((IConstrainable)buttonCancel, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)buttonExport, Constraint.Property.Type.LEFT, 6);
            this.elements.add(buttonHelp);
            ElementTextWrapper textClass = new ElementTextWrapper((Fragment)this);
            textClass.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.mobData.morphs", (Object[])new Object[0]));
            textClass.setColor(TextFormatting.AQUA.func_211163_e());
            textClass.constraints().left((IConstrainable)this, Constraint.Property.Type.LEFT, padding - 1).top((IConstrainable)this, Constraint.Property.Type.TOP, padding);
            this.elements.add(textClass);
            ElementScrollBar svClass = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            svClass.constraints().top((IConstrainable)textClass, Constraint.Property.Type.BOTTOM, -1).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)textClass, Constraint.Property.Type.LEFT, -64);
            this.elements.add(svClass);
            this.listMorphs = new ElementList((Fragment)this).setScrollVertical(svClass);
            this.listMorphs.setSize(50, 20);
            this.listMorphs.constraints().left((IConstrainable)textClass, Constraint.Property.Type.LEFT, 0).top((IConstrainable)textClass, Constraint.Property.Type.BOTTOM, -1).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)svClass, Constraint.Property.Type.LEFT, 0);
            if (Morph.eventHandlerClient.morphData != null) {
                for (MorphVariant morph : Morph.eventHandlerClient.morphData.morphs) {
                    if (morph.id.equals((Object)EntityType.field_200729_aH.getRegistryName()) || !morph.hasVariants()) continue;
                    ElementList.Item item = this.listMorphs.addItem((Object)morph);
                    MorphVariant renderVariant = morph.getAsVariant(morph.variants.get(0));
                    EntityType value = (EntityType)ForgeRegistries.ENTITIES.getValue(renderVariant.id);
                    String key = value != null ? value.func_210760_d() : "morph.morph.type.unknown";
                    ElementRenderEntity rend = new ElementRenderEntity((Fragment)item, 0.5f);
                    rend.setSize(40, 40);
                    rend.setConstraint(Constraint.matchParent((IConstrained)rend, (IConstrainable)item, (int)4).bottom(null, Constraint.Property.Type.BOTTOM, 0));
                    rend.setTooltip(I18n.func_135052_a((String)key, (Object[])new Object[0]));
                    rend.setEntityToRender(renderVariant.createEntityInstance((World)Minecraft.func_71410_x().field_71441_e, (PlayerEntity)null));
                    item.addElement((Element)rend);
                    item.setSelectionHandler(theItem -> {
                        MobData data = MobDataHandler.getMobData(((MorphVariant)theItem.getObject()).id);
                        if (data == null) {
                            this.selectedMobData = new MobData();
                            this.selectedMobData.forEntity = ((MorphVariant)theItem.getObject()).id.toString();
                        } else {
                            this.selectedMobData = (MobData)ResourceHandler.GSON.fromJson(ResourceHandler.GSON.toJson((Object)data), MobData.class);
                        }
                        this.updateTraitsList();
                    });
                }
            }
            this.elements.add(this.listMorphs);
            int traitsWidth = 100;
            ElementScrollBar svTraits = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            svTraits.constraints().top((IConstrainable)textClass, Constraint.Property.Type.BOTTOM, 16).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)svClass, Constraint.Property.Type.LEFT, -(padding + traitsWidth));
            this.elements.add(svTraits);
            this.listTraits = new ElementList((Fragment)this).setScrollVertical(svTraits);
            this.listTraits.setSize(traitsWidth, 20);
            this.listTraits.constraints().left((IConstrainable)svClass, Constraint.Property.Type.RIGHT, padding).top((IConstrainable)svTraits, Constraint.Property.Type.TOP, 0).right((IConstrainable)svTraits, Constraint.Property.Type.LEFT, 0).bottom((IConstrainable)svTraits, Constraint.Property.Type.BOTTOM, 0);
            this.elements.add(this.listTraits);
            ElementTextWrapper textTraits = new ElementTextWrapper((Fragment)this);
            textTraits.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.mobData.traits", (Object[])new Object[0]));
            textTraits.constraints().left(this.listTraits, Constraint.Property.Type.LEFT, 0).bottom(this.listTraits, Constraint.Property.Type.TOP, 0);
            this.elements.add(textTraits);
            ElementTextWrapper textMorphId = new ElementTextWrapper((Fragment)this);
            textMorphId.setId("textMorphId");
            textMorphId.setColor(TextFormatting.AQUA.func_211163_e());
            textMorphId.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.mobData.selectAMorph", (Object[])new Object[0]));
            textMorphId.constraints().left(this.listTraits, Constraint.Property.Type.LEFT, 0).top((IConstrainable)textClass, Constraint.Property.Type.TOP, 0);
            this.elements.add(textMorphId);
            ElementButton buttonRemove = new ElementButton((Fragment)this, "-", btn -> {
                for (ElementList.Item item : this.listTraits.items) {
                    if (!item.selected) continue;
                    Trait trait = (Trait)item.getObject();
                    this.selectedMobData.traits.remove(trait);
                    this.updateTraitsList();
                    this.updateTraitInfoList(null);
                    break;
                }
            });
            buttonRemove.setSize(16, 16);
            buttonRemove.constraints().right((IConstrainable)svTraits, Constraint.Property.Type.RIGHT, 0).bottom((IConstrainable)svTraits, Constraint.Property.Type.TOP, 0);
            this.elements.add(buttonRemove);
            ElementButton buttonAdd = new ElementButton((Fragment)this, "+", btn -> {
                if (this.selectedMobData != null) {
                    WindowAddTrait window = new WindowAddTrait(this.getWorkspace(), trait -> {
                        this.selectedMobData.traits.add((Trait<?>)trait);
                        this.updateTraitsList();
                        this.updateTraitInfoList(null);
                    });
                    this.getWorkspace().openWindowInCenter((Window)window, 0.6, 0.9, true);
                    window.init();
                }
            });
            buttonAdd.setSize(16, 16);
            buttonAdd.constraints().right((IConstrainable)buttonRemove, Constraint.Property.Type.LEFT, 0).bottom((IConstrainable)buttonRemove, Constraint.Property.Type.BOTTOM, 0);
            this.elements.add(buttonAdd);
            this.textFieldDesc = new ElementTextWrapper((Fragment)this);
            this.textFieldDesc.setId("textFieldDesc");
            this.textFieldDesc.setText(" ");
            this.textFieldDesc.constraints().left((IConstrainable)svTraits, Constraint.Property.Type.RIGHT, padding).right((IConstrainable)buttonCancel, Constraint.Property.Type.RIGHT, 0);
            this.textFieldDesc.constraint.bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 12);
            this.elements.add(this.textFieldDesc);
            ElementScrollBar svInfo = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            svInfo.constraints().top(this.listTraits, Constraint.Property.Type.TOP, 0).bottom((IConstrainable)this.textFieldDesc, Constraint.Property.Type.TOP, padding).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding);
            this.elements.add(svInfo);
            this.listTraitInfo = new ElementList((Fragment)this).setScrollVertical(svInfo);
            this.listTraitInfo.constraints().left((IConstrainable)svTraits, Constraint.Property.Type.RIGHT, padding).right((IConstrainable)svInfo, Constraint.Property.Type.LEFT, 0).top((IConstrainable)svInfo, Constraint.Property.Type.TOP, 0).bottom((IConstrainable)svInfo, Constraint.Property.Type.BOTTOM, 0);
            this.elements.add(this.listTraitInfo);
            ElementTextWrapper textInfo = new ElementTextWrapper((Fragment)this);
            textInfo.setId("textInfo");
            textInfo.setNoWrap().setText(I18n.func_135052_a((String)"morph.gui.workspace.mobData.additionalTraitInfo", (Object[])new Object[0]));
            textInfo.constraints().left(this.listTraitInfo, Constraint.Property.Type.LEFT, 0).bottom(this.listTraitInfo, Constraint.Property.Type.TOP, 0);
            this.elements.add(textInfo);
        }

        public void updateTraitsList() {
            EntityType value = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.selectedMobData.forEntity));
            String key = value != null ? value.func_210760_d() : "morph.morph.type.unknown";
            ((ElementTextWrapper)this.getById("textMorphId")).setText(I18n.func_135052_a((String)key, (Object[])new Object[0]));
            this.listTraits.items.clear();
            this.listTraits.func_231035_a_(null);
            this.selectedMobData.traits.sort(null);
            for (Trait<?> trait : this.selectedMobData.traits) {
                ElementList.Item item = this.listTraits.addItem(trait);
                String name = I18n.func_135052_a((String)(trait.getTranslationKeyRoot() + ".name"), (Object[])new Object[0]);
                if (name.equals(trait.getTranslationKeyRoot() + ".name")) {
                    name = trait.type;
                }
                item.addTextWrapper(name);
                String tooltip = I18n.func_135052_a((String)"morph.gui.workspace.mobData.type", (Object[])new Object[]{trait.type});
                String desc = I18n.func_135052_a((String)(trait.getTranslationKeyRoot() + ".desc"), (Object[])new Object[0]);
                if (!desc.equals(trait.getTranslationKeyRoot() + ".desc")) {
                    tooltip = tooltip + "\n\n" + desc;
                }
                item.setTooltip(tooltip);
                ElementTextWrapper text = (ElementTextWrapper)item.elements.get(0);
                text.setTooltip(tooltip);
                if (!trait.isAbility()) {
                    text.setColor(Integer.valueOf(Theme.getAsHex((int[])this.getTheme().fontChat)));
                }
                item.setSelectionHandler(theItem -> {
                    if (theItem.selected) {
                        this.updateTraitInfoList(trait);
                    } else {
                        this.updateTraitInfoList(null);
                    }
                });
            }
            this.listTraits.init();
        }

        public void updateTraitInfoList(Trait<?> trait) {
            this.listTraitInfo.items.clear();
            this.listTraitInfo.func_231035_a_(null);
            this.textFieldDesc.setText(" ");
            this.textFieldDesc.constraint.bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 12);
            ((ElementTextWrapper)this.getById("textInfo")).setText("");
            if (trait != null) {
                Field[] fields;
                ((ElementTextWrapper)this.getById("textInfo")).setText(I18n.func_135052_a((String)(trait.getTranslationKeyRoot() + ".name"), (Object[])new Object[0]));
                for (Field f : fields = trait.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || f.getName().equals("type")) continue;
                    ElementList.Item fItem = this.listTraitInfo.addItem((Object)f).addTextWrapper("");
                    this.updateItemName((ElementList.Item<Field>)fItem, trait, f);
                    fItem.setSelectionHandler(fieldItem -> {
                        String desc = I18n.func_135052_a((String)(trait.getTranslationKeyRoot() + "." + f.getName() + ".desc"), (Object[])new Object[0]);
                        if (fieldItem.selected && !desc.equals(trait.getTranslationKeyRoot() + "." + f.getName() + ".desc")) {
                            this.textFieldDesc.setText(desc);
                            this.textFieldDesc.constraint.bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 28);
                        } else {
                            this.textFieldDesc.setText(" ");
                            this.textFieldDesc.constraint.bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 12);
                        }
                        this.resize(((WorkspaceMobData)((WindowMobData)this.parentFragment).parent).getMinecraft(), this.getWidth(), this.getHeight());
                    });
                    fItem.setDoubleClickHandler(fieldItem -> {
                        if (f.getType() == Boolean.class) {
                            try {
                                Boolean bool = (Boolean)f.get(trait);
                                f.set(trait, bool != null && bool != false ? null : Boolean.valueOf(true));
                            }
                            catch (IllegalAccessException bool) {
                                // empty catch block
                            }
                            this.updateItemName((ElementList.Item<Field>)fieldItem, trait, f);
                            this.resize(((WorkspaceMobData)((WindowMobData)this.parentFragment).parent).getMinecraft(), this.getWidth(), this.getHeight());
                        } else if (f.getType() == String.class) {
                            try {
                                String s = (String)f.get(trait);
                                this.getWorkspace().openWindowInCenter((Window)new WindowEditString((Workspace)((WindowMobData)this.parentFragment).parent, s == null ? "" : s, f.getName(), input -> {
                                    try {
                                        f.set(trait, input);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        // empty catch block
                                    }
                                    this.updateItemName((ElementList.Item<Field>)fieldItem, trait, f);
                                    this.resize(((WorkspaceMobData)((WindowMobData)this.parentFragment).parent).getMinecraft(), this.getWidth(), this.getHeight());
                                }), 0.4, 100.0, true);
                            }
                            catch (IllegalAccessException illegalAccessException) {}
                        } else if (f.getType() == Integer.class || f.getType() == Double.class || f.getType() == Float.class) {
                            this.getWorkspace().openWindowInCenter((Window)new WindowEditNumber((Workspace)((WindowMobData)this.parentFragment).parent, f.getName(), ignored -> {
                                this.updateItemName((ElementList.Item<Field>)fieldItem, trait, f);
                                this.resize(((WorkspaceMobData)((WindowMobData)this.parentFragment).parent).getMinecraft(), this.getWidth(), this.getHeight());
                            }, trait, f), 0.4, 100.0, true);
                        }
                    });
                    fItem.setRightClickConsumer((mX, mY, fieldItem) -> {
                        try {
                            ((Field)fieldItem.getObject()).set(trait, null);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                        this.updateItemName((ElementList.Item<Field>)fieldItem, trait, f);
                        this.resize(((WorkspaceMobData)((WindowMobData)this.parentFragment).parent).getMinecraft(), this.getWidth(), this.getHeight());
                    });
                }
            }
            this.resize(((WorkspaceMobData)((WindowMobData)this.parentFragment).parent).getMinecraft(), this.getWidth(), this.getHeight());
        }

        public void updateItemName(ElementList.Item<Field> item, Trait<?> trait, Field f) {
            String name = I18n.func_135052_a((String)(trait.getTranslationKeyRoot() + "." + f.getName() + ".name"), (Object[])new Object[0]);
            if (name.equals(trait.getTranslationKeyRoot() + "." + f.getName() + ".name")) {
                name = f.getName();
            }
            StringTextComponent text = new StringTextComponent(TextFormatting.GOLD + name);
            String fhName = "";
            try {
                Object o = f.get(trait);
                fhName = o == null ? TextFormatting.GRAY + "null" : o.toString();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            text.func_230529_a_((ITextComponent)new StringTextComponent(TextFormatting.RESET + ": " + fhName + TextFormatting.RESET));
            ((ElementTextWrapper)item.elements.get(0)).setText(text.getString());
            item.init();
        }

        public boolean export() {
            if (this.selectedMobData == null) {
                return false;
            }
            Path dir = ResourceHandler.getMorphDir().resolve("export");
            try {
                ResourceLocation rl;
                if (!Files.exists(dir, new LinkOption[0])) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                if (!(rl = new ResourceLocation(this.selectedMobData.forEntity)).func_110624_b().equals("minecraft") && !Files.exists(dir = dir.resolve(ViewMobData.capitaliseWords(rl.func_110624_b(), true)), new LinkOption[0])) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                if (!Minecraft.func_71410_x().func_110432_I().func_111285_a().equals("Dev")) {
                    this.selectedMobData.author = Minecraft.func_71410_x().func_110432_I().func_111285_a();
                }
                String name = ViewMobData.capitaliseWords(rl.func_110623_a(), false);
                Path file = dir.resolve(name + ".json");
                String json = ResourceHandler.GSON.toJson((Object)this.selectedMobData);
                FileUtils.writeStringToFile((File)file.toFile(), (String)json, (String)"UTF-8");
                return true;
            }
            catch (Throwable e) {
                Morph.LOGGER.error("Error exporting Mob Data file.", e);
                return false;
            }
        }

        public static String capitaliseWords(String s, boolean addSpace) {
            Splitter UNDERSCORE_SPLITTER = Splitter.on((String)"_").trimResults().omitEmptyStrings();
            List names = UNDERSCORE_SPLITTER.splitToList((CharSequence)s);
            StringBuilder sb = new StringBuilder();
            for (String name : names) {
                sb.append(name.toUpperCase(Locale.ROOT).charAt(0));
                sb.append(name.substring(1));
                if (!addSpace) continue;
                sb.append(" ");
            }
            return sb.toString().trim();
        }
    }
}

