/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.gui.mob.window;

import java.util.Comparator;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollView;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.mob.TraitHandler;
import net.minecraft.client.resources.I18n;

public class WindowAddTrait
extends Window<Workspace> {
    public WindowAddTrait(Workspace parent, Consumer<Trait<?>> callback) {
        super((IWindows)parent);
        this.setView(new ViewAddTrait(this, callback));
        this.disableDockingEntirely();
    }

    public static class ViewAddTrait
    extends View<WindowAddTrait> {
        public final Consumer<Trait<?>> callback;
        public ElementTextWrapper description;
        public ElementList<?> list;

        public ViewAddTrait(@Nonnull WindowAddTrait parent, Consumer<Trait<?>> callback) {
            super((Window)parent, "morph.gui.workspace.mobData.addTrait");
            this.callback = callback;
            ElementScrollBar sv = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            sv.setConstraint(new Constraint((IConstrained)sv).top((IConstrainable)this, Constraint.Property.Type.TOP, 0).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 64).right((IConstrainable)this, Constraint.Property.Type.RIGHT, 0));
            this.elements.add(sv);
            this.list = new ElementList((Fragment)this).setScrollVertical(sv);
            this.list.setConstraint(new Constraint(this.list).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 64).left((IConstrainable)this, Constraint.Property.Type.LEFT, 0).right((IConstrainable)sv, Constraint.Property.Type.LEFT, 0).top((IConstrainable)this, Constraint.Property.Type.TOP, 0));
            this.elements.add(this.list);
            ElementButton button = new ElementButton((Fragment)this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), btn -> this.getWorkspace().removeWindow((Window)parent));
            button.setSize(60, 20);
            button.setConstraint(new Constraint((IConstrained)button).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 10).right((IConstrainable)this, Constraint.Property.Type.RIGHT, 14));
            this.elements.add(button);
            ElementButton button1 = new ElementButton((Fragment)this, I18n.func_135052_a((String)"gui.ok", (Object[])new Object[0]), btn -> {
                for (ElementList.Item item : this.list.items) {
                    if (!item.selected) continue;
                    this.returnTraitInstance((Trait)item.getObject());
                    return;
                }
            });
            button1.setSize(60, 20);
            button1.setConstraint(new Constraint((IConstrained)button1).right((IConstrainable)button, Constraint.Property.Type.LEFT, 10));
            this.elements.add(button1);
            ElementScrollBar scroll = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            scroll.setConstraint(new Constraint((IConstrained)scroll).top(this.list, Constraint.Property.Type.BOTTOM, 0).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)this, Constraint.Property.Type.RIGHT, 0));
            this.elements.add(scroll);
            ElementScrollView list1 = new ElementScrollView((Fragment)this).setScrollVertical(scroll);
            list1.setConstraint(new Constraint((IConstrained)list1).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 0).left((IConstrainable)this, Constraint.Property.Type.LEFT, 0).right((IConstrainable)scroll, Constraint.Property.Type.LEFT, 0).top((IConstrainable)scroll, Constraint.Property.Type.TOP, 0));
            this.elements.add(list1);
            this.description = new ElementTextWrapper((Fragment)list1);
            this.description.setConstraint(Constraint.sizeOnly((IConstrained)this.description));
            list1.addElement((Element)this.description);
            TreeMap clzList = new TreeMap(Comparator.naturalOrder());
            TraitHandler.TRAITS.forEach((k, clz) -> {
                try {
                    clzList.put(clz.newInstance(), (Class)clz);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    Morph.LOGGER.error("Error creating trait instance!", (Throwable)e);
                }
            });
            clzList.forEach((k, v) -> {
                Trait instance = k;
                ElementList.Item traitItem = this.list.addItem((Object)instance).addTextWrapper(I18n.func_135052_a((String)(instance.getTranslationKeyRoot() + ".name"), (Object[])new Object[0])).setDoubleClickHandler(item -> {
                    if (item.selected) {
                        this.returnTraitInstance(instance);
                    }
                }).setEnterResponder(item -> {
                    if (item.selected) {
                        this.returnTraitInstance(instance);
                        return true;
                    }
                    return false;
                }).setSelectionHandler(item -> {
                    String desc = I18n.func_135052_a((String)(instance.getTranslationKeyRoot() + ".desc"), (Object[])new Object[0]);
                    if (item.selected && !desc.equals(instance.getTranslationKeyRoot() + ".desc")) {
                        this.description.setText(desc);
                    } else {
                        this.description.setText("");
                    }
                    this.description.init();
                });
                ElementTextWrapper text = (ElementTextWrapper)traitItem.elements.get(0);
                if (!instance.isAbility()) {
                    text.setColor(Integer.valueOf(Theme.getAsHex((int[])this.getTheme().fontChat)));
                }
            });
        }

        public void returnTraitInstance(Trait<?> obj) {
            ((Workspace)((WindowAddTrait)this.parentFragment).parent).removeWindow((Window)this.parentFragment);
            this.callback.accept(obj);
        }
    }
}

