/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.gui.biomass.window.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleTextured;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.morph.api.biomass.BiomassUpgrade;
import me.ichun.mods.morph.api.biomass.BiomassUpgradeInfo;
import me.ichun.mods.morph.client.gui.biomass.window.element.ElementBiomassUpgrades;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;

public class ElementUpgradeNode
extends ElementToggleTextured<ElementUpgradeNode> {
    public static final RenderType MORPH_LINES = RenderType.func_228632_a_((String)"morph_lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(4.0))).func_228724_a_(RenderState.field_228523_o_).func_228726_a_(RenderState.field_228515_g_).func_228727_a_(RenderState.field_228495_E_).func_228728_a_(false));
    public static int SIZE = 16;
    public static int TOLERANCE_MIN = 2 * SIZE;
    public static int TOLERANCE_MAX = 4 * SIZE;
    private ElementBiomassUpgrades parent;
    public ElementUpgradeNode parentNode;
    public ArrayList<ElementUpgradeNode> childNodes = new ArrayList();
    public int showTime;
    public double lastX;
    public double lastY;
    public double pushX;
    public double pushY;
    @Nonnull
    public BiomassUpgradeInfo upgradeInfo;
    @Nullable
    public BiomassUpgrade actualUpgrade;

    public ElementUpgradeNode(@Nonnull ElementBiomassUpgrades parent, BiomassUpgradeInfo upgradeInfo, BiomassUpgrade actualUpgrade, Consumer<ElementUpgradeNode> callback) {
        super((Fragment)parent, "", upgradeInfo.getTextureLocation(), callback);
        this.parent = parent;
        this.showTime = -1;
        this.setWarping();
        this.upgradeInfo = upgradeInfo;
        this.actualUpgrade = actualUpgrade;
    }

    public void setParentNode(ElementUpgradeNode parent) {
        this.parentNode = parent;
        parent.childNodes.add(this);
    }

    public void allocateChildPlacements(Random rand) {
        for (ElementUpgradeNode childNode : this.childNodes) {
            rand.setSeed((long)Math.abs(childNode.upgradeInfo.id.hashCode() + Minecraft.func_71410_x().func_110432_I().func_148255_b().hashCode()) * 42069L);
            childNode.setPos(this.posX + rand.nextInt(SIZE * 4), this.posY + rand.nextInt(SIZE * 4));
            childNode.allocateChildPlacements(rand);
        }
    }

    public Element<?> setPos(int x, int y) {
        this.lastX = x;
        this.lastY = y;
        return super.setPos(x, y);
    }

    public void tick() {
        if (this.parentNode != null) {
            this.lastX += this.pushX;
            this.lastY += this.pushY;
            this.pushX *= (double)0.98f;
            this.pushY *= (double)0.98f;
            if (Math.abs(this.pushX) < 0.001) {
                this.pushX = 0.0;
            }
            if (Math.abs(this.pushY) < 0.001) {
                this.pushY = 0.0;
            }
            this.posX = (int)Math.round(this.lastX);
            this.posY = (int)Math.round(this.lastY);
        }
        if (this.shouldShow()) {
            ++this.showTime;
            if (this.parentNode != null) {
                this.pushAwayFromOthers();
            }
        }
    }

    public void pushAwayFromOthers() {
        ArrayList<ElementUpgradeNode> activeNodes = this.parent.getActiveNodes();
        for (ElementUpgradeNode node : activeNodes) {
            Vector3d mul;
            double mag;
            Vector3d normal;
            double dist;
            if (node == this) continue;
            Vector3d diff = this.getAsVector().func_178788_d(node.getAsVector());
            if (diff.equals((Object)Vector3d.field_186680_a)) {
                diff = new Vector3d(this.parent.rand.nextGaussian() * 3.0, this.parent.rand.nextGaussian() * 3.0, 0.0);
            }
            if ((dist = diff.func_72433_c()) < (double)TOLERANCE_MIN) {
                normal = diff.func_72432_b();
                mag = ((double)TOLERANCE_MIN - dist) / (double)TOLERANCE_MIN * 0.1;
                mul = normal.func_216372_d(mag, mag, mag);
                this.pushX += mul.field_72450_a;
                this.pushY += mul.field_72448_b;
                continue;
            }
            if (node != this.parentNode || !(dist > (double)TOLERANCE_MAX)) continue;
            normal = diff.func_72432_b();
            mag = ((double)TOLERANCE_MAX - dist) / (double)TOLERANCE_MAX * 0.1;
            mul = normal.func_216372_d(mag, mag, mag);
            this.pushX += mul.field_72450_a;
            this.pushY += mul.field_72448_b;
        }
    }

    public Vector3d getAsVector() {
        return new Vector3d((double)this.getCenterX(), (double)this.getCenterY(), 0.0);
    }

    public void renderLines(MatrixStack stack, float partialTick) {
        float prog;
        if (this.parentNode != null && (prog = EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(((float)this.showTime + partialTick) / 10.0f), (float)0.0f, (float)1.0f))) > 0.0f) {
            IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            IVertexBuilder builder = bufferSource.getBuffer(MORPH_LINES);
            Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
            float parX = (float)this.parentNode.getLeft() + (float)this.parentNode.width / 2.0f;
            float parY = (float)this.parentNode.getTop() + (float)this.parentNode.height / 2.0f;
            float diffX = (float)this.getLeft() + (float)this.width / 2.0f - parX;
            float diffY = (float)this.getTop() + (float)this.height / 2.0f - parY;
            builder.func_227888_a_(matrix, parX, parY, 0.0f).func_225586_a_(255, 255, 255, 200).func_181675_d();
            builder.func_227888_a_(matrix, parX + diffX * prog, parY + diffY * prog, 0.0f).func_225586_a_(255, 255, 255, 120).func_181675_d();
            bufferSource.func_228461_a_();
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        float curSize;
        float prog = EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(((float)this.showTime + partialTick) / 10.0f), (float)0.0f, (float)1.0f));
        if (prog > 0.0f && (curSize = (float)SIZE * prog) >= 4.0f) {
            int preX = this.posX;
            int preY = this.posY;
            this.posX = (int)((float)this.posX + ((float)SIZE - curSize) / 2.0f);
            this.posY = (int)((float)this.posY + ((float)SIZE - curSize) / 2.0f);
            this.width = (int)curSize;
            this.height = (int)curSize;
            super.func_230430_a_(stack, mouseX, mouseY, partialTick);
            this.posX = preX;
            this.posY = preY;
        }
    }

    public boolean shouldShow() {
        return true;
    }

    public boolean isActive() {
        return this.showTime >= 0;
    }

    public int getCenterX() {
        return this.posX + this.width / 2;
    }

    public int getCenterY() {
        return this.posY + this.height / 2;
    }

    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        return this.upgradeInfo.id;
    }

    public int getLeft() {
        return super.getLeft() + this.parent.offsetX;
    }

    public int getRight() {
        return super.getRight() + this.parent.offsetX;
    }

    public int getTop() {
        return super.getTop() + this.parent.offsetY;
    }

    public int getBottom() {
        return super.getBottom() + this.parent.offsetY;
    }

    public int getMaxWidth() {
        return SIZE;
    }

    public int getMaxHeight() {
        return SIZE;
    }

    public int getMinWidth() {
        return SIZE;
    }

    public int getMinHeight() {
        return SIZE;
    }
}

