/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.gui.biomass.window.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementFertile;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.morph.api.biomass.BiomassUpgrade;
import me.ichun.mods.morph.api.biomass.BiomassUpgradeInfo;
import me.ichun.mods.morph.client.gui.biomass.window.WindowBiomassUpgrades;
import me.ichun.mods.morph.client.gui.biomass.window.element.ElementRipple;
import me.ichun.mods.morph.client.gui.biomass.window.element.ElementUpgradeNode;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.biomass.BiomassUpgradeHandler;
import net.minecraft.util.ResourceLocation;

public class ElementBiomassUpgrades
extends ElementFertile<WindowBiomassUpgrades.ViewBiomassUpgrades> {
    public ArrayList<Element<?>> children = new ArrayList();
    public Random rand = new Random();
    public boolean hasInit = false;
    public int offsetX = 0;
    public int offsetY = 0;
    public Element.MousePos pos;
    public ArrayList<Element<?>> ripples = new ArrayList();

    public ElementBiomassUpgrades(@Nonnull WindowBiomassUpgrades.ViewBiomassUpgrades parent) {
        super((Fragment)parent);
    }

    public void init() {
        this.constraint.apply();
        if (!this.hasInit) {
            this.hasInit = true;
            ArrayList<ElementUpgradeNode> nodes = new ArrayList<ElementUpgradeNode>();
            for (BiomassUpgradeInfo value : BiomassUpgradeHandler.BIOMASS_UPGRADES.values()) {
                BiomassUpgrade upgrade = Morph.eventHandlerClient.morphData.getBiomassUpgrade(value.id);
                ElementUpgradeNode node = new ElementUpgradeNode(this, value, upgrade, e -> {
                    ArrayList<ElementUpgradeNode> activeNodes = this.getActiveNodes();
                    for (ElementUpgradeNode activeNode : activeNodes) {
                        activeNode.toggleState = activeNode == e;
                    }
                    this.ripples.add((Element<?>)e);
                });
                nodes.add(node);
            }
            ElementUpgradeNode theParent = null;
            block1: for (ElementUpgradeNode childNode : nodes) {
                if (childNode.upgradeInfo.parentId.equals("root")) {
                    theParent = childNode;
                    continue;
                }
                for (ElementUpgradeNode parentNode : nodes) {
                    if (!parentNode.upgradeInfo.id.equals(childNode.upgradeInfo.parentId)) continue;
                    childNode.setParentNode(parentNode);
                    continue block1;
                }
            }
            if (theParent != null) {
                theParent.setPos((this.getWidth() - ElementUpgradeNode.SIZE) / 2, (this.getHeight() - ElementUpgradeNode.SIZE) / 2);
                theParent.allocateChildPlacements(this.rand);
                for (ElementUpgradeNode node : nodes) {
                    this.children.add((Element<?>)node);
                }
            } else {
                Morph.LOGGER.error("Cannot find root upgrade node!");
            }
        }
        this.func_231039_at__().forEach(Fragment::init);
    }

    public void tick() {
        this.children.removeIf(e -> e instanceof ElementRipple && ((ElementRipple)e).age > 20);
        super.tick();
        for (Element<?> e2 : this.ripples) {
            this.children.add(0, new ElementRipple(this).setPos(e2.posX + e2.width / 2, e2.posY + e2.height / 2));
        }
        this.ripples.clear();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle() > 0) {
            ElementBiomassUpgrades.bindTexture((ResourceLocation)this.resourceHorse());
            ElementBiomassUpgrades.cropAndStitch((MatrixStack)stack, (int)(this.getLeft() - 1), (int)(this.getTop() - 1), (int)(this.width + 2), (int)(this.height + 2), (int)2, (double)79.0, (double)17.0, (int)90, (int)54, (double)256.0, (double)256.0);
        } else {
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)(this.getLeft() - 1), (double)(this.getTop() - 1), (double)(this.width + 2), (double)1.0, (double)0.0);
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)(this.getLeft() - 1), (double)(this.getTop() - 1), (double)1.0, (double)(this.height + 2), (double)0.0);
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)(this.getLeft() - 1), (double)this.getBottom(), (double)(this.width + 2), (double)1.0, (double)0.0);
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)this.getRight(), (double)(this.getTop() - 1), (double)1.0, (double)(this.height + 2), (double)0.0);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderHelper.drawColour((MatrixStack)stack, (int)43, (int)43, (int)43, (int)255, (double)this.getLeft(), (double)this.getTop(), (double)this.width, (double)this.height, (double)-100.0);
        this.setScissor();
        this.children.forEach((Consumer<Element<?>>)((Consumer<Element>)item -> {
            if (item instanceof ElementRipple) {
                item.func_230430_a_(stack, mouseX, mouseY, partialTick);
            }
        }));
        this.children.forEach((Consumer<Element<?>>)((Consumer<Element>)item -> {
            if (item instanceof ElementUpgradeNode) {
                ((ElementUpgradeNode)((Object)item)).renderLines(stack, partialTick);
            }
        }));
        this.children.forEach((Consumer<Element<?>>)((Consumer<Element>)item -> {
            if (item instanceof ElementUpgradeNode && item.getBottom() >= this.getTop() && item.getTop() < this.getBottom()) {
                item.func_230430_a_(stack, mouseX, mouseY, partialTick);
            }
        }));
        this.resetScissorToParent();
        RenderSystem.disableBlend();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            super.func_231044_a_(mouseX, mouseY, button);
            if (this.func_241217_q_() == null) {
                this.pos = new Element.MousePos((int)mouseX, (int)mouseY);
            }
            return true;
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.pos != null) {
            this.offsetX += (int)mouseX - this.pos.x;
            this.offsetY += (int)mouseY - this.pos.y;
            this.pos.x = (int)mouseX;
            this.pos.y = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.pos = null;
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public ArrayList<ElementUpgradeNode> getActiveNodes() {
        ArrayList<ElementUpgradeNode> elementUpgradeNodes = new ArrayList<ElementUpgradeNode>();
        List collect = this.children.stream().filter(e -> e instanceof ElementUpgradeNode && ((ElementUpgradeNode)((Object)e)).isActive()).collect(Collectors.toList());
        for (Element element : collect) {
            elementUpgradeNodes.add((ElementUpgradeNode)element);
        }
        return elementUpgradeNodes;
    }

    public List<Element<?>> func_231039_at__() {
        return this.children;
    }

    public boolean requireScissor() {
        return true;
    }

    public boolean func_231049_c__(boolean direction) {
        return false;
    }

    public int getBorderSize() {
        return 0;
    }
}

