/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.entity;

import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.tracker.ClientEntityTracker;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.morph.client.render.MorphRenderHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT)
public class EntityBiomassAbility
extends Entity {
    @Nonnull
    public PlayerEntity player;
    public int fadeTime;
    public int solidTime;
    public int age;
    public MorphRenderHandler.ModelRendererCapture capture = new MorphRenderHandler.ModelRendererCapture();

    public EntityBiomassAbility(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_82142_c(true);
        this.func_184224_h(true);
        this.func_145769_d(ClientEntityTracker.getNextEntId());
    }

    public EntityBiomassAbility setInfo(@Nonnull PlayerEntity player, int fadeTime, int solidTime) {
        this.player = player;
        this.fadeTime = fadeTime;
        this.solidTime = solidTime;
        this.syncWithOriginPosition();
        return this;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        if (!this.player.func_70089_S() || !this.player.field_70170_p.func_234923_W_().equals(this.field_70170_p.func_234923_W_())) {
            if (this.player.field_70128_L) {
                this.func_70106_y();
            }
        } else if (this.age > this.fadeTime * 2 + this.solidTime) {
            this.func_70106_y();
        } else {
            this.func_70107_b(this.player.func_226277_ct_(), this.player.func_226278_cu_() + (double)this.player.func_213302_cg() / 2.0, this.player.func_226281_cx_());
            this.func_70101_b(this.player.field_70177_z, this.player.field_70125_A);
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return this.player.func_184177_bl();
    }

    public boolean func_70112_a(double distance) {
        return this.player.func_70112_a(distance);
    }

    public float func_70013_c() {
        return this.player.func_70013_c();
    }

    protected void func_70088_a() {
    }

    public boolean func_184198_c(CompoundNBT compound) {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getSkinAlpha(float partialTick) {
        float alpha = this.age < this.fadeTime ? EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(((float)this.age + partialTick) / (float)this.fadeTime), (float)0.0f, (float)1.0f)) : (this.age >= this.fadeTime + this.solidTime ? EntityHelper.sineifyProgress((float)(1.0f - MathHelper.func_76131_a((float)(((float)(this.age - (this.fadeTime + this.solidTime)) + partialTick) / (float)this.fadeTime), (float)0.0f, (float)1.0f))) : 1.0f);
        return alpha;
    }

    public void syncWithOriginPosition() {
        this.func_70012_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), this.player.field_70177_z, this.player.field_70125_A);
        this.field_70142_S = this.player.field_70142_S;
        this.field_70137_T = this.player.field_70137_T;
        this.field_70136_U = this.player.field_70136_U;
        this.field_70169_q = this.player.field_70169_q;
        this.field_70167_r = this.player.field_70167_r;
        this.field_70166_s = this.player.field_70166_s;
    }
}

