/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.client.tracker.ClientEntityTracker;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.morph.client.entity.EntityBiomassAbility;
import me.ichun.mods.morph.client.render.MorphRenderHandler;
import me.ichun.mods.morph.common.Morph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT)
public class EntityAcquisition
extends Entity {
    @Nonnull
    public LivingEntity livingOrigin;
    @Nonnull
    public LivingEntity livingAcquired;
    public boolean isMorphAcquisition;
    public ArrayList<Tendril> tendrils = new ArrayList();
    public int maxRequiredTendrils;
    public int age;
    public MorphRenderHandler.ModelRendererCapture acquiredCapture = new MorphRenderHandler.ModelRendererCapture();

    public EntityAcquisition(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_82142_c(true);
        this.func_184224_h(true);
        this.func_145769_d(ClientEntityTracker.getNextEntId());
    }

    public EntityAcquisition setTargets(@Nonnull LivingEntity origin, @Nonnull LivingEntity acquired, boolean isMorphAcquisition) {
        this.livingOrigin = origin;
        this.livingAcquired = acquired;
        this.isMorphAcquisition = isMorphAcquisition;
        this.syncWithOriginPosition();
        if (isMorphAcquisition) {
            this.tendrils.add(new Tendril(null).headTowards(this.getTargetPos(), false));
        }
        return this;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        if (!this.livingOrigin.func_70089_S() || !this.livingOrigin.field_70170_p.func_234923_W_().equals(this.field_70170_p.func_234923_W_())) {
            if (this.livingOrigin.field_70128_L) {
                this.func_70106_y();
            }
        } else if (this.age > Morph.configClient.acquisitionTendrilMaxChild * 10 + 100) {
            this.func_70106_y();
            if (this.livingOrigin instanceof PlayerEntity) {
                EntityBiomassAbility ability = ((EntityBiomassAbility)Morph.EntityTypes.BIOMASS_ABILITY.func_200721_a(this.field_70170_p)).setInfo((PlayerEntity)this.livingOrigin, 10, 0);
                ((ClientWorld)this.field_70170_p).func_217411_a(ability.func_145782_y(), (Entity)ability);
            }
        } else {
            this.func_70107_b(this.livingOrigin.func_226277_ct_(), this.livingOrigin.func_226278_cu_() + (double)this.livingOrigin.func_213302_cg() / 2.0, this.livingOrigin.func_226281_cx_());
            this.func_70101_b(this.livingOrigin.field_70177_z, this.livingOrigin.field_70125_A);
            boolean allDone = !this.tendrils.isEmpty();
            boolean anyRetracting = false;
            boolean anyNonRetracting = false;
            for (Tendril tendril : this.tendrils) {
                if (!tendril.isDone()) {
                    allDone = false;
                    tendril.tick();
                    if (tendril.retract) {
                        anyRetracting = true;
                        continue;
                    }
                    anyNonRetracting = true;
                    continue;
                }
                anyRetracting = true;
            }
            if (this.isMorphAcquisition) {
                if (this.tendrils.size() < 5 && this.age % 2 == 0) {
                    this.tendrils.add(new Tendril(null).headTowards(this.getTargetPos(), false));
                    allDone = false;
                }
                if (anyRetracting && anyNonRetracting) {
                    for (Tendril tendril : this.tendrils) {
                        tendril.propagateRetractToChild();
                    }
                }
            } else if (this.tendrils.size() < this.maxRequiredTendrils && !this.acquiredCapture.infos.isEmpty() && this.age % 3 == 0) {
                this.tendrils.add(new Tendril(null).headTowards(this.getTargetPos(), true));
                allDone = false;
            }
            if (allDone) {
                this.func_70106_y();
                if (this.livingOrigin instanceof PlayerEntity) {
                    EntityBiomassAbility ability = ((EntityBiomassAbility)Morph.EntityTypes.BIOMASS_ABILITY.func_200721_a(this.field_70170_p)).setInfo((PlayerEntity)this.livingOrigin, 10, 0);
                    ((ClientWorld)this.field_70170_p).func_217411_a(ability.func_145782_y(), (Entity)ability);
                }
            }
        }
    }

    public Vector3d getTargetPos() {
        return this.livingAcquired.func_213303_ch().func_72441_c(0.0, (double)this.livingAcquired.func_213302_cg() / 2.0, 0.0);
    }

    public AxisAlignedBB func_184177_bl() {
        return this.livingOrigin.func_174813_aQ().func_111270_a(this.livingAcquired.func_174813_aQ());
    }

    public boolean func_70112_a(double distance) {
        return this.livingOrigin.func_70112_a(distance) || this.livingAcquired.func_70112_a(distance);
    }

    public float func_70013_c() {
        return this.livingOrigin.func_70013_c();
    }

    protected void func_70088_a() {
    }

    public boolean func_184198_c(CompoundNBT compound) {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void syncWithOriginPosition() {
        double height = (double)this.livingOrigin.func_213302_cg() / 2.0;
        this.func_70012_b(this.livingOrigin.func_226277_ct_(), this.livingOrigin.func_226278_cu_() + height, this.livingOrigin.func_226281_cx_(), this.livingOrigin.field_70177_z, this.livingOrigin.field_70125_A);
        this.field_70142_S = this.livingOrigin.field_70142_S;
        this.field_70137_T = this.livingOrigin.field_70137_T + height;
        this.field_70136_U = this.livingOrigin.field_70136_U;
        this.field_70169_q = this.livingOrigin.field_70169_q;
        this.field_70167_r = this.livingOrigin.field_70167_r + height;
        this.field_70166_s = this.livingOrigin.field_70166_s;
    }

    static /* synthetic */ Random access$100(EntityAcquisition x0) {
        return x0.field_70146_Z;
    }

    static /* synthetic */ Random access$200(EntityAcquisition x0) {
        return x0.field_70146_Z;
    }

    public class Tendril {
        @Nullable
        private Tendril parent;
        private Tendril child;
        private Vector3d offset;
        private float yaw;
        private float pitch;
        private float lastHeight = 1.0f;
        private float height = 1.0f;
        private float maxGrowth = 7.0f + (float)EntityAcquisition.access$100(EntityAcquisition.this).nextGaussian() * 2.0f;
        private boolean retract;
        private int retractTime;
        private float prevRotateSpin;
        private float rotateSpin;
        private float spinFactor = (float)EntityAcquisition.access$200(EntityAcquisition.this).nextGaussian() * 15.0f;
        public int depth = 0;
        private MorphRenderHandler.ModelRendererCapture capture;

        public Tendril(Tendril parent) {
            this.parent = parent;
            if (parent != null) {
                this.offset = parent.getReachOffset().func_178788_d(EntityAcquisition.this.func_174806_f(parent.pitch, parent.yaw).func_216372_d((double)0.025f, (double)0.025f, (double)0.025f));
                this.depth = parent.depth + 1;
            } else {
                this.offset = new Vector3d(0.0, 0.0, 0.0);
            }
        }

        public Tendril headTowards(Vector3d pos, boolean rev) {
            float randGaus = 5.0f;
            if (this.parent != null) {
                this.yaw = this.parent.yaw;
                this.pitch = this.parent.pitch;
                Vector3d origin = this.parent.getReachCoord();
                double d0 = pos.func_82615_a() - origin.func_82615_a();
                double d1 = pos.func_82617_b() - origin.func_82617_b();
                double d2 = pos.func_82616_c() - origin.func_82616_c();
                float maxChange = EntityAcquisition.this.isMorphAcquisition ? 30.0f : 60.0f;
                double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float newYaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float newPitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)dist) * 57.2957763671875));
                this.pitch = EntityHelper.updateRotation((float)this.pitch, (float)newPitch, (float)maxChange);
                this.yaw = EntityHelper.updateRotation((float)this.yaw, (float)newYaw, (float)maxChange);
            } else {
                this.yaw = (rev ? EntityAcquisition.this.livingOrigin.field_70761_aq + 180.0f : EntityAcquisition.this.livingOrigin.field_70761_aq) % 360.0f;
                this.pitch = 0.0f;
                if (!EntityAcquisition.this.isMorphAcquisition) {
                    randGaus = 30.0f;
                }
                this.yaw += (5.0f + 25.0f * EntityAcquisition.this.field_70146_Z.nextFloat()) * (EntityAcquisition.this.field_70146_Z.nextBoolean() ? 1.0f : -1.0f);
                this.pitch += (float)EntityAcquisition.this.field_70146_Z.nextGaussian() * randGaus;
            }
            this.yaw += (float)EntityAcquisition.this.field_70146_Z.nextGaussian() * randGaus;
            this.pitch += (float)EntityAcquisition.this.field_70146_Z.nextGaussian() * randGaus;
            return this;
        }

        public void tick() {
            this.lastHeight = this.height;
            if (this.retract) {
                ++this.retractTime;
            }
            if (this.child != null) {
                this.child.tick();
            } else {
                float distToEnt = EntityAcquisition.this.livingOrigin.func_70032_d((Entity)EntityAcquisition.this.livingAcquired);
                if (!EntityAcquisition.this.isMorphAcquisition) {
                    distToEnt *= 2.0f;
                }
                if (!this.retract) {
                    if (this.height < this.maxGrowth) {
                        float maxTendrilGrowth = Math.max(0.0625f, distToEnt / (float)Morph.configClient.acquisitionTendrilMaxChild + (float)EntityAcquisition.this.field_70146_Z.nextGaussian() * 0.125f);
                        this.height += maxTendrilGrowth * 16.0f;
                        if (this.getReachCoord().func_72438_d(EntityAcquisition.this.getTargetPos()) < (double)Math.max(0.3f, maxTendrilGrowth)) {
                            if (!EntityAcquisition.this.isMorphAcquisition && EntityAcquisition.this.age <= 10) {
                                this.height -= maxTendrilGrowth * 16.0f;
                                return;
                            }
                            this.child = new Tendril(this);
                            Vector3d pos = EntityAcquisition.this.getTargetPos();
                            Vector3d origin = this.getReachCoord();
                            double d0 = pos.func_82615_a() - origin.func_82615_a();
                            double d1 = pos.func_82617_b() - origin.func_82617_b();
                            double d2 = pos.func_82616_c() - origin.func_82616_c();
                            double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                            this.child.yaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                            this.child.pitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)dist) * 57.2957763671875));
                            this.child.lastHeight = this.child.height = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2)) / 16.0f;
                            if (EntityAcquisition.this.isMorphAcquisition) {
                                this.child.capture = EntityAcquisition.this.acquiredCapture;
                                EntityAcquisition.this.acquiredCapture = null;
                            } else if (!EntityAcquisition.this.acquiredCapture.infos.isEmpty()) {
                                this.child.capture = new MorphRenderHandler.ModelRendererCapture();
                                int count = (int)Math.ceil(Math.max((float)EntityAcquisition.this.acquiredCapture.infos.size() / 10.0f, 1.0f));
                                for (int x = 0; x < count && !EntityAcquisition.this.acquiredCapture.infos.isEmpty(); ++x) {
                                    int i = EntityAcquisition.this.field_70146_Z.nextInt(EntityAcquisition.this.acquiredCapture.infos.size());
                                    this.child.capture.infos.add(EntityAcquisition.this.acquiredCapture.infos.get(i));
                                    EntityAcquisition.this.acquiredCapture.infos.remove(i);
                                    if (x <= 0) continue;
                                    --EntityAcquisition.this.maxRequiredTendrils;
                                }
                            }
                            this.child.propagateRetractToParent();
                        }
                        if (!EntityAcquisition.this.isMorphAcquisition && EntityAcquisition.this.acquiredCapture.infos.isEmpty()) {
                            this.propagateRetractToParent();
                        }
                    } else {
                        this.child = new Tendril(this).headTowards(EntityAcquisition.this.getTargetPos(), false);
                    }
                } else if (this.retractTime <= 3) {
                    float maxTendrilGrowth = Math.max(0.0625f, distToEnt / (float)Morph.configClient.acquisitionTendrilMaxChild + (float)EntityAcquisition.this.field_70146_Z.nextGaussian() * 0.125f);
                    if (this.getReachCoord().func_72438_d(EntityAcquisition.this.getTargetPos()) > (double)Math.max(0.5f, maxTendrilGrowth)) {
                        Vector3d pos = EntityAcquisition.this.getTargetPos();
                        Vector3d origin = this.getReachCoord();
                        double d0 = pos.func_82615_a() - origin.func_82615_a();
                        double d1 = pos.func_82617_b() - origin.func_82617_b();
                        double d2 = pos.func_82616_c() - origin.func_82616_c();
                        double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                        this.yaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                        this.pitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)dist) * 57.2957763671875));
                        this.height += maxTendrilGrowth * 16.0f;
                    }
                } else if (this.height > 0.0f && this.retractTime > 6) {
                    this.prevRotateSpin = this.rotateSpin;
                    if (this.capture != null) {
                        this.rotateSpin += this.spinFactor;
                    }
                    float maxTendrilGrowth = Math.max(0.0625f, distToEnt / ((float)Morph.configClient.acquisitionTendrilMaxChild * 2.0f) + (float)EntityAcquisition.this.field_70146_Z.nextGaussian() * 0.125f);
                    this.height -= maxTendrilGrowth * 16.0f;
                    if (this.height <= 0.0f) {
                        this.height = 0.0f;
                        if (this.parent != null) {
                            this.parent.child = null;
                            if (this.capture != null) {
                                this.parent.capture = this.capture;
                                this.parent.prevRotateSpin = this.prevRotateSpin;
                                this.parent.rotateSpin = this.rotateSpin;
                            }
                        }
                    }
                }
            }
        }

        public boolean isDone() {
            return this.retract && this.height <= 0.0f;
        }

        public void propagateRetractToParent() {
            this.retract = true;
            if (this.parent != null) {
                this.parent.propagateRetractToParent();
            }
        }

        public void propagateRetractToChild() {
            this.retract = true;
            if (this.child != null) {
                this.child.propagateRetractToChild();
            }
        }

        public Vector3d getReachOffset() {
            float growth = this.height / 16.0f;
            return this.offset.func_178787_e(EntityAcquisition.this.func_174806_f(this.pitch, this.yaw).func_216372_d((double)growth, (double)growth, (double)growth));
        }

        public Vector3d getReachCoord() {
            return EntityAcquisition.this.func_213303_ch().func_178787_e(this.getReachOffset());
        }

        public float getWidth(float partialTick) {
            float width = 1.0f + 0.2f * this.remainingDepth(partialTick);
            if (width > 3.5f) {
                width = 3.5f;
            }
            return width;
        }

        public float remainingDepth(float partialTick) {
            int depth = 0;
            Tendril aParent = this;
            Tendril aChild = aParent.child;
            while (aChild != null) {
                depth = (int)((float)depth + Math.min((aChild.lastHeight + (aChild.height - aChild.lastHeight) * partialTick) / aChild.maxGrowth, 1.0f));
                aParent = aChild;
                aChild = aParent.child;
            }
            return depth;
        }

        public void createModelRenderer(ArrayList<ModelRenderer> renderers, float partialTick) {
            if (this.child != null) {
                this.child.createModelRenderer(renderers, partialTick);
            }
            ModelRenderer model = new ModelRenderer(64, 64, EntityAcquisition.this.field_70146_Z.nextInt(8), EntityAcquisition.this.field_70146_Z.nextInt(8));
            float width = this.getWidth(partialTick);
            float halfWidth = width / 2.0f;
            model.func_228300_a_(-halfWidth, -halfWidth, 0.0f, width, width, this.lastHeight + (this.height - this.lastHeight) * partialTick);
            model.field_78800_c = (float)(this.offset.func_82615_a() * 16.0);
            model.field_78797_d = (float)(this.offset.func_82617_b() * 16.0);
            model.field_78798_e = (float)(this.offset.func_82616_c() * 16.0);
            model.field_78795_f = (float)Math.toRadians(this.pitch);
            model.field_78796_g = (float)Math.toRadians(-this.yaw);
            renderers.add(model);
        }

        public void renderCapture(EntityAcquisition acquisition, MatrixStack stack, IVertexBuilder vertexBuilder, int light, int overlay, float partialTick) {
            if (this.child != null) {
                this.child.renderCapture(acquisition, stack, vertexBuilder, light, overlay, partialTick);
            } else if (this.capture != null) {
                float renderHeight = this.lastHeight + (this.height - this.lastHeight) * partialTick;
                float heightOffset = renderHeight / 16.0f;
                Vector3d look = EntityAcquisition.this.func_174806_f(this.pitch, this.yaw);
                Vector3d renderPoint = this.offset.func_178787_e(look.func_216372_d((double)heightOffset, (double)heightOffset, (double)heightOffset));
                float alpha = 1.0f;
                if (acquisition.livingOrigin == Minecraft.func_71410_x().func_175606_aa() && Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
                    alpha = MathHelper.func_76131_a((float)((float)(this.depth + 1) / (float)Morph.configClient.acquisitionTendrilPartOpacity), (float)0.0f, (float)1.0f);
                }
                if (alpha > 0.0f) {
                    double distToEnt = acquisition.livingOrigin.func_70032_d((Entity)acquisition.livingAcquired);
                    double distToRenderPoint = MathHelper.func_76133_a((double)acquisition.func_195048_a(acquisition.func_213303_ch().func_178787_e(renderPoint)));
                    float scale = distToEnt > 0.0 ? (float)(Math.min(distToEnt, distToRenderPoint + 0.5) / distToEnt) : 0.0f;
                    stack.func_227860_a_();
                    stack.func_227861_a_(renderPoint.func_82615_a(), renderPoint.func_82617_b(), renderPoint.func_82616_c());
                    stack.func_227862_a_(scale, scale, scale);
                    float rot = this.prevRotateSpin + (this.rotateSpin - this.prevRotateSpin) * partialTick;
                    stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rot));
                    stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot));
                    stack.func_227861_a_(0.0, -((double)acquisition.livingAcquired.func_213302_cg() / 2.0), 0.0);
                    if (EntityAcquisition.this.isMorphAcquisition) {
                        this.capture.render(stack, vertexBuilder, light, overlay, alpha);
                    } else {
                        for (MorphRenderHandler.ModelRendererCapture.CaptureInfo info : this.capture.infos) {
                            MatrixStack identityStack = new MatrixStack();
                            stack.func_227860_a_();
                            MatrixStack.Entry e = RenderHelper.createInterimStackEntry((MatrixStack.Entry)identityStack.func_227866_c_(), (MatrixStack.Entry)info.e, (float)MathHelper.func_76131_a((float)(scale * 3.0f), (float)0.0f, (float)1.0f));
                            MatrixStack.Entry last = stack.func_227866_c_();
                            last.func_227870_a_().func_226595_a_(e.func_227870_a_());
                            last.func_227872_b_().func_226118_b_(e.func_227872_b_());
                            info.createAndRender(stack, vertexBuilder, light, overlay, 1.0f, 1.0f, 1.0f, alpha);
                            stack.func_227865_b_();
                        }
                    }
                    stack.func_227865_b_();
                }
            }
        }
    }
}

