/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.core;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import me.ichun.mods.ichunutil.client.gui.mouse.MouseHelper;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.client.render.NativeImageTexture;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.api.morph.MorphState;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.client.core.KeyBinds;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.save.PlayerMorphData;
import me.ichun.mods.morph.common.packet.PacketMorphInput;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class HudHandler {
    public static final ResourceLocation TEX_QS_FAVOURITE = new ResourceLocation("morph", "textures/gui/fav.png");
    public static final ResourceLocation TEX_QS_SELECTED = new ResourceLocation("morph", "textures/gui/gui_selected.png");
    public static final ResourceLocation TEX_QS_UNSELECTED = new ResourceLocation("morph", "textures/gui/gui_unselected.png");
    public static final ResourceLocation TEX_QS_UNSELECTED_SIDE = new ResourceLocation("morph", "textures/gui/gui_unselected_side.png");
    private static final MatrixStack LIGHT_STACK = (MatrixStack)Util.func_200696_a((Object)new MatrixStack(), stack -> stack.func_227861_a_(1.0, -1.0, 0.0));
    private final Minecraft mc;
    private static final int SHOW_SELECTOR_TIME = 8;
    private static final int INDEX_TIME = 4;
    public boolean showSelector = false;
    public int showTime = 0;
    public int indexChangeTime = 0;
    public double lastIndexVert = 0.0;
    public double lastIndexHori = 0.0;
    public int indexVert = 0;
    public int indexHori = 0;
    private static final int RADIAL_TIME = 3;
    public boolean showRadial = false;
    public int radialTime = 0;
    public RadialMode radialMode = null;
    public ArrayList<MorphVariant> radialFavourites = null;
    private static final int BAR_TIME = 8;
    private static NativeImageTexture barTexture = null;
    private static boolean barTextureGenerated = false;
    public boolean barRequiresReset;
    public int barShowTime = 0;
    private BiomassValue barCapacity;
    private BiomassValue barCriticalCapacity;
    private BiomassValue barCurrentBiomass;
    private double barAbilityCost = 0.0;
    private int barInsufficientFlash;
    public boolean keyEscDown;
    public boolean keyEnterDown;
    public boolean keyDeleteDown;
    public boolean keyDirUp;
    public boolean keyDirDown;
    public boolean keyDirLeft;
    public boolean keyDirRight;
    public HashMap<MorphVariant, MorphState> morphStates = new HashMap();

    public HudHandler(Minecraft mc, PlayerMorphData morphData) {
        this.mc = mc;
        this.barCapacity = new BiomassValue(morphData.getBiomassUpgradeValue("biomass_capacity"));
        this.barCriticalCapacity = new BiomassValue(morphData.getBiomassUpgradeValue("biomass_critical_capacity"));
        this.barCurrentBiomass = new BiomassValue(morphData.biomass);
    }

    public void handleInput(KeyBind keyBind, boolean isReleased) {
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (keyBind == KeyBinds.keySelectorUp || keyBind == KeyBinds.keySelectorDown || keyBind == KeyBinds.keySelectorLeft || keyBind == KeyBinds.keySelectorRight || keyBind == KeyBinds.keyFavourite) {
            this.handleMorphInput(keyBind, isReleased);
        }
    }

    private void handleMorphInput(KeyBind keyBind, boolean isReleased) {
        if (MorphHandler.INSTANCE.canShowMorphSelector((PlayerEntity)this.mc.field_71439_g)) {
            if (keyBind == KeyBinds.keySelectorDown || keyBind == KeyBinds.keySelectorUp || keyBind == KeyBinds.keySelectorLeft || keyBind == KeyBinds.keySelectorRight) {
                if (this.showSelector) {
                    this.shiftIndexSelector(keyBind == KeyBinds.keySelectorDown || keyBind == KeyBinds.keySelectorRight, keyBind == KeyBinds.keySelectorLeft || keyBind == KeyBinds.keySelectorRight);
                } else {
                    this.showSelector = true;
                    this.setIndicesToCurrentMorph();
                    this.keyEscDown = false;
                    this.keyEnterDown = false;
                }
            } else if (keyBind == KeyBinds.keyFavourite) {
                if (this.showSelector) {
                    if (isReleased) {
                        this.toggleFavourite();
                    }
                } else if (!isReleased) {
                    if (!this.showRadial) {
                        this.gatherFavourites();
                        this.showRadial = true;
                        this.radialTime = 0;
                        this.radialMode = RadialMode.FAVOURITE;
                        this.mc.field_71417_B.func_198032_j();
                    }
                } else if (this.radialMode == RadialMode.FAVOURITE) {
                    this.confirmRadial();
                }
            }
        } else if (keyBind != KeyBinds.keyFavourite || !isReleased) {
            this.barInsufficientFlash = 20;
        }
    }

    public void setIndicesToCurrentMorph() {
        PlayerMorphData morphData = this.getMorphData();
        this.indexHori = 0;
        this.indexVert = 0;
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this.mc.field_71439_g);
        if (info.isMorphed()) {
            MorphVariant currentMorph = info.nextState.variant;
            block0: for (int i = 0; i < morphData.morphs.size(); ++i) {
                MorphVariant variant = morphData.morphs.get(i);
                if (!variant.id.equals((Object)currentMorph.id)) continue;
                this.indexVert = i;
                for (int i1 = 0; i1 < variant.variants.size(); ++i1) {
                    MorphVariant.Variant morphVariant = variant.variants.get(i1);
                    if (!morphVariant.identifier.equals(currentMorph.thisVariant.identifier)) continue;
                    this.indexHori = i1;
                    this.lastIndexHori = variant.variants.size() - 1;
                    break block0;
                }
                break;
            }
        }
        this.lastIndexVert = this.indexVert;
        this.indexChangeTime = 0;
    }

    public void updateMorphs() {
        if (this.shouldRenderSelector()) {
            this.validateIndices();
        }
    }

    private void tick() {
        if (this.shouldShowBiomassBar()) {
            ++this.barShowTime;
            if (this.barShowTime > 8) {
                this.barShowTime = 8;
                this.updateBiomassBar();
            }
        } else {
            --this.barShowTime;
            if (this.barShowTime < 0) {
                this.barShowTime = 0;
            }
        }
        if (this.showSelector) {
            ++this.showTime;
            if (this.showTime > 8) {
                this.showTime = 8;
            }
        } else {
            --this.showTime;
            if (this.showTime < 0) {
                this.showTime = 0;
            }
        }
        ++this.indexChangeTime;
        if (this.indexChangeTime > 4) {
            this.indexChangeTime = 4;
            this.lastIndexVert = this.indexVert;
            this.lastIndexHori = this.indexHori;
        }
        if (this.showRadial) {
            ++this.radialTime;
            if (this.radialTime > 3) {
                this.radialTime = 3;
            }
        }
        this.updateKeyListeners();
    }

    private void updateKeyListeners() {
        boolean isEnterDown = InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)257) || InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)335);
        boolean isEscDown = InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)256);
        boolean isDeleteDown = InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)261) || InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)330);
        boolean isDirUp = InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)265);
        boolean isDirDown = InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)264);
        boolean isDirLeft = InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)263);
        boolean isDirRight = InputMappings.func_216506_a((long)this.mc.func_228018_at_().func_198092_i(), (int)262);
        if (this.showSelector || this.showRadial) {
            if (!this.keyEnterDown && isEnterDown) {
                if (this.showSelector) {
                    this.confirmSelector();
                } else {
                    this.confirmRadial();
                }
            }
            if (this.mc.field_71462_r != null || !this.keyEscDown && isEscDown) {
                if (this.showSelector) {
                    this.closeSelector();
                } else {
                    this.closeRadial();
                }
            }
            if (this.showSelector) {
                if (!this.keyDeleteDown && isDeleteDown) {
                    this.deleteSelector();
                }
                if (!this.keyDirUp && isDirUp) {
                    this.shiftIndexSelector(false, false);
                }
                if (!this.keyDirDown && isDirDown) {
                    this.shiftIndexSelector(true, false);
                }
                if (!this.keyDirLeft && isDirLeft) {
                    this.shiftIndexSelector(false, true);
                }
                if (!this.keyDirRight && isDirRight) {
                    this.shiftIndexSelector(true, true);
                }
            }
        }
        this.keyEnterDown = isEnterDown;
        this.keyEscDown = isEscDown;
        this.keyDeleteDown = isDeleteDown;
        this.keyDirUp = isDirUp;
        this.keyDirDown = isDirDown;
        this.keyDirLeft = isDirLeft;
        this.keyDirRight = isDirRight;
    }

    private void updateBiomassBar() {
        if (this.barInsufficientFlash > 0) {
            --this.barInsufficientFlash;
        }
        this.barCapacity.tick();
        this.barCriticalCapacity.tick();
        this.barCurrentBiomass.tick();
    }

    private void confirmSelector() {
        MorphVariant.Variant variant;
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this.mc.field_71439_g);
        if (!info.isCurrentlyThisVariant(variant = this.getMorphData().morphs.get((int)this.indexVert).variants.get(this.indexHori))) {
            Morph.channel.sendToServer((AbstractPacket)new PacketMorphInput(variant.identifier, false, false, false));
        }
        this.closeSelector();
    }

    private void deleteSelector() {
        MorphVariant.Variant variant;
        MorphInfo info;
        if (MorphHandler.INSTANCE.getMorphModeName().equals("classic") && !(info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this.mc.field_71439_g)).isCurrentlyThisVariant(variant = this.getMorphData().morphs.get((int)this.indexVert).variants.get(this.indexHori)) && !variant.identifier.equals("default_player_state")) {
            Morph.channel.sendToServer((AbstractPacket)new PacketMorphInput(variant.identifier, false, false, true));
        }
    }

    private void closeSelector() {
        this.showSelector = false;
        if (this.mc.field_71462_r instanceof IngameMenuScreen) {
            this.mc.func_147108_a(null);
        }
        PlayerMorphData morphData = this.getMorphData();
        this.indexHori = morphData.morphs.get((int)this.indexVert).variants.size() - 1;
        this.indexChangeTime = 0;
    }

    private void confirmRadial() {
        if (this.isMouseOutsideRadialDeadZone(this.mc.func_228018_at_()) && this.radialMode == RadialMode.FAVOURITE) {
            MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this.mc.field_71439_g);
            MorphVariant variant = this.radialFavourites.get(MouseHelper.getSelectedIndex((int)this.radialFavourites.size()));
            if (!info.isCurrentlyThisVariant(variant.thisVariant)) {
                Morph.channel.sendToServer((AbstractPacket)new PacketMorphInput(variant.thisVariant.identifier, false, false, false));
            }
            this.radialFavourites = null;
        }
        this.closeRadial();
    }

    private void closeRadial() {
        this.showRadial = false;
        this.radialMode = null;
        if (this.mc.field_71462_r instanceof IngameMenuScreen) {
            this.mc.func_147108_a(null);
        }
        this.mc.field_71417_B.func_198034_i();
    }

    private void toggleFavourite() {
        MorphVariant.Variant variant = this.getMorphData().morphs.get((int)this.indexVert).variants.get(this.indexHori);
        if (!variant.identifier.equals("default_player_state")) {
            variant.isFavourite = !variant.isFavourite;
            Morph.channel.sendToServer((AbstractPacket)new PacketMorphInput(variant.identifier, true, variant.isFavourite, false));
        }
    }

    private void gatherFavourites() {
        this.radialFavourites = new ArrayList();
        this.radialFavourites.add(MorphVariant.createPlayerMorph(this.mc.field_71439_g.func_146103_bH().getId(), true));
        this.radialFavourites.get((int)0).thisVariant.identifier = "default_player_state";
        PlayerMorphData morphData = this.getMorphData();
        for (MorphVariant morph : morphData.morphs) {
            if (!morph.hasFavourite()) continue;
            for (MorphVariant.Variant variant : morph.variants) {
                if (!variant.isFavourite) continue;
                this.radialFavourites.add(morph.getAsVariant(variant));
            }
        }
    }

    private void shiftIndexSelector(boolean isDown, boolean isHori) {
        PlayerMorphData morphData = this.getMorphData();
        if (isDown) {
            if (isHori) {
                this.lastIndexHori += ((double)this.indexHori - this.lastIndexHori) * (double)EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)((float)this.indexChangeTime / 4.0f), (float)0.0f, (float)1.0f));
                ++this.indexHori;
                if (this.indexHori >= morphData.morphs.get((int)this.indexVert).variants.size()) {
                    this.indexHori = 0;
                }
            } else {
                this.lastIndexVert += ((double)this.indexVert - this.lastIndexVert) * (double)EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)((float)this.indexChangeTime / 4.0f), (float)0.0f, (float)1.0f));
                ++this.indexVert;
                if (this.indexVert >= morphData.morphs.size()) {
                    this.indexVert = 0;
                }
                if (morphData.morphs.size() > 1) {
                    this.lastIndexHori = morphData.morphs.get((int)this.indexVert).variants.size() - 1;
                    this.indexHori = 0;
                }
            }
        } else if (isHori) {
            this.lastIndexHori += ((double)this.indexHori - this.lastIndexHori) * (double)EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)((float)this.indexChangeTime / 4.0f), (float)0.0f, (float)1.0f));
            --this.indexHori;
            if (this.indexHori < 0) {
                this.indexHori = morphData.morphs.get((int)this.indexVert).variants.size() - 1;
            }
        } else {
            this.lastIndexVert += ((double)this.indexVert - this.lastIndexVert) * (double)EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)((float)this.indexChangeTime / 4.0f), (float)0.0f, (float)1.0f));
            --this.indexVert;
            if (this.indexVert < 0) {
                this.indexVert = morphData.morphs.size() - 1;
            }
            if (morphData.morphs.size() > 1) {
                this.lastIndexHori = morphData.morphs.get((int)this.indexVert).variants.size() - 1;
                this.indexHori = 0;
            }
        }
        this.indexChangeTime = 0;
    }

    private void validateIndices() {
        PlayerMorphData morphData = this.getMorphData();
        if (this.indexVert >= morphData.morphs.size()) {
            this.indexVert = 0;
            this.lastIndexHori = morphData.morphs.get((int)this.indexVert).variants.size() - 1;
            this.indexHori = 0;
        } else if (this.indexVert < 0) {
            this.indexVert = morphData.morphs.size() - 1;
            this.lastIndexHori = morphData.morphs.get((int)this.indexVert).variants.size() - 1;
            this.indexHori = 0;
        }
        if (this.indexHori >= morphData.morphs.get((int)this.indexVert).variants.size()) {
            this.indexHori = 0;
        } else if (this.indexHori < 0) {
            this.indexHori = morphData.morphs.get((int)this.indexVert).variants.size() - 1;
        }
    }

    private void drawSelector(MatrixStack stack, float partialTick, MainWindow window) {
        MorphVariant currentMorph;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        double zLevel = 0.0;
        double size = 50.0 * Morph.configClient.selectorScale;
        float outProg = EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(this.showSelector ? ((float)this.showTime + partialTick) / 8.0f : ((float)this.showTime - partialTick) / 8.0f), (float)0.0f, (float)1.0f));
        int top = Morph.configClient.selectorDistanceFromTop;
        double posX = -size * (double)(1.0f - outProg);
        PlayerMorphData morphData = this.getMorphData();
        float indexChangeTimeProg = EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(((float)this.indexChangeTime + partialTick) / 4.0f), (float)0.0f, (float)1.0f));
        double indexVertProg = this.lastIndexVert + ((double)this.indexVert - this.lastIndexVert) * (double)indexChangeTimeProg;
        double unSelY = indexVertProg * size;
        double height = size * (double)morphData.morphs.size();
        this.mc.func_110434_K().func_110577_a(TEX_QS_UNSELECTED);
        RenderHelper.draw((MatrixStack)stack, (double)posX, (double)((double)top - unSelY), (double)size, (double)height, (double)zLevel, (double)0.0, (double)1.0, (double)0.0, (double)morphData.morphs.size());
        double indexHoriProg = this.lastIndexHori + ((double)this.indexHori - this.lastIndexHori) * (double)indexChangeTimeProg;
        double unSelX = indexHoriProg * size;
        double width = size * (double)(morphData.morphs.get((int)this.indexVert).variants.size() - 1);
        if (width > 0.0) {
            this.mc.func_110434_K().func_110577_a(TEX_QS_UNSELECTED_SIDE);
            RenderHelper.draw((MatrixStack)stack, (double)(posX - unSelX), (double)top, (double)width, (double)size, (double)zLevel, (double)0.0, (double)(morphData.morphs.get((int)this.indexVert).variants.size() - 1), (double)0.0, (double)1.0);
        }
        this.mc.func_110434_K().func_110577_a(TEX_QS_UNSELECTED);
        RenderHelper.draw((MatrixStack)stack, (double)(posX - unSelX + width), (double)top, (double)size, (double)size, (double)zLevel, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        RenderHelper.drawTexture((MatrixStack)stack, (ResourceLocation)TEX_QS_SELECTED, (double)posX, (double)top, (double)size, (double)size, (double)zLevel);
        int screenHeight = window.func_198087_p();
        int firstMorphIndex = Math.max(0, this.indexVert - ((int)Math.ceil((double)top / size) + 1));
        int lastMorphIndex = Math.min(morphData.morphs.size(), this.indexVert + ((int)Math.ceil((double)(screenHeight - top) / size) + 1));
        ClientPlayerEntity player = this.mc.field_71439_g;
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)player);
        if (info.isMorphed()) {
            currentMorph = info.nextState.variant;
        } else {
            currentMorph = MorphVariant.createPlayerMorph(player.func_146103_bH().getId(), true);
            currentMorph.thisVariant.identifier = "default_player_state";
        }
        for (int i = firstMorphIndex; i < lastMorphIndex; ++i) {
            MorphVariant morph = morphData.morphs.get(i);
            double indexSizeHeight = ((double)i - indexVertProg) * size;
            double morphHeight = (double)top + size * 0.775 + indexSizeHeight;
            double d = top;
            this.mc.field_71466_p.getClass();
            double textHeight = d + (size - 9.0) / 2.0 + indexSizeHeight;
            double favHeight = (double)top + size * 0.13 + indexSizeHeight;
            if (i == this.indexVert) {
                for (int j = Math.max(0, this.indexHori - 1); j < morph.variants.size(); ++j) {
                    TranslationTextComponent text;
                    double indexHeightWidth = ((double)j - indexHoriProg) * size;
                    double morphBoxX = posX + indexHeightWidth;
                    MorphVariant.Variant theVariant = morph.variants.get(j);
                    MorphVariant variant = morph.getAsVariant(theVariant);
                    MorphState state = this.morphStates.computeIfAbsent(variant, arg_0 -> HudHandler.lambda$drawSelector$1(variant, (PlayerEntity)player, arg_0));
                    state.variant.thisVariant.isFavourite = theVariant.isFavourite;
                    LivingEntity living = state.getEntityInstance(player.field_70170_p, (PlayerEntity)player);
                    if (morphBoxX < (double)window.func_198107_o() + size) {
                        EntitySize livingSize = living.func_213305_a(Pose.STANDING);
                        float entSize = Math.max(livingSize.field_220315_a, livingSize.field_220316_b) / 1.95f;
                        if (j == this.indexHori) {
                            if (this.showSelector) {
                                entSize *= 1.0f - indexChangeTimeProg;
                            } else if ((long)j == Math.round(this.lastIndexHori) && indexChangeTimeProg < 1.0f || variant.equals(currentMorph)) {
                                entSize = 0.0f;
                            }
                        }
                        float entScale = 0.5f * (1.0f / Math.max(1.0f, entSize));
                        this.renderMorphEntity(living, posX + size / 2.0 - 2.0 + indexHeightWidth, morphHeight, zLevel + (double)(j == this.indexHori ? 100.0f : 50.0f), entScale);
                        zLevel += 30.0;
                        if (j == 0 && morph.hasFavourite() || state.variant.thisVariant.isFavourite) {
                            stack.func_227860_a_();
                            stack.func_227861_a_(0.0, 0.0, 300.0);
                            if (!state.variant.thisVariant.isFavourite) {
                                RenderHelper.colour((int)65535);
                            }
                            RenderHelper.drawTexture((MatrixStack)stack, (ResourceLocation)TEX_QS_FAVOURITE, (double)(posX + 1.0 + indexHeightWidth), (double)favHeight, (double)(size * 0.15), (double)(size * 0.15), (double)zLevel);
                            RenderHelper.colour((int)0xFFFFFF);
                            stack.func_227865_b_();
                        }
                    }
                    if (j != morph.variants.size() - 1) continue;
                    IFormattableTextComponent customName = null;
                    MorphVariant selectedVariant = morph.getAsVariant(morph.variants.get(this.indexHori));
                    MorphState selectedState = this.morphStates.computeIfAbsent(selectedVariant, arg_0 -> HudHandler.lambda$drawSelector$2(selectedVariant, (PlayerEntity)player, arg_0));
                    LivingEntity selectedLiving = selectedState.getEntityInstance(player.field_70170_p, (PlayerEntity)player);
                    EntityType value = (EntityType)ForgeRegistries.ENTITIES.getValue(variant.id);
                    if (value != null) {
                        if (!selectedLiving.func_200200_C_().equals(value.func_212546_e()) && this.showTime >= 8) {
                            customName = selectedLiving.func_200200_C_().func_230532_e_();
                            customName.func_230530_a_(customName.func_150256_b().func_240722_b_(Boolean.valueOf(true)));
                        }
                        text = new TranslationTextComponent(value.func_210760_d());
                    } else {
                        text = new TranslationTextComponent("morph.morph.type.unknown");
                    }
                    if (selectedVariant.equals(currentMorph)) {
                        text.func_230530_a_(text.func_150256_b().func_240712_a_(TextFormatting.GOLD));
                    } else {
                        text.func_230530_a_(text.func_150256_b().func_240712_a_(TextFormatting.YELLOW));
                    }
                    stack.func_227860_a_();
                    stack.func_227861_a_(0.0, 0.0, 500.0);
                    float textPosX = (float)(posX + size + 5.0 + indexHeightWidth);
                    if (textPosX > (float)(window.func_198107_o() - this.mc.field_71466_p.func_238414_a_((ITextProperties)text) - 2)) {
                        textPosX = window.func_198107_o() - this.mc.field_71466_p.func_238414_a_((ITextProperties)text) - 2;
                    }
                    this.mc.field_71466_p.func_243246_a(stack, (ITextComponent)text, textPosX, (float)textHeight, 0xFFFFFF);
                    if (customName != null) {
                        FontRenderer fontRenderer = this.mc.field_71466_p;
                        double d2 = (double)top + size;
                        this.mc.field_71466_p.getClass();
                        fontRenderer.func_243246_a(stack, (ITextComponent)customName, 3.0f, (float)(d2 - 9.0 - 5.0 + indexSizeHeight), 0xFFFFFF);
                    }
                    stack.func_227865_b_();
                }
                continue;
            }
            MorphVariant.Variant theVariant = morph.variants.get(0);
            MorphVariant variant = morph.getAsVariant(theVariant);
            MorphState state = this.morphStates.computeIfAbsent(variant, arg_0 -> HudHandler.lambda$drawSelector$3(variant, (PlayerEntity)player, arg_0));
            state.variant.thisVariant.isFavourite = theVariant.isFavourite;
            LivingEntity living = state.getEntityInstance(player.field_70170_p, (PlayerEntity)player);
            EntitySize livingSize = living.func_213305_a(Pose.STANDING);
            float entSize = Math.max(livingSize.field_220315_a, livingSize.field_220316_b) / 1.95f;
            if ((long)i == Math.round(this.lastIndexVert)) {
                entSize *= indexChangeTimeProg;
            }
            float entScale = 0.5f * (1.0f / Math.max(1.0f, entSize));
            this.renderMorphEntity(living, (int)(posX + size / 2.0 - 2.0), morphHeight, zLevel, entScale);
            zLevel += 30.0;
            EntityType value = (EntityType)ForgeRegistries.ENTITIES.getValue(variant.id);
            TranslationTextComponent text = value != null ? new TranslationTextComponent(value.func_210760_d()) : new TranslationTextComponent("morph.morph.type.unknown");
            if (morph.id.equals((Object)currentMorph.id) && morph.containsVariant(currentMorph)) {
                text.func_230530_a_(text.func_150256_b().func_240712_a_(TextFormatting.GOLD));
            } else {
                text.func_230530_a_(text.func_150256_b().func_240712_a_(TextFormatting.WHITE));
            }
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 300.0);
            if (morph.hasFavourite()) {
                if (!state.variant.thisVariant.isFavourite) {
                    RenderHelper.colour((int)65535);
                }
                RenderHelper.drawTexture((MatrixStack)stack, (ResourceLocation)TEX_QS_FAVOURITE, (double)(posX + 1.0), (double)favHeight, (double)(size * 0.15), (double)(size * 0.15), (double)zLevel);
                RenderHelper.colour((int)0xFFFFFF);
            }
            this.mc.field_71466_p.func_243246_a(stack, (ITextComponent)text, (float)(posX + size + 5.0), (float)textHeight, 0xFFFFFF);
            stack.func_227865_b_();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
    }

    private void drawRadial(MatrixStack stack, float partialTick, MainWindow window) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        double diameter = (double)Math.min(window.func_198107_o(), window.func_198087_p()) * Morph.configClient.radialScale;
        double radius = diameter / 2.0;
        double radialProg = EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(((float)this.radialTime + partialTick) / 3.0f), (float)0.0f, (float)1.0f));
        double radialDist = radius * radialProg;
        float textScale = (float)radius / 96.375f;
        float deadzoneScale = 0.55f;
        float deadzoneSize = (float)radius * deadzoneScale;
        double distanceFromDeadzone = MouseHelper.getMouseDistanceFromCenter((MainWindow)window) - (double)deadzoneSize;
        float bonusScale = MathHelper.func_76131_a((float)((float)(distanceFromDeadzone / (radius * (double)(1.0f - deadzoneScale) * 0.5))), (float)0.0f, (float)1.0f);
        double centerX = (double)window.func_198107_o() / 2.0;
        double centerY = (double)window.func_198087_p() / 2.0;
        float zLevel = 0.0f;
        int slices = this.mc.field_71474_y.field_238330_f_ == GraphicsFanciness.FAST ? 30 : 100;
        stack.func_227860_a_();
        stack.func_227861_a_(centerX, centerY, (double)zLevel);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i <= slices; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)slices;
            bufferbuilder.func_227888_a_(matrix, (float)(Math.cos(angle) * radialDist), (float)(Math.sin(angle) * radialDist), 0.0f).func_225586_a_(0, 0, 0, 150).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, (float)(Math.cos(angle) * radialDist * (double)deadzoneScale), (float)(Math.sin(angle) * radialDist * (double)deadzoneScale), 0.0f).func_225586_a_(0, 0, 0, 150).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        TranslationTextComponent catText = new TranslationTextComponent(this.radialMode == RadialMode.FAVOURITE ? "morph.key.favourite" : "morph.key.ability");
        stack.func_227860_a_();
        stack.func_227861_a_(0.0, 0.0, 300.0);
        stack.func_227862_a_(textScale, textScale, 1.0f);
        int textWidth = this.mc.field_71466_p.func_238414_a_((ITextProperties)catText);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        float f = (float)(-textWidth) / 2.0f;
        this.mc.field_71466_p.getClass();
        fontRenderer.func_243246_a(stack, (ITextComponent)catText, f, (float)(-9) / 2.0f, 0xFFFFFF);
        stack.func_227865_b_();
        if (this.radialMode == RadialMode.FAVOURITE) {
            boolean isSelectedIndex;
            LivingEntity living;
            MorphState state;
            MorphVariant variant;
            int i;
            MorphVariant currentMorph;
            ClientPlayerEntity player = this.mc.field_71439_g;
            MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)player);
            if (info.isMorphed()) {
                currentMorph = info.nextState.variant;
            } else {
                currentMorph = MorphVariant.createPlayerMorph(player.func_146103_bH().getId(), true);
                currentMorph.thisVariant.identifier = "default_player_state";
            }
            for (i = 0; i < this.radialFavourites.size(); ++i) {
                variant = this.radialFavourites.get(i);
                state = this.morphStates.computeIfAbsent(variant, arg_0 -> HudHandler.lambda$drawRadial$4(variant, (PlayerEntity)player, arg_0));
                living = state.getEntityInstance(player.field_70170_p, (PlayerEntity)player);
                isSelectedIndex = this.isMouseOutsideRadialDeadZone(window) && i == MouseHelper.getSelectedIndex((int)this.radialFavourites.size());
                EntitySize livingSize = living.func_213305_a(Pose.STANDING);
                float entSize = Math.max(livingSize.field_220315_a, livingSize.field_220316_b) / 1.95f;
                float entScale = 0.4f * (1.0f / Math.max(1.0f, entSize)) * (float)(radialProg * (double)textScale);
                if (isSelectedIndex) {
                    entScale += 0.1f * bonusScale;
                }
                double angle = Math.toRadians(90.0f + 360.0f * (float)i / (float)this.radialFavourites.size());
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)0.0, (double)(radialDist * (double)0.1f), (double)0.0);
                this.renderMorphEntity(living, centerX - Math.cos(angle) * radialDist * (double)0.775f, centerY - (double)((float)(Math.sin(angle) * radialDist * (double)0.775f)), zLevel + 50.0f, entScale);
                RenderSystem.popMatrix();
            }
            for (i = 0; i < this.radialFavourites.size(); ++i) {
                TranslationTextComponent text;
                variant = this.radialFavourites.get(i);
                state = this.morphStates.computeIfAbsent(variant, arg_0 -> HudHandler.lambda$drawRadial$5(variant, (PlayerEntity)player, arg_0));
                living = state.getEntityInstance(player.field_70170_p, (PlayerEntity)player);
                isSelectedIndex = this.isMouseOutsideRadialDeadZone(window) && i == MouseHelper.getSelectedIndex((int)this.radialFavourites.size());
                double angle = Math.toRadians(90.0f + 360.0f * (float)i / (float)this.radialFavourites.size());
                EntityType value = (EntityType)ForgeRegistries.ENTITIES.getValue(variant.id);
                if (value != null) {
                    if (!living.func_200200_C_().equals(value.func_212546_e())) {
                        text = living.func_200200_C_().func_230532_e_();
                        text.func_230530_a_(text.func_150256_b().func_240722_b_(Boolean.valueOf(true)));
                    } else {
                        text = new TranslationTextComponent(value.func_210760_d());
                    }
                } else {
                    text = new TranslationTextComponent("morph.morph.type.unknown");
                }
                if (variant.thisVariant.identifier.equals(currentMorph.thisVariant.identifier)) {
                    text.func_230530_a_(text.func_150256_b().func_240712_a_(TextFormatting.GOLD));
                } else if (isSelectedIndex) {
                    text.func_230530_a_(text.func_150256_b().func_240712_a_(TextFormatting.YELLOW));
                } else {
                    text.func_230530_a_(text.func_150256_b().func_240712_a_(TextFormatting.WHITE));
                }
                float scale = 0.5f * (float)(radialProg * (double)textScale);
                stack.func_227860_a_();
                this.mc.field_71466_p.getClass();
                stack.func_227861_a_(0.0, radialDist * (double)0.1f + (double)(9.0f / 1.75f * textScale), 300.0);
                stack.func_227862_a_(scale, scale, 1.0f);
                this.mc.field_71466_p.func_243246_a(stack, (ITextComponent)text, (float)(-(Math.cos(angle) * radialDist * (double)0.775f) / (double)scale - (double)((float)this.mc.field_71466_p.func_238414_a_((ITextProperties)text) / 2.0f)), (float)(-Math.sin(angle) * radialDist * (double)0.775f / (double)scale), 0xFFFFFF);
                stack.func_227865_b_();
            }
        }
        stack.func_227865_b_();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
    }

    private void renderMorphEntity(LivingEntity livingEntity, double x, double y, double z, float scale) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableRescaleNormal();
        net.minecraft.client.renderer.RenderHelper.func_227781_a_((Matrix4f)LIGHT_STACK.func_227866_c_().func_227870_a_());
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)z);
        RenderSystem.rotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        InventoryScreen.func_228187_a_((int)0, (int)0, (int)35, (float)-60.0f, (float)0.0f, (LivingEntity)livingEntity);
        RenderSystem.popMatrix();
        net.minecraft.client.renderer.RenderHelper.func_227784_d_();
        RenderSystem.disableRescaleNormal();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
    }

    public void preDrawBiomassBar(MatrixStack stack, float partialTick) {
        if (!this.barRequiresReset && (this.barShowTime > 0 || this.shouldShowBiomassBar())) {
            this.barRequiresReset = true;
            stack.func_227860_a_();
            int scaledWidth = this.mc.func_228018_at_().func_198107_o();
            int scaledHeight = this.mc.func_228018_at_().func_198087_p();
            float prog = EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(((float)this.barShowTime + (this.shouldShowBiomassBar() ? partialTick : -partialTick)) / 8.0f), (float)0.0f, (float)1.0f));
            this.drawBiomassBar(stack, scaledWidth / 2 - 91, scaledHeight - 32 + 3, partialTick, prog);
        }
    }

    public void postDrawBiomassBar(MatrixStack stack, float partialTick) {
        if (this.barRequiresReset) {
            this.barRequiresReset = false;
            stack.func_227865_b_();
        }
    }

    public void drawBiomassBar(MatrixStack stack, int x, int y, float partialTick, float prog) {
        if (this.bindBiomassBarTexture()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            if (this.barInsufficientFlash > 0) {
                float flash = Math.abs((float)Math.cos(Math.toRadians(((float)this.barInsufficientFlash - partialTick) / 5.0f * 90.0f)));
                this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 0, 0.0f, 1.0f, 1.0f, flash, flash, prog);
            } else {
                float criticalRatio;
                double capacity = this.barCapacity.getDisplayValue(partialTick);
                double criticalCapacity = this.barCriticalCapacity.getDisplayValue(partialTick);
                double cost = this.barAbilityCost;
                double current = this.barCurrentBiomass.getDisplayValue(partialTick) - cost;
                double totalCapacity = capacity + criticalCapacity;
                float f = criticalRatio = criticalCapacity > 0.0 ? (float)(capacity / totalCapacity) : 1.0f;
                float currentRatio = current <= 0.0 ? 0.0f : (float)(current > totalCapacity ? 1.0 : current / totalCapacity);
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (currentRatio < criticalRatio) {
                    if (currentRatio > 0.0f) {
                        this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 5, 0.0f, currentRatio, r, g, b, prog);
                    }
                    this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 0, currentRatio, criticalRatio, r, g, b, prog);
                    if (criticalRatio < 1.0f) {
                        this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 0, criticalRatio, 1.0f, r, 0.0f, 0.0f, prog);
                    }
                    if (cost > 0.0) {
                        float costWidth;
                        float f2 = costWidth = totalCapacity <= 0.0 ? 0.0f : (float)(cost / totalCapacity);
                        if (current < 0.0) {
                            this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 5, currentRatio, Math.min(currentRatio + costWidth, 1.0f), r, 0.0f, 0.0f, (float)Math.abs(Math.sin(Math.toRadians(((float)iChunUtil.eventHandlerClient.ticks + partialTick) / 10.0f * 90.0f))));
                        } else {
                            this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 5, currentRatio, Math.min(currentRatio + costWidth, 1.0f), r, g, b, (float)Math.abs(Math.sin(Math.toRadians(((float)iChunUtil.eventHandlerClient.ticks + partialTick) / 10.0f * 90.0f))));
                        }
                    }
                } else {
                    this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 5, 0.0f, criticalRatio, r, g, b, prog);
                    this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 5, criticalRatio, currentRatio, r, 0.0f, 0.0f, prog);
                    this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 0, currentRatio, 1.0f, r, 0.0f, 0.0f, prog);
                    if (cost > 0.0) {
                        float costWidth = totalCapacity <= 0.0 ? 0.0f : (float)(cost / totalCapacity);
                        this.addBiomassBarVertex(bufferbuilder, matrix, x, y, 5, currentRatio, Math.min(currentRatio + costWidth, 1.0f), r, 0.0f, 0.0f, (float)Math.abs(Math.sin(Math.toRadians(((float)iChunUtil.eventHandlerClient.ticks + partialTick) / 10.0f * 90.0f))));
                    }
                }
            }
            tessellator.func_78381_a();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            stack.func_227861_a_(0.0, (double)(-6.0f * prog), 0.0);
        }
    }

    private void addBiomassBarVertex(BufferBuilder bufferbuilder, Matrix4f matrix, int x, int y, int heightOffset, float start, float end, float r, float g, float b, float a) {
        int z = -90;
        int barWidth = 182;
        int barHeight = 5;
        float x1 = (float)x + (float)barWidth * start;
        float x2 = (float)x + (float)barWidth * end;
        int y2 = y + barHeight;
        float uWidth = (float)barWidth / 256.0f;
        float u1 = uWidth * start;
        float u2 = uWidth * end;
        float v1 = (float)(64 + heightOffset) / 256.0f;
        float v2 = (float)(64 + heightOffset + barHeight) / 256.0f;
        bufferbuilder.func_227888_a_(matrix, x1, (float)y2, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, (float)y2, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x1, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_181675_d();
    }

    private boolean bindBiomassBarTexture() {
        if (barTexture == null && !barTextureGenerated) {
            barTextureGenerated = true;
            try (SimpleTexture.TextureData textureData = SimpleTexture.TextureData.func_217799_a((IResourceManager)this.mc.func_195551_G(), (ResourceLocation)AbstractGui.field_230665_h_);){
                textureData.func_217801_c();
                NativeImage image = textureData.func_217800_b();
                for (int x = 0; x < image.func_195702_a(); ++x) {
                    for (int y = 0; y < image.func_195714_b(); ++y) {
                        int clr = image.func_195709_a(x, y);
                        if ((clr >> 24 & 0xFF) <= 0) continue;
                        float[] hsb = Color.RGBtoHSB(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF, null);
                        hsb[1] = 0.0f;
                        image.func_195700_a(x, y, (clr >> 24 & 0xFF) << 24 | Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]) & 0xFFFFFF);
                    }
                }
                barTexture = new NativeImageTexture(image);
                this.mc.func_110434_K().func_229263_a_(barTexture.getResourceLocation(), (Texture)barTexture);
            }
            catch (IOException e) {
                Morph.LOGGER.error("Error creating Icon texture data!");
                e.printStackTrace();
            }
        }
        if (barTexture != null) {
            this.mc.func_110434_K().func_110577_a(barTexture.getResourceLocation());
            return true;
        }
        return false;
    }

    private boolean isMouseOutsideRadialDeadZone(MainWindow window) {
        double diameter = (double)Math.min(window.func_198107_o(), window.func_198087_p()) * Morph.configClient.radialScale;
        double deadZoneBorder = diameter / 2.0 * (double)0.55f;
        return MouseHelper.getMouseDistanceFromCenter((MainWindow)window) > deadZoneBorder;
    }

    private boolean shouldRenderSelector() {
        return this.showSelector || this.showTime > 0;
    }

    private boolean shouldShowBiomassBar() {
        return Morph.configClient.biomassBarMode == 1 && this.biomassBarRequiresUpdate() || Morph.configClient.biomassBarMode == 2;
    }

    private boolean biomassBarRequiresUpdate() {
        return this.barCapacity.requiresUpdate() || this.barCriticalCapacity.requiresUpdate() || this.barCurrentBiomass.requiresUpdate() || this.barAbilityCost > 0.0 || this.barInsufficientFlash > 0;
    }

    public void updateBiomass(PlayerMorphData morphData) {
        this.barCapacity.updateTarget(morphData.getBiomassUpgradeValue("biomass_capacity"));
        this.barCriticalCapacity.updateTarget(morphData.getBiomassUpgradeValue("biomass_critical_capacity"));
        this.barCurrentBiomass.updateTarget(morphData.biomass);
    }

    public void clean() {
        this.morphStates.clear();
    }

    public void destroy() {
    }

    private PlayerMorphData getMorphData() {
        return Morph.eventHandlerClient.morphData;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && (this.showSelector || this.showRadial) && this.mc.field_71462_r instanceof IngameMenuScreen) {
            this.mc.func_147108_a(null);
            if (this.showSelector) {
                this.closeSelector();
            } else {
                this.closeRadial();
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.mc.field_71439_g != null) {
            this.tick();
        }
    }

    @SubscribeEvent
    public void onIngameGuiPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.showRadial) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onIngameGuiPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (this.shouldRenderSelector()) {
                this.drawSelector(event.getMatrixStack(), event.getPartialTicks(), event.getWindow());
            }
            if (this.showRadial) {
                this.drawRadial(event.getMatrixStack(), event.getPartialTicks(), event.getWindow());
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            this.clean();
        }
    }

    @SubscribeEvent
    public void onRawMouseInput(InputEvent.RawMouseEvent event) {
        if (Morph.configClient.selectorAllowMouseControl && event.getAction() == 1) {
            if (this.showSelector) {
                event.setCanceled(true);
                if (event.getButton() == 0) {
                    this.confirmSelector();
                } else if (event.getButton() == 1) {
                    this.closeSelector();
                } else if (event.getButton() == 2) {
                    this.toggleFavourite();
                }
            } else if (this.showRadial) {
                event.setCanceled(true);
                if (event.getButton() == 0) {
                    this.confirmRadial();
                } else if (event.getButton() == 1 || event.getButton() == 2) {
                    this.closeRadial();
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        if (Morph.configClient.selectorAllowMouseControl && this.showSelector && event.getScrollDelta() != 0.0) {
            event.setCanceled(true);
            this.shiftIndexSelector(event.getScrollDelta() < 0.0, Screen.func_231173_s_());
        }
    }

    private static /* synthetic */ MorphState lambda$drawRadial$5(MorphVariant variant, PlayerEntity player, MorphVariant v) {
        return new MorphState(variant, player);
    }

    private static /* synthetic */ MorphState lambda$drawRadial$4(MorphVariant variant, PlayerEntity player, MorphVariant v) {
        return new MorphState(variant, player);
    }

    private static /* synthetic */ MorphState lambda$drawSelector$3(MorphVariant variant, PlayerEntity player, MorphVariant v) {
        return new MorphState(variant, player);
    }

    private static /* synthetic */ MorphState lambda$drawSelector$2(MorphVariant selectedVariant, PlayerEntity player, MorphVariant v) {
        return new MorphState(selectedVariant, player);
    }

    private static /* synthetic */ MorphState lambda$drawSelector$1(MorphVariant variant, PlayerEntity player, MorphVariant v) {
        return new MorphState(variant, player);
    }

    private static class BiomassValue {
        private double target;
        private double current;
        private double last;

        private BiomassValue(double value) {
            this.set(value);
        }

        private void set(double value) {
            this.current = this.last = value;
            this.target = this.last;
        }

        private void updateTarget(double value) {
            this.target = value;
        }

        private void tick() {
            this.last = this.current;
            if (this.current != this.target) {
                this.current = Math.abs(this.current - this.target) < (double)0.01f ? this.target : (this.current += (this.target - this.current) * (double)0.3f);
            }
        }

        private boolean requiresUpdate() {
            return this.current != this.target;
        }

        private double getDisplayValue(float partialTick) {
            return this.last + (this.current - this.last) * (double)partialTick;
        }
    }

    public static enum RadialMode {
        FAVOURITE,
        ABILITY;

    }
}

