/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.core;

import java.util.ArrayList;
import java.util.Collections;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.client.core.HudHandler;
import me.ichun.mods.morph.client.render.MorphRenderHandler;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.MorphInfoImpl;
import me.ichun.mods.morph.common.morph.save.PlayerMorphData;
import me.ichun.mods.morph.common.packet.PacketRequestMorphInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerClient {
    public PlayerMorphData morphData;
    public HudHandler hudHandler;

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        if (MorphRenderHandler.isRenderingMorph) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (Morph.configClient.morphDisableRidingPlayerRenderInFirstPerson && player.func_184187_bx() == Minecraft.func_71410_x().func_175606_aa() && Minecraft.func_71410_x().field_71474_y.func_243230_g().equals((Object)PointOfView.FIRST_PERSON)) {
            event.setCanceled(true);
            return;
        }
        MorphRenderHandler.restoreShadowSize(event.getRenderer());
        if (!player.field_70128_L) {
            MorphInfoImpl info = (MorphInfoImpl)MorphHandler.INSTANCE.getMorphInfo(player);
            if (!info.requested) {
                Morph.channel.sendToServer((AbstractPacket)new PacketRequestMorphInfo(player.func_146103_bH().getId()));
                info.requested = true;
            } else if (info.isMorphed()) {
                event.setCanceled(true);
                MorphRenderHandler.renderMorphInfo(player, info, event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getPartialRenderTick());
                MorphRenderHandler.setShadowSize(event.getRenderer(), info, event.getPartialRenderTick());
            }
        }
    }

    @SubscribeEvent
    public void onRenderNameplate(RenderNameplateEvent event) {
        if (MorphRenderHandler.denyRenderNameplate || event.getEntity().getPersistentData().func_74764_b("Morph_Player_ID") && !MorphRenderHandler.isRenderingMorph) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        MorphInfo info;
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.field_70128_L && (info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g)).isMorphed() && (info.getMorphProgress(event.renderTickTime) < 1.0f || Morph.configServer.aggressiveSizeRecalculation)) {
            Minecraft.func_71410_x().field_71439_g.field_213326_aJ = info.getMorphEyeHeight(event.renderTickTime);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70128_L && event.player == Minecraft.func_71410_x().field_71439_g && event.player.field_70173_aa == 10) {
            MorphInfo info = MorphHandler.INSTANCE.getMorphInfo(event.player);
            if (!info.requested) {
                Morph.channel.sendToServer((AbstractPacket)new PacketRequestMorphInfo(event.player.func_146103_bH().getId()));
                info.requested = true;
            }
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.setPlayerMorphData(null);
    }

    public void handleInput(KeyBind keyBind, boolean isReleased) {
        this.hudHandler.handleInput(keyBind, isReleased);
    }

    public void updateMorph(MorphVariant variant) {
        if (this.morphData != null) {
            boolean handled = false;
            ArrayList<MorphVariant> morphs = this.morphData.morphs;
            for (int i = 0; i < morphs.size(); ++i) {
                MorphVariant morph = morphs.get(i);
                if (!morph.id.equals((Object)variant.id)) continue;
                morphs.remove(i);
                if (variant.hasVariants()) {
                    morphs.add(i, variant);
                }
                handled = true;
                break;
            }
            if (!handled && variant.hasVariants()) {
                morphs.add(variant);
            }
            this.hudHandler.updateMorphs();
            Collections.sort(this.morphData.morphs);
        } else {
            Morph.LOGGER.error("We got morph data but we don't have the save data! Variant: {}", (Object)variant.id);
        }
    }

    public void setPlayerMorphData(PlayerMorphData playerMorphData) {
        this.morphData = playerMorphData;
        if (this.morphData == null) {
            if (this.hudHandler != null) {
                this.hudHandler.destroy();
                MinecraftForge.EVENT_BUS.unregister((Object)this.hudHandler);
                this.hudHandler = null;
            }
        } else {
            this.morphData.morphs.removeIf(morph -> !morph.hasVariants());
            Collections.sort(this.morphData.morphs);
            if (this.hudHandler == null) {
                this.hudHandler = new HudHandler(Minecraft.func_71410_x(), this.morphData);
                MinecraftForge.EVENT_BUS.register((Object)this.hudHandler);
            } else {
                this.hudHandler.updateBiomass(this.morphData);
                this.hudHandler.updateMorphs();
            }
        }
    }
}

