/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.config;

import java.io.IOException;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementPadding;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.morph.client.render.hand.HandHandler;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigClient
extends ConfigBase {
    @CategoryDivider(name="clientOnly")
    @Prop(min=0.0)
    public int selectorDistanceFromTop = 30;
    @Prop(min=0.0, max=30.0)
    public double selectorScale = 1.0;
    public boolean selectorAllowMouseControl = true;
    @Prop(min=0.0, max=1.0)
    public double radialScale = 0.75;
    @Prop(min=0.0, max=3.0)
    public int acquisitionPlayAnimation = 3;
    @Prop(min=3.0, max=100.0)
    public int acquisitionTendrilMaxChild = 10;
    @Prop(min=0.0, max=100.0)
    public int acquisitionTendrilPartOpacity = 5;
    public boolean morphAllowHandOverride = true;
    public boolean morphDisableRidingPlayerRenderInFirstPerson = true;
    @Prop(min=0.0, max=2.0)
    public int biomassBarMode = 1;
    @Prop(min=0.0, max=2.0, guiElementOverride="Morph:reloadResources")
    public int guiMinecraftStyle = 2;

    public ConfigClient() {
        super(ModLoadingContext.get().getActiveContainer().getModId() + "-client.toml");
    }

    public <T extends ConfigBase> T init() {
        GUI_ELEMENT_OVERRIDES.put("Morph:reloadResources", (value, itemOri) -> {
            ElementList.Item item = ((ElementList)itemOri.parentFragment).addItem(value).setBorderSize(0);
            item.setSelectionHandler(itemObj -> {
                if (itemObj.selected) {
                    for (Element element : itemObj.elements) {
                        if (element instanceof ElementTextWrapper || element instanceof ElementPadding) continue;
                        element.parentFragment.func_231035_a_((IGuiEventListener)element);
                        element.func_231044_a_((double)element.getLeft() + (double)element.getWidth() / 2.0, (double)element.getTop() + (double)element.getHeight() / 2.0, 0);
                        element.func_231048_c_((double)element.getLeft() + (double)element.getWidth() / 2.0, (double)element.getTop() + (double)element.getHeight() / 2.0, 0);
                        break;
                    }
                }
            });
            ElementTextWrapper wrapper = new ElementTextWrapper((Fragment)item).setText(I18n.func_135052_a((String)"config.morph.resources.reload.desc", (Object[])new Object[0]));
            wrapper.setConstraint(new Constraint((IConstrained)wrapper).left((IConstrainable)item, Constraint.Property.Type.LEFT, 3).right((IConstrainable)item, Constraint.Property.Type.RIGHT, 90));
            wrapper.setTooltip(value.desc);
            item.addElement((Element)wrapper);
            ElementPadding padding = new ElementPadding((Fragment)item, 0, 20);
            padding.setConstraint(new Constraint((IConstrained)padding).right((IConstrainable)item, Constraint.Property.Type.RIGHT, 0));
            item.addElement((Element)padding);
            ElementButton button = new ElementButton((Fragment)item, "config.morph.resources.reload.btn", btn -> {
                ResourceHandler.reloadAllResources();
                WindowPopup.popup((Workspace)item.getWorkspace(), (double)0.6, (double)0.6, null, (String[])new String[]{I18n.func_135052_a((String)"config.morph.resources.reload.success", (Object[])new Object[0])});
            });
            button.setTooltip(I18n.func_135052_a((String)"config.morph.resources.reload.reextract.desc", (Object[])new Object[0]));
            button.setSize(80, 14);
            button.setConstraint(new Constraint((IConstrained)button).top((IConstrainable)item, Constraint.Property.Type.TOP, 3).bottom((IConstrainable)item, Constraint.Property.Type.BOTTOM, 3).right((IConstrainable)item, Constraint.Property.Type.RIGHT, 8));
            item.addElement((Element)button);
            ElementButton button1 = new ElementButton((Fragment)item, "config.morph.resources.reload.reextract", btn -> {
                try {
                    ResourceHandler.extractFiles(ResourceHandler.getMorphDir().resolve("2.extracted"));
                    ResourceHandler.reloadAllResources();
                    WindowPopup.popup((Workspace)item.getWorkspace(), (double)0.6, (double)0.6, null, (String[])new String[]{I18n.func_135052_a((String)"config.morph.resources.reload.success", (Object[])new Object[0])});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            button1.setTooltip(I18n.func_135052_a((String)"config.morph.resources.reload.reextract.desc", (Object[])new Object[0]));
            button1.setSize(80, 14);
            button1.setConstraint(new Constraint((IConstrained)button1).top((IConstrainable)item, Constraint.Property.Type.TOP, 3).bottom((IConstrainable)item, Constraint.Property.Type.BOTTOM, 3).right((IConstrainable)button, Constraint.Property.Type.LEFT, 4));
            item.addElement((Element)button1);
            return false;
        });
        return (T)super.init();
    }

    public void onConfigLoaded() {
        HandHandler.setState(this.morphAllowHandOverride);
    }

    @Nonnull
    public String getModId() {
        return "morph";
    }

    @Nonnull
    public String getConfigName() {
        return "Morph";
    }

    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }
}

