/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.morph;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.morph.AttributeConfig;
import me.ichun.mods.morph.api.morph.MorphInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.RandomStringUtils;

public class MorphVariant
implements Comparable<MorphVariant> {
    public static final int IDENTIFIER_LENGTH = 20;
    public static final String IDENTIFIER_DEFAULT_PLAYER_STATE = "default_player_state";
    public static final String NBT_PLAYER_ID = "Morph_Player_ID";
    public static String[] TAGS_TO_TAKE = new String[]{"CustomName", "CustomNameVisible", "ForgeCaps", "ForgeData"};
    @Nonnull
    public ResourceLocation id;
    @Nonnull
    public CompoundNBT nbtMorph;
    public CompoundNBT nbtCommon;
    public ArrayList<Variant> variants;
    public Variant thisVariant;

    public MorphVariant(ResourceLocation id) {
        this.id = id;
        this.nbtMorph = new CompoundNBT();
        this.variants = new ArrayList();
    }

    private MorphVariant() {
        this.variants = new ArrayList();
    }

    public void setLiving(CompoundNBT tag) {
        this.nbtCommon = tag;
    }

    public void writeSupportedAttributes(LivingEntity living) {
        for (Map.Entry<ResourceLocation, AttributeConfig> e : MorphApi.getApiImpl().getSupportedAttributes().entrySet()) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(e.getKey());
            if (attribute == null || !living.func_233645_dx_().func_233790_b_(attribute)) continue;
            AttributeConfig attributeConfig = e.getValue();
            double value = living.func_233637_b_(attribute);
            if (attributeConfig.moreIsBetter) {
                if (attributeConfig.cap != null && value > attributeConfig.cap) {
                    value = attributeConfig.cap;
                }
            } else if (attributeConfig.cap != null && value < attributeConfig.cap) {
                value = attributeConfig.cap;
            }
            this.nbtMorph.func_74780_a("attr_" + e.getKey().toString(), value);
        }
    }

    public static void writeDefaults(LivingEntity living, CompoundNBT tag) {
        CompoundNBT defs = new CompoundNBT();
        living.func_189511_e(defs);
        for (String s : TAGS_TO_TAKE) {
            if (!defs.field_74784_a.containsKey(s)) continue;
            tag.field_74784_a.put(s, defs.field_74784_a.get(s));
        }
    }

    public boolean hasVariants() {
        return !this.variants.isEmpty();
    }

    public boolean combineVariants(MorphVariant variant) {
        if (!this.isSameMorphType(variant)) {
            return false;
        }
        if (this.id.equals((Object)EntityType.field_200729_aH.getRegistryName())) {
            this.variants.add(variant.thisVariant);
            return true;
        }
        this.addBetterMorphData(variant.nbtMorph);
        CompoundNBT variantTag = variant.getCumulativeTags();
        HashSet uncommons = new HashSet();
        for (Map.Entry e : this.nbtCommon.field_74784_a.entrySet()) {
            INBT varNBT = (INBT)variantTag.field_74784_a.get(e.getKey());
            if (varNBT == null || !varNBT.equals(e.getValue())) {
                uncommons.add(e.getKey());
                continue;
            }
            variantTag.field_74784_a.remove(e.getKey());
        }
        for (String key : uncommons) {
            INBT nbt = this.nbtCommon.func_74781_a(key);
            for (Variant aVariant : this.variants) {
                aVariant.nbtVariant.field_74784_a.put(key, nbt.func_74737_b());
            }
            this.nbtCommon.func_82580_o(key);
        }
        variant.thisVariant.nbtVariant = variantTag;
        this.variants.add(variant.thisVariant);
        this.gatherNewCommons();
        return true;
    }

    public boolean removeVariant(Variant variant) {
        boolean flag = false;
        for (int i = this.variants.size() - 1; i >= 0; --i) {
            if (!this.variants.get((int)i).identifier.equals(variant.identifier)) continue;
            this.variants.remove(i);
            flag = true;
        }
        if (flag && !this.id.equals((Object)EntityType.field_200729_aH.getRegistryName())) {
            if (this.variants.size() >= 2) {
                this.gatherNewCommons();
            } else if (!this.variants.isEmpty()) {
                this.variants.get((int)0).nbtVariant.field_74784_a.putAll(this.nbtCommon.field_74784_a);
                this.nbtCommon.field_74784_a.clear();
            } else {
                this.nbtCommon.field_74784_a.clear();
            }
        }
        return flag;
    }

    public Variant getVariantById(String id) {
        for (Variant variant : this.variants) {
            if (!variant.identifier.equals(id)) continue;
            return variant;
        }
        if (this.thisVariant != null && this.thisVariant.identifier.equals(id)) {
            return this.thisVariant;
        }
        return null;
    }

    public void gatherNewCommons() {
        HashMap commons = new HashMap();
        for (Variant variant : this.variants) {
            commons.putAll(variant.nbtVariant.field_74784_a);
        }
        commons.entrySet().removeIf(e -> {
            for (Variant variant : this.variants) {
                if (variant.nbtVariant.field_74784_a.containsKey(e.getKey()) && ((INBT)e.getValue()).equals(variant.nbtVariant.field_74784_a.get(e.getKey()))) continue;
                return true;
            }
            return false;
        });
        this.nbtCommon.field_74784_a.putAll(commons);
        for (String s : commons.keySet()) {
            for (Variant variant : this.variants) {
                variant.nbtVariant.field_74784_a.remove(s);
            }
        }
    }

    public boolean containsVariant(MorphVariant variant) {
        block3: {
            block2: {
                if (!this.id.equals((Object)EntityType.field_200729_aH.getRegistryName())) break block2;
                for (Variant aVariant : this.variants) {
                    if (!aVariant.playerUUID.equals(variant.thisVariant.playerUUID)) continue;
                    return true;
                }
                break block3;
            }
            if (variant.id.equals((Object)EntityType.field_200729_aH.getRegistryName())) break block3;
            CompoundNBT variantTags = variant.getCumulativeTags();
            for (Variant aVariant : this.variants) {
                CompoundNBT aVariantTags = this.getCumulativeTagsWithVariant(aVariant);
                if (!variantTags.equals((Object)aVariantTags)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSameMorphType(MorphVariant variant) {
        return this.id.equals((Object)variant.id);
    }

    private boolean addBetterMorphData(CompoundNBT tag) {
        boolean flag = false;
        Map<ResourceLocation, AttributeConfig> supportedAttributes = MorphApi.getApiImpl().getSupportedAttributes();
        for (Map.Entry e : this.nbtMorph.field_74784_a.entrySet()) {
            ResourceLocation id;
            String key = (String)e.getKey();
            if (!key.startsWith("attr_") || !supportedAttributes.containsKey(id = new ResourceLocation(key.substring(5)))) continue;
            AttributeConfig attributeConfig = supportedAttributes.get(id);
            double value = tag.func_74769_h(key);
            if (attributeConfig.moreIsBetter) {
                if (!(this.nbtMorph.func_74769_h(key) < value)) continue;
                this.nbtMorph.func_74780_a(key, value);
                if (attributeConfig.cap != null && value > attributeConfig.cap) {
                    this.nbtMorph.func_74780_a(key, attributeConfig.cap.doubleValue());
                }
                flag = true;
                continue;
            }
            if (!(this.nbtMorph.func_74769_h(key) > value)) continue;
            this.nbtMorph.func_74780_a(key, value);
            if (attributeConfig.cap != null && value < attributeConfig.cap) {
                this.nbtMorph.func_74780_a(key, attributeConfig.cap.doubleValue());
            }
            flag = true;
        }
        for (Map.Entry e : tag.field_74784_a.entrySet()) {
            if (!((String)e.getKey()).startsWith("attr_") || this.nbtMorph.func_74764_b((String)e.getKey())) continue;
            this.nbtMorph.field_74784_a.put(e.getKey(), e.getValue());
            flag = true;
        }
        return flag;
    }

    public boolean hasFavourite() {
        for (Variant variant : this.variants) {
            if (!variant.isFavourite) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    @Deprecated
    public LivingEntity createEntityInstance(World world, @Nullable UUID playerId) {
        return this.createEntityInstance(world, playerId != null ? world.func_217371_b(playerId) : null);
    }

    @Nonnull
    public LivingEntity createEntityInstance(World world, @Nullable PlayerEntity player) {
        LivingEntity entInstance = null;
        EntityType value = (EntityType)ForgeRegistries.ENTITIES.getValue(this.id);
        if (value != null) {
            try {
                if (value.equals(EntityType.field_200729_aH)) {
                    Object object = entInstance = world.field_72995_K ? this.createPlayer(world, this.thisVariant.playerUUID) : new FakePlayer((ServerWorld)world, MorphApi.getApiImpl().getGameProfile(this.thisVariant.playerUUID, null));
                    if (player != null) {
                        entInstance.getPersistentData().field_74784_a.putAll(player.getPersistentData().field_74784_a);
                    }
                    for (BiConsumer<LivingEntity, CompoundNBT> consumer : MorphApi.getApiImpl().getVariantNbtTagReaders()) {
                        consumer.accept(entInstance, entInstance.getPersistentData());
                    }
                } else {
                    CompoundNBT tags = this.getCumulativeTags();
                    Entity ent = value.func_200721_a(world);
                    if (ent instanceof LivingEntity) {
                        ent.func_70020_e(tags);
                        entInstance = (LivingEntity)ent;
                        for (BiConsumer<LivingEntity, CompoundNBT> consumer : MorphApi.getApiImpl().getVariantNbtTagReaders()) {
                            consumer.accept(entInstance, tags);
                        }
                    }
                }
            }
            catch (Throwable t) {
                MorphApi.getLogger().error("Error creating Morph entity for ID: {}", (Object)this.id);
                t.printStackTrace();
            }
        }
        if (entInstance == null) {
            MorphApi.getLogger().error("Cannot find entity type {} have a pig instead!", (Object)this.id);
            entInstance = (LivingEntity)EntityType.field_200784_X.func_200721_a(world);
            entInstance.func_200203_b((ITextComponent)new StringTextComponent("Invalid Morph Pig"));
        }
        entInstance.func_145769_d(MorphInfo.getNextEntId());
        if (player != null) {
            entInstance.getPersistentData().func_186854_a(NBT_PLAYER_ID, player.func_146103_bH().getId());
        }
        return entInstance;
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayerEntity createPlayer(World world, UUID uuid) {
        Minecraft mc = Minecraft.func_71410_x();
        final GameProfile gameProfile = MorphApi.getApiImpl().getGameProfile(uuid, null);
        boolean added = false;
        if (mc.func_147114_u().func_175102_a(gameProfile.getId()) == null) {
            SPlayerListItemPacket spoof = new SPlayerListItemPacket(){

                public List<SPlayerListItemPacket.AddPlayerData> func_179767_a() {
                    return Lists.newArrayList((Object[])new SPlayerListItemPacket.AddPlayerData[]{new SPlayerListItemPacket.AddPlayerData((SPlayerListItemPacket)this, gameProfile, -100, GameType.ADVENTURE, (ITextComponent)new StringTextComponent(gameProfile.getName()))});
                }
            };
            NetworkPlayerInfo info = new NetworkPlayerInfo((SPlayerListItemPacket.AddPlayerData)spoof.func_179767_a().get(0));
            mc.func_147114_u().field_147310_i.put(gameProfile.getId(), info);
            added = true;
        }
        RemoteClientPlayerEntity player = new RemoteClientPlayerEntity((ClientWorld)world, gameProfile);
        player.func_184212_Q().func_187227_b(PlayerEntity.field_184827_bp, (Object)127);
        player.func_184833_s();
        if (added) {
            mc.func_147114_u().field_147310_i.remove(gameProfile.getId());
        }
        return player;
    }

    public MorphVariant getAsVariant(Variant variant) {
        MorphVariant morph = MorphVariant.createFromNBT(this.write(new CompoundNBT()));
        morph.variants.clear();
        morph.thisVariant = variant;
        return morph;
    }

    public CompoundNBT getCumulativeTags() {
        return this.getCumulativeTagsWithVariant(this.thisVariant);
    }

    public CompoundNBT getCumulativeTagsWithVariant(Variant variant) {
        CompoundNBT tags = new CompoundNBT();
        tags.field_74784_a.putAll(this.nbtCommon.field_74784_a);
        tags.field_74784_a.putAll(variant.nbtVariant.field_74784_a);
        return tags;
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("id", this.id.toString());
        tag.func_218657_a("nbtMorph", (INBT)this.nbtMorph);
        if (!this.id.equals((Object)EntityType.field_200729_aH.getRegistryName())) {
            tag.func_218657_a("nbtCommon", (INBT)this.nbtCommon);
        }
        tag.func_74768_a("variantCount", this.variants.size());
        for (int i = 0; i < this.variants.size(); ++i) {
            tag.func_218657_a("variant_" + i, (INBT)this.variants.get(i).write(new CompoundNBT()));
        }
        if (this.thisVariant != null) {
            tag.func_218657_a("thisVariant", (INBT)this.thisVariant.write(new CompoundNBT()));
        }
        return tag;
    }

    public void read(CompoundNBT tag) {
        this.id = new ResourceLocation(tag.func_74779_i("id"));
        this.nbtMorph = tag.func_74775_l("nbtMorph");
        if (!this.id.equals((Object)EntityType.field_200729_aH.getRegistryName())) {
            this.nbtCommon = tag.func_74775_l("nbtCommon");
        }
        this.variants.clear();
        int count = tag.func_74762_e("variantCount");
        for (int i = 0; i < count; ++i) {
            Variant variant = new Variant();
            variant.read(tag.func_74775_l("variant_" + i));
            this.variants.add(variant);
        }
        if (tag.func_74764_b("thisVariant")) {
            Variant variant = new Variant();
            variant.read(tag.func_74775_l("thisVariant"));
            this.thisVariant = variant;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MorphVariant) {
            MorphVariant variant = (MorphVariant)obj;
            if (this.id.equals((Object)variant.id) && this.thisVariant != null && variant.thisVariant != null) {
                if (this.id.equals((Object)EntityType.field_200729_aH.getRegistryName())) {
                    return this.thisVariant.playerUUID.equals(variant.thisVariant.playerUUID);
                }
                return this.getCumulativeTags().equals((Object)variant.getCumulativeTags());
            }
        }
        return false;
    }

    @Override
    public int compareTo(MorphVariant o) {
        if (this.id.equals((Object)EntityType.field_200729_aH.getRegistryName()) && !this.id.equals((Object)o.id)) {
            return -1;
        }
        if (o.id.equals((Object)EntityType.field_200729_aH.getRegistryName()) && !this.id.equals((Object)o.id)) {
            return 1;
        }
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(this.id);
        EntityType otherType = (EntityType)ForgeRegistries.ENTITIES.getValue(o.id);
        if (type != null) {
            if (otherType != null) {
                if (EffectiveSide.get().isClient()) {
                    return I18n.func_135052_a((String)type.func_210760_d(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)otherType.func_210760_d(), (Object[])new Object[0]));
                }
                return type.func_210760_d().compareTo(otherType.func_210760_d());
            }
            return -1;
        }
        if (otherType == null) {
            return 0;
        }
        return 1;
    }

    public static MorphVariant createFromNBT(CompoundNBT tag) {
        MorphVariant variant = new MorphVariant();
        variant.read(tag);
        return variant;
    }

    public static MorphVariant createPlayerMorph(@Nonnull UUID owner, boolean isVariant) {
        MorphVariant variant = new MorphVariant(EntityType.field_200729_aH.getRegistryName());
        Variant var = new Variant();
        var.playerUUID = owner;
        if (isVariant) {
            variant.thisVariant = var;
        } else {
            variant.variants.add(var);
        }
        return variant;
    }

    public int hashCode() {
        return this.thisVariant != null ? this.thisVariant.hashCode() : super.hashCode();
    }

    public static class Variant {
        public String identifier = RandomStringUtils.randomAscii((int)20);
        public UUID playerUUID;
        public CompoundNBT nbtVariant = new CompoundNBT();
        public boolean isFavourite = false;

        public CompoundNBT write(CompoundNBT tag) {
            tag.func_74778_a("identifier", this.identifier);
            if (this.playerUUID != null) {
                tag.func_186854_a("playerUUID", this.playerUUID);
            } else {
                tag.func_218657_a("nbtVariant", (INBT)this.nbtVariant);
            }
            tag.func_74757_a("isFavourite", this.isFavourite);
            return tag;
        }

        public void read(CompoundNBT tag) {
            this.identifier = tag.func_74779_i("identifier");
            if (tag.func_74764_b("playerUUID")) {
                this.playerUUID = tag.func_186857_a("playerUUID");
            } else {
                this.nbtVariant = tag.func_74775_l("nbtVariant");
            }
            this.isFavourite = tag.func_74767_n("isFavourite");
        }

        public boolean equals(Object obj) {
            if (obj instanceof Variant) {
                return this.playerUUID != null ? this.playerUUID.equals(((Variant)obj).playerUUID) : this.nbtVariant.equals((Object)((Variant)obj).nbtVariant);
            }
            return false;
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }
    }
}

