/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.morph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.morph.MorphVariant;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MorphState
implements Comparable<MorphState> {
    public MorphVariant variant;
    private LivingEntity entInstance;
    private final Collection<ItemEntity> entInstanceDropCapture = new ArrayList<ItemEntity>();
    public float renderedShadowSize;
    public ArrayList<Trait<?>> traits = new ArrayList();

    private MorphState() {
    }

    public MorphState(MorphVariant variant, PlayerEntity player) {
        this.variant = variant;
        this.traits = MorphApi.getApiImpl().getTraitsForVariant(variant, player);
    }

    public void activateHooks() {
        for (Trait<?> trait : this.traits) {
            trait.addHooks();
        }
    }

    public void deactivateHooks() {
        for (Trait<?> trait : this.traits) {
            trait.removeHooks();
        }
    }

    public void tick(PlayerEntity player, boolean resetInventory) {
        LivingEntity livingInstance = this.getEntityInstance(player.field_70170_p, player);
        livingInstance.captureDrops(this.entInstanceDropCapture);
        this.entInstanceDropCapture.clear();
        MorphState.syncEntityPosRotWithPlayer(livingInstance, player);
        MorphState.syncInventory(livingInstance, player, true);
        if (livingInstance.canUpdate()) {
            livingInstance.func_70071_h_();
        }
        MorphState.syncEntityWithPlayer(livingInstance, player);
        if (!resetInventory) {
            MorphState.syncInventory(livingInstance, player, false);
        }
        livingInstance.func_184212_Q().func_187230_e();
    }

    public void tickTraits() {
        for (Trait<?> trait : this.traits) {
            trait.doTick(1.0f);
        }
    }

    @Nonnull
    @Deprecated
    public LivingEntity getEntityInstance(World world, @Nullable UUID playerId) {
        return this.getEntityInstance(world, playerId != null ? world.func_217371_b(playerId) : null);
    }

    @Nonnull
    public LivingEntity getEntityInstance(World world, @Nullable PlayerEntity player) {
        if (this.entInstance == null || this.entInstance.field_70170_p != world) {
            this.entInstance = this.variant.createEntityInstance(world, player);
            for (Trait<?> trait : this.traits) {
                trait.livingInstance = this.entInstance;
            }
        }
        return this.entInstance;
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_218657_a("variant", (INBT)this.variant.write(new CompoundNBT()));
        return tag;
    }

    public void read(CompoundNBT tag) {
        this.variant = MorphVariant.createFromNBT(tag.func_74775_l("variant"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof MorphState) {
            MorphState state = (MorphState)obj;
            return Objects.equals(this.variant, state.variant);
        }
        return false;
    }

    @Override
    public int compareTo(MorphState o) {
        return this.variant.compareTo(o.variant);
    }

    public static MorphState createFromNbt(CompoundNBT tag) {
        MorphState state = new MorphState();
        state.read(tag);
        return state;
    }

    public static void syncEntityPosRotWithPlayer(LivingEntity living, PlayerEntity player) {
        living.field_70173_aa = player.field_70173_aa;
        living.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        living.field_70142_S = player.field_70142_S;
        living.field_70137_T = player.field_70137_T;
        living.field_70136_U = player.field_70136_U;
        living.field_70169_q = player.field_70169_q;
        living.field_70167_r = player.field_70167_r;
        living.field_70166_s = player.field_70166_s;
        living.field_70126_B = player.field_70126_B;
        living.field_70127_C = player.field_70127_C;
        living.field_70759_as = player.field_70759_as;
        living.field_70758_at = player.field_70758_at;
        living.field_70761_aq = player.field_70761_aq;
        living.field_70760_ar = player.field_70760_ar;
        living.func_193076_bZ().clear();
    }

    public static void syncEntityWithPlayer(LivingEntity living, PlayerEntity player) {
        MorphState.syncEntityPosRotWithPlayer(living, player);
        living.field_184619_aG = player.field_184619_aG;
        living.field_70721_aZ = player.field_70721_aZ;
        living.func_213317_d(player.func_213322_ci());
        living.field_70123_F = player.field_70123_F;
        living.field_70124_G = player.field_70124_G;
        living.func_230245_c_(player.func_233570_aj_());
        living.func_226284_e_(player.func_225608_bj_());
        living.func_204711_a(player.func_203007_ba());
        living.func_70031_b(player.func_70051_ag());
        living.func_70606_j(living.func_110138_aP() * (player.func_110143_aJ() / player.func_110138_aP()));
        living.field_70737_aN = player.field_70737_aN;
        living.field_70725_aQ = player.field_70725_aQ;
        living.field_110158_av = player.field_110158_av;
        living.field_82175_bq = player.field_82175_bq;
        living.field_184622_au = player.field_184622_au;
        living.field_70733_aJ = player.field_70733_aJ;
        living.field_70732_aI = player.field_70732_aI;
        living.field_184239_as = player.field_184239_as;
        Pose pose = living.func_213283_Z();
        living.func_213301_b(player.func_213283_Z());
        if (pose != living.func_213283_Z()) {
            living.func_213323_x_();
        }
        if (player.func_213374_dv().isPresent()) {
            living.func_213369_d((BlockPos)player.func_213374_dv().get());
        } else {
            living.func_213372_dw();
        }
        living.func_82142_c(player.func_82150_aj());
        living.func_184195_f(player.func_225510_bt_());
        living.func_241209_g_(player.func_223314_ad());
        living.func_193076_bZ().putAll(player.func_193076_bZ());
        MorphState.specialEntityPlayerSync(living, player);
    }

    public static void specialEntityPlayerSync(LivingEntity living, PlayerEntity player) {
        for (BiConsumer<LivingEntity, PlayerEntity> consumer : MorphApi.getApiImpl().getModPlayerMorphSyncConsumers()) {
            consumer.accept(living, player);
        }
    }

    public static void syncInventory(LivingEntity living, PlayerEntity player, boolean reset) {
        if (living instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)living;
            for (EquipmentSlotType value : EquipmentSlotType.values()) {
                ItemStack copy;
                boolean shouldReset = reset && (value == EquipmentSlotType.MAINHAND || value == EquipmentSlotType.OFFHAND);
                if (ItemStack.func_77989_b((ItemStack)living.func_184582_a(value), (ItemStack)(shouldReset ? ItemStack.field_190927_a : player.func_184582_a(value)))) continue;
                ItemStack itemStack = copy = shouldReset ? ItemStack.field_190927_a : player.func_184582_a(value).func_77946_l();
                if (value == EquipmentSlotType.MAINHAND) {
                    playerEntity.field_71071_by.field_70462_a.set(playerEntity.field_71071_by.field_70461_c, (Object)copy);
                    continue;
                }
                if (value == EquipmentSlotType.OFFHAND) {
                    playerEntity.field_71071_by.field_184439_c.set(0, (Object)copy);
                    continue;
                }
                if (value.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                playerEntity.field_71071_by.field_70460_b.set(value.func_188454_b(), (Object)copy);
            }
        } else {
            for (PlayerEntity value : EquipmentSlotType.values()) {
                boolean shouldReset = reset && (value == EquipmentSlotType.MAINHAND || value == EquipmentSlotType.OFFHAND);
                if (ItemStack.func_77989_b((ItemStack)living.func_184582_a((EquipmentSlotType)value), (ItemStack)(shouldReset ? ItemStack.field_190927_a : player.func_184582_a((EquipmentSlotType)value)))) continue;
                living.func_184201_a((EquipmentSlotType)value, shouldReset ? ItemStack.field_190927_a : player.func_184582_a((EquipmentSlotType)value).func_77946_l());
            }
        }
        if (player.func_184587_cr()) {
            if (player.func_184612_cw() == 1) {
                Hand hand = player.func_184600_cs();
                living.func_184598_c(hand);
                living.func_204802_c(1, true);
                living.func_204802_c(2, hand == Hand.OFF_HAND);
            }
        } else {
            living.func_204802_c(1, false);
            living.func_184602_cy();
        }
    }
}

