/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.morph;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.morph.MorphState;
import me.ichun.mods.morph.api.morph.MorphVariant;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public abstract class MorphInfo {
    @CapabilityInject(value=MorphInfo.class)
    public static Capability<MorphInfo> CAPABILITY_INSTANCE;
    public static final ResourceLocation CAPABILITY_IDENTIFIER;
    private static final AtomicInteger NEXT_ENTITY_ID;
    public final PlayerEntity player;
    @Nullable
    public MorphState prevState;
    @Nullable
    public MorphState nextState;
    public int morphTime;
    public int morphingTime;
    public boolean firstTick = true;
    public int playSoundTime = -1;
    public boolean requested;

    protected MorphInfo(PlayerEntity player) {
        this.player = player;
    }

    public abstract void tick();

    public boolean isMorphed() {
        return this.nextState != null;
    }

    public float getMorphProgress(float partialTick) {
        if (this.prevState == null || this.nextState == null || this.morphingTime <= 0) {
            return 1.0f;
        }
        return MathHelper.func_76131_a((float)(((float)this.morphTime + partialTick) / (float)this.morphingTime), (float)0.0f, (float)1.0f);
    }

    public float getTransitionProgressLinear(float partialTick) {
        float morphProgress = this.getMorphProgress(partialTick);
        return MathHelper.func_76131_a((float)((morphProgress - 0.125f) / 0.75f), (float)0.0f, (float)1.0f);
    }

    public float getTransitionProgressSine(float partialTick) {
        return MorphInfo.sineifyProgress(this.getTransitionProgressLinear(partialTick));
    }

    public EntitySize getActiveMorphSizeByPose(Pose pose) {
        return this.getActiveMorphEntity().func_213305_a(pose);
    }

    public EntitySize getMorphSize(float partialTick) {
        float morphProgress = this.getMorphProgress(partialTick);
        if (morphProgress < 1.0f) {
            float transitionProgress = this.getTransitionProgressSine(partialTick);
            if (transitionProgress <= 0.0f) {
                LivingEntity prevInstance = this.prevState.getEntityInstance(this.player.field_70170_p, this.player);
                prevInstance.func_213301_b(this.player.func_213283_Z());
                prevInstance.func_213323_x_();
                return prevInstance.field_213325_aI;
            }
            if (transitionProgress >= 1.0f) {
                LivingEntity nextInstance = this.nextState.getEntityInstance(this.player.field_70170_p, this.player);
                nextInstance.func_213301_b(this.player.func_213283_Z());
                nextInstance.func_213323_x_();
                return nextInstance.field_213325_aI;
            }
            LivingEntity prevInstance = this.prevState.getEntityInstance(this.player.field_70170_p, this.player);
            prevInstance.func_213301_b(this.player.func_213283_Z());
            prevInstance.func_213323_x_();
            LivingEntity nextInstance = this.nextState.getEntityInstance(this.player.field_70170_p, this.player);
            nextInstance.func_213301_b(this.player.func_213283_Z());
            nextInstance.func_213323_x_();
            EntitySize prevSize = prevInstance.field_213325_aI;
            EntitySize nextSize = nextInstance.field_213325_aI;
            return EntitySize.func_220314_b((float)(prevSize.field_220315_a + (nextSize.field_220315_a - prevSize.field_220315_a) * transitionProgress), (float)(prevSize.field_220316_b + (nextSize.field_220316_b - prevSize.field_220316_b) * transitionProgress));
        }
        LivingEntity nextInstance = this.nextState.getEntityInstance(this.player.field_70170_p, this.player);
        nextInstance.func_213301_b(this.player.func_213283_Z());
        nextInstance.func_213323_x_();
        return nextInstance.field_213325_aI;
    }

    public float getMorphEyeHeight(float partialTick) {
        float morphProgress = this.getMorphProgress(partialTick);
        if (morphProgress < 1.0f) {
            float transitionProgress = this.getTransitionProgressSine(partialTick);
            if (transitionProgress <= 0.0f) {
                return this.prevState.getEntityInstance(this.player.field_70170_p, this.player).func_70047_e();
            }
            if (transitionProgress >= 1.0f) {
                return this.nextState.getEntityInstance(this.player.field_70170_p, this.player).func_70047_e();
            }
            float prevHeight = this.prevState.getEntityInstance(this.player.field_70170_p, this.player).func_70047_e();
            float nextHeight = this.nextState.getEntityInstance(this.player.field_70170_p, this.player).func_70047_e();
            return prevHeight + (nextHeight - prevHeight) * transitionProgress;
        }
        return this.nextState.getEntityInstance(this.player.field_70170_p, this.player).func_70047_e();
    }

    protected void setPrevState(@Nullable MorphState state) {
        if (this.prevState != null) {
            this.prevState.deactivateHooks();
        }
        this.prevState = state;
        if (this.prevState != null) {
            this.prevState.activateHooks();
        }
    }

    protected void setNextState(@Nullable MorphState state) {
        if (this.nextState != null && this.nextState != this.prevState) {
            this.nextState.deactivateHooks();
        }
        this.nextState = state;
        if (this.nextState != null) {
            this.nextState.activateHooks();
        }
    }

    public void setNextState(MorphState state, int morphingTime) {
        if (state != null) {
            if (this.nextState != null) {
                this.setPrevState(this.nextState);
            } else {
                MorphVariant variant = MorphVariant.createPlayerMorph(this.player.func_146103_bH().getId(), true);
                variant.thisVariant.identifier = "default_player_state";
                this.setPrevState(new MorphState(variant, this.player));
            }
            this.morphTime = 0;
            this.morphingTime = morphingTime;
        } else {
            this.setPrevState(null);
            this.morphTime = 0;
            this.morphingTime = 0;
        }
        this.setNextState(state);
        this.playSoundTime = -1;
        this.player.func_213323_x_();
    }

    public boolean isCurrentlyThisVariant(@Nonnull MorphVariant.Variant variant) {
        return this.nextState != null && this.nextState.variant.thisVariant.identifier.equals(variant.identifier) || !this.isMorphed() && variant.identifier.equals("default_player_state");
    }

    public CompoundNBT write(CompoundNBT tag) {
        if (this.prevState != null) {
            tag.func_218657_a("prevState", (INBT)this.prevState.write(new CompoundNBT()));
        }
        if (this.nextState != null) {
            tag.func_218657_a("nextState", (INBT)this.nextState.write(new CompoundNBT()));
        }
        tag.func_74768_a("morphTime", this.morphTime);
        tag.func_74768_a("morphingTime", this.morphingTime);
        return tag;
    }

    public void read(CompoundNBT tag) {
        MorphState state;
        this.playSoundTime = -1;
        if (tag.func_74764_b("prevState")) {
            state = MorphState.createFromNbt(tag.func_74775_l("prevState"));
            state.traits = MorphApi.getApiImpl().getTraitsForVariant(state.variant, this.player);
            if (state.variant.thisVariant != null) {
                if (this.nextState != null && this.nextState.equals(state) && tag.func_74764_b("nextState")) {
                    this.setPrevState(this.nextState);
                } else {
                    this.setPrevState(state);
                }
            }
        } else {
            this.setPrevState(null);
        }
        if (tag.func_74764_b("nextState")) {
            state = MorphState.createFromNbt(tag.func_74775_l("nextState"));
            state.traits = MorphApi.getApiImpl().getTraitsForVariant(state.variant, this.player);
            this.setNextState(state);
            if (this.nextState.variant.thisVariant == null) {
                this.setPrevState(null);
                this.setNextState(null);
            }
        } else {
            this.setNextState(null);
        }
        this.morphTime = tag.func_74762_e("morphTime");
        this.morphingTime = tag.func_74762_e("morphingTime");
        this.player.func_213323_x_();
    }

    public LivingEntity getActiveMorphEntity() {
        if (this.getMorphProgress(1.0f) < 0.5f) {
            return this.prevState.getEntityInstance(this.player.field_70170_p, this.player);
        }
        if (this.nextState != null) {
            return this.nextState.getEntityInstance(this.player.field_70170_p, this.player);
        }
        return null;
    }

    protected LivingEntity getActiveMorphEntityOrPlayer() {
        LivingEntity activeMorph = this.getActiveMorphEntity();
        if (activeMorph == null) {
            activeMorph = this.player;
        }
        return activeMorph;
    }

    public LivingEntity getActiveAppearanceEntity(float partialTick) {
        if (this.getMorphProgress(partialTick) < 1.0f) {
            float transitionProg = this.getTransitionProgressLinear(partialTick);
            if (transitionProg <= 0.0f) {
                return this.prevState.getEntityInstance(this.player.field_70170_p, this.player);
            }
            if (transitionProg >= 1.0f) {
                return this.nextState.getEntityInstance(this.player.field_70170_p, this.player);
            }
            return null;
        }
        if (this.nextState != null) {
            return this.nextState.getEntityInstance(this.player.field_70170_p, this.player);
        }
        return this.player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMorphSkinAlpha(float partialTick) {
        return Math.max(this.getMorphingSkinAlpha(partialTick), this.getAbilitySkinAlpha(partialTick));
    }

    @OnlyIn(value=Dist.CLIENT)
    private float getMorphingSkinAlpha(float partialTick) {
        float morphProgress = this.getMorphProgress(partialTick);
        if (morphProgress < 1.0f) {
            float transitionProgress = this.getTransitionProgressSine(partialTick);
            if (transitionProgress <= 0.0f) {
                return MorphInfo.sineifyProgress(morphProgress / 0.125f);
            }
            if (transitionProgress >= 1.0f) {
                return 1.0f - MorphInfo.sineifyProgress((morphProgress - 0.875f) / 0.125f);
            }
            return 1.0f;
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected float getAbilitySkinAlpha(float partialTick) {
        return 0.0f;
    }

    public abstract void playStepSound(BlockPos var1, BlockState var2);

    public abstract void playSwimSound(float var1);

    public abstract float playFlySound(float var1);

    @Nullable
    public abstract SoundEvent getHurtSound(DamageSource var1);

    @Nullable
    public abstract SoundEvent getDeathSound();

    public abstract SoundEvent getFallSound(int var1);

    public abstract SoundEvent getDrinkSound(ItemStack var1);

    public abstract SoundEvent getEatSound(ItemStack var1);

    public abstract float getSoundVolume();

    public abstract float getSoundPitch();

    public static int getNextEntId() {
        return NEXT_ENTITY_ID.getAndDecrement();
    }

    public static float sineifyProgress(float progress) {
        return (float)Math.sin(Math.toRadians(-90.0f + 180.0f * progress)) / 2.0f + 0.5f;
    }

    static {
        CAPABILITY_IDENTIFIER = new ResourceLocation("morph", "capability_morph_state");
        NEXT_ENTITY_ID = new AtomicInteger(-70000000);
    }

    public static class CapProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final MorphInfo state;
        private final LazyOptional<MorphInfo> optional;

        public CapProvider(MorphInfo state) {
            this.state = state;
            this.optional = LazyOptional.of(() -> state);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CAPABILITY_INSTANCE) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return this.state.write(new CompoundNBT());
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.state.read(nbt);
        }
    }
}

