/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait.ability;

import me.ichun.mods.morph.api.mob.trait.ability.Ability;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class SlowFallAbility
extends Ability<SlowFallAbility> {
    public Double velocityMultiplier;
    public Boolean resetFallDistance;

    public SlowFallAbility() {
        this.type = "abilitySlowFall";
    }

    @Override
    public void addHooks() {
        if (this.velocityMultiplier == null) {
            this.velocityMultiplier = 0.6;
        }
    }

    @Override
    public void tick(float strength) {
        if (!this.player.func_225608_bj_()) {
            this.setMotion(this.velocityMultiplier, strength);
            if (this.resetFallDistance != null && this.resetFallDistance.booleanValue()) {
                this.setFallDistance(strength);
            }
        }
    }

    @Override
    public void transitionalTick(SlowFallAbility prevTrait, float transitionProgress) {
        if (!this.player.func_225608_bj_()) {
            double velo = MathHelper.func_219803_d((double)transitionProgress, (double)(prevTrait.velocityMultiplier != null ? prevTrait.velocityMultiplier : 0.6), (double)this.velocityMultiplier);
            this.setMotion(velo, 1.0f);
            if ((prevTrait.resetFallDistance == null || !prevTrait.resetFallDistance.booleanValue()) && this.resetFallDistance != null && this.resetFallDistance.booleanValue()) {
                this.setFallDistance(transitionProgress);
            } else if (prevTrait.resetFallDistance != null && prevTrait.resetFallDistance.booleanValue() && (this.resetFallDistance == null || !this.resetFallDistance.booleanValue())) {
                this.setFallDistance(1.0f - transitionProgress);
            } else if (prevTrait.resetFallDistance != null && prevTrait.resetFallDistance.booleanValue() && this.resetFallDistance != null && this.resetFallDistance.booleanValue()) {
                this.setFallDistance(1.0f);
            }
        }
    }

    private void setMotion(double veloMulti, float strength) {
        Vector3d motion = this.player.func_213322_ci();
        if (!this.player.func_233570_aj_() && motion.field_72448_b < 0.0) {
            this.player.func_213317_d(motion.func_216372_d(1.0, 1.0 + (veloMulti - 1.0) * (double)strength, 1.0));
        }
    }

    private void setFallDistance(float strength) {
        this.player.field_70143_R -= this.player.field_70143_R * strength;
    }

    @Override
    public SlowFallAbility copy() {
        SlowFallAbility ability = new SlowFallAbility();
        ability.velocityMultiplier = this.velocityMultiplier;
        ability.resetFallDistance = this.resetFallDistance;
        return ability;
    }
}

