/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait.ability;

import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.mob.trait.ability.Ability;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class FlightFlapAbility
extends Ability<FlightFlapAbility> {
    public Boolean resetVerticalVelocity;
    public Double velocityAdded;
    public Integer flapLimit;
    public Boolean slowdownInWater;
    public transient double flaps;
    public transient boolean keyHeld;
    public transient boolean wasOnGround;

    public FlightFlapAbility() {
        this.type = "abilityFlightFlap";
    }

    @Override
    public void addHooks() {
        super.addHooks();
        if (this.velocityAdded == null) {
            this.velocityAdded = 0.42;
        }
    }

    @Override
    public void tick(float strength) {
        this.combinedTick(strength, this.velocityAdded);
    }

    @Override
    public void transitionalTick(FlightFlapAbility prevTrait, float transitionProgress) {
        this.flaps = prevTrait.flaps;
        this.combinedTick(1.0f, MathHelper.func_219803_d((double)transitionProgress, (double)prevTrait.velocityAdded, (double)this.velocityAdded));
    }

    private void combinedTick(float strength, double velocityToAdd) {
        if (this.player.field_70170_p.field_72995_K) {
            this.clientTick(strength, velocityToAdd);
        } else {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            serverPlayer.field_71135_a.field_147365_f = 0;
        }
        if (this.slowdownInWater != null && this.slowdownInWater.booleanValue() && this.player.func_208600_a((ITag)FluidTags.field_206959_a)) {
            boolean hasSwim = false;
            for (Trait trait : this.stateTraits) {
                if (!"traitSwim".equals(trait.type)) continue;
                hasSwim = true;
                break;
            }
            if (!hasSwim) {
                this.player.func_213317_d(this.player.func_213322_ci().func_216372_d(1.0 + -0.35 * (double)strength, 1.0 + -0.8 * (double)strength, 1.0 + -0.35 * (double)strength));
            }
        }
        this.player.field_70143_R -= this.player.field_70143_R * strength;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick(float strength, double velocityToAdd) {
        if (!this.keyHeld && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
            boolean canFlap;
            boolean bl = canFlap = (this.flapLimit == null || this.flaps < (double)this.flapLimit.intValue()) && !this.wasOnGround;
            if (!this.player.field_71075_bZ.field_75100_b && canFlap) {
                double d7 = this.player.func_180799_ab() ? this.player.func_233571_b_((ITag)FluidTags.field_206960_b) : this.player.func_233571_b_((ITag)FluidTags.field_206959_a);
                boolean flag = this.player.func_70090_H() && d7 > 0.0;
                double d8 = this.player.func_233579_cu_();
                if (!flag || !(d7 > d8)) {
                    if (!this.player.func_180799_ab() || !(d7 > d8)) {
                        this.jump(strength, velocityToAdd);
                    } else {
                        this.player.func_213317_d(this.player.func_213322_ci().func_72441_c(0.0, (double)0.04f * this.player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), 0.0));
                    }
                } else {
                    this.player.func_213317_d(this.player.func_213322_ci().func_72441_c(0.0, (double)0.04f * this.player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), 0.0));
                }
            }
        }
        this.keyHeld = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        this.wasOnGround = this.player.func_233570_aj_();
        if (this.player.func_233570_aj_()) {
            this.flaps = 0.0;
        }
    }

    public void jump(float strength, double velocityToAdd) {
        double d = velocityToAdd * (double)this.getJumpFactor() * (double)strength;
        if (this.player.func_70644_a(Effects.field_76430_j)) {
            d += 0.1 * (double)(this.player.func_70660_b(Effects.field_76430_j).func_76458_c() + 1);
        }
        Vector3d motion = this.player.func_213322_ci();
        if (this.resetVerticalVelocity != null && this.resetVerticalVelocity.booleanValue()) {
            this.player.func_213293_j(motion.field_72450_a, d, motion.field_72449_c);
        } else {
            this.player.func_213317_d(motion.func_72441_c(0.0, d, 0.0));
        }
        this.player.field_70160_al = true;
    }

    public float getJumpFactor() {
        float f = this.player.field_70170_p.func_180495_p(this.player.func_233580_cy_()).func_177230_c().func_226892_n_();
        float f1 = this.player.field_70170_p.func_180495_p(new BlockPos(this.player.func_226277_ct_(), this.player.func_174813_aQ().field_72338_b - 0.5000001, this.player.func_226281_cx_())).func_177230_c().func_226892_n_();
        return (double)f == 1.0 ? f1 : f;
    }

    @Override
    public FlightFlapAbility copy() {
        FlightFlapAbility ability = new FlightFlapAbility();
        ability.resetVerticalVelocity = this.resetVerticalVelocity;
        ability.velocityAdded = this.velocityAdded;
        ability.flapLimit = this.flapLimit;
        ability.slowdownInWater = this.slowdownInWater;
        return ability;
    }
}

