/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait.ability;

import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.mob.trait.IEventBusRequired;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.mob.trait.ability.Ability;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectAttackAbility
extends Ability<EffectAttackAbility>
implements IEventBusRequired {
    public String effectId;
    public Integer duration;
    public Integer amplifier;
    public transient Effect effectObj;
    public transient float lastStrength = 0.0f;

    public EffectAttackAbility() {
        this.type = "abilityEffectAttack";
    }

    @Override
    public void addHooks() {
        ResourceLocation effectRL;
        Effect theEffect;
        if (this.effectId != null && (theEffect = (Effect)ForgeRegistries.POTIONS.getValue(effectRL = new ResourceLocation(this.effectId))) != null) {
            this.effectObj = theEffect;
            super.addHooks();
        }
    }

    @Override
    public void tick(float strength) {
        this.lastStrength = strength;
    }

    @Override
    public EffectAttackAbility copy() {
        EffectAttackAbility trait = new EffectAttackAbility();
        trait.effectId = this.effectId;
        return trait;
    }

    @Override
    public boolean canTransitionTo(Trait<?> trait) {
        if (trait instanceof EffectAttackAbility) {
            return this.effectId != null && this.effectId.equals(((EffectAttackAbility)trait).effectId);
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (this.lastStrength == 1.0f && event.getSource().func_76364_f() == this.player && MorphApi.getApiImpl().canUseAbility(this.player, this)) {
            event.getEntityLiving().func_195064_c(new EffectInstance(this.effectObj, this.duration != null ? this.duration : 200, this.amplifier != null ? this.amplifier : 0));
        }
    }
}

