/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.morph.api.mob.trait.IEventBusRequired;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class Trait<T extends Trait>
implements Comparable<T> {
    @Nonnull
    public String type;
    public String upgradeFor;
    public Double purchaseCost;
    public Boolean hidden;
    public transient PlayerEntity player;
    public transient ArrayList<Trait<?>> stateTraits;
    @Nullable
    public transient LivingEntity livingInstance;

    public void addHooks() {
        if (this instanceof IEventBusRequired) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void removeHooks() {
        if (this instanceof IEventBusRequired) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public abstract void tick(float var1);

    public void transitionalTick(T prevTrait, float transitionProgress) {
        this.tick(1.0f);
    }

    public void doTick(float strength) {
        this.tick(strength);
    }

    public void doTransitionalTick(T prevTrait, float transitionProgress) {
        this.transitionalTick(prevTrait, transitionProgress);
    }

    public boolean canTransitionTo(Trait<?> trait) {
        return this.getClass().equals(trait.getClass());
    }

    public abstract T copy();

    public String getTranslationKeyRoot() {
        return this.translationKeyRootOverride() == null ? "morph.trait." + this.type : this.translationKeyRootOverride();
    }

    private String translationKeyRootOverride() {
        return null;
    }

    public boolean isHidden() {
        return this.hidden != null && this.hidden != false;
    }

    public ResourceLocation texIcon() {
        return null;
    }

    public boolean isAbility() {
        return false;
    }

    @Override
    public int compareTo(T o) {
        if (!this.isAbility() && ((Trait)o).isAbility()) {
            return -1;
        }
        if (this.isAbility() && !((Trait)o).isAbility()) {
            return 1;
        }
        if (FMLEnvironment.dist.isClient()) {
            return this.compareTranslatedName(o);
        }
        return this.type.compareTo(((Trait)o).type);
    }

    @OnlyIn(value=Dist.CLIENT)
    private int compareTranslatedName(T o) {
        return I18n.func_135052_a((String)(this.getTranslationKeyRoot() + ".name"), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)(((Trait)o).getTranslationKeyRoot() + ".name"), (Object[])new Object[0]));
    }
}

