/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.UUID;
import me.ichun.mods.morph.api.mob.trait.IEventBusRequired;
import me.ichun.mods.morph.api.mob.trait.Trait;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SwimmerTrait
extends Trait<SwimmerTrait>
implements IEventBusRequired {
    public Float swimMultiplier;
    public Float landMultiplier;
    public Boolean doNotAffectFog;
    public transient float lastStrength = 0.0f;
    public transient Random rand = new Random();
    public transient float lastSwimMul = 1.0f;
    public transient boolean doNotRemoveAttribute;

    public SwimmerTrait() {
        this.type = "traitSwimmer";
    }

    @Override
    public void addHooks() {
        if (this.doNotAffectFog == null || !this.doNotAffectFog.booleanValue()) {
            super.addHooks();
        }
        if (this.swimMultiplier == null) {
            this.swimMultiplier = Float.valueOf(1.0f);
        }
        if (this.landMultiplier == null) {
            this.landMultiplier = Float.valueOf(1.0f);
        }
    }

    @Override
    public void removeHooks() {
        super.removeHooks();
        if (!this.doNotRemoveAttribute) {
            this.setSwimAttribute(1.0f);
        }
    }

    @Override
    public void tick(float strength) {
        this.lastStrength = strength;
        if (this.swimMultiplier.floatValue() != 0.0f && this.player.func_203005_aq()) {
            this.setSwimAttribute(1.0f + (this.swimMultiplier.floatValue() - 1.0f) * strength);
        }
        if (this.landMultiplier.floatValue() != 0.0f && !this.player.func_203005_aq() && this.player.func_233570_aj_()) {
            this.multiplyMotion(1.0f + (this.landMultiplier.floatValue() - 1.0f) * strength);
        }
    }

    @Override
    public void transitionalTick(SwimmerTrait prevTrait, float transitionProgress) {
        float landMul;
        prevTrait.doNotRemoveAttribute = true;
        float swimMul = MathHelper.func_219799_g((float)transitionProgress, (float)prevTrait.swimMultiplier.floatValue(), (float)this.swimMultiplier.floatValue());
        if (swimMul != 0.0f && this.player.func_203005_aq()) {
            this.setSwimAttribute(swimMul);
        }
        if ((landMul = MathHelper.func_219799_g((float)transitionProgress, (float)prevTrait.landMultiplier.floatValue(), (float)this.landMultiplier.floatValue())) != 0.0f && !this.player.func_203005_aq() && this.player.func_233570_aj_()) {
            this.multiplyMotion(landMul);
        }
    }

    public void setSwimAttribute(float mul) {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        ModifiableAttributeInstance playerAttribute = this.player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
        if (playerAttribute != null && this.lastSwimMul != mul) {
            this.lastSwimMul = mul;
            this.rand.setSeed(Math.abs("MorphAttr".hashCode() * 1231543 + "traitSwimmer".hashCode() * 268));
            UUID uuid = MathHelper.func_180182_a((Random)this.rand);
            playerAttribute.func_233770_c_(uuid);
            if (mul != 1.0f) {
                playerAttribute.func_233769_c_(new AttributeModifier(uuid, "MorphAttributeModifier:traitSwimmer", (double)mul, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    public void multiplyMotion(float mul) {
        this.player.func_213317_d(this.player.func_213322_ci().func_216372_d((double)mul, (double)mul, (double)mul));
    }

    @Override
    public boolean canTransitionTo(Trait<?> trait) {
        if (trait instanceof SwimmerTrait) {
            return this.doNotAffectFog == ((SwimmerTrait)trait).doNotAffectFog;
        }
        return false;
    }

    @Override
    public SwimmerTrait copy() {
        SwimmerTrait trait = new SwimmerTrait();
        trait.swimMultiplier = this.swimMultiplier;
        trait.landMultiplier = this.landMultiplier;
        trait.doNotAffectFog = this.doNotAffectFog;
        return trait;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.getInfo().func_216773_g() == this.player) {
            FluidState fluidstate = event.getInfo().func_216771_k();
            Entity entity = event.getInfo().func_216773_g();
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                float fogDensity = 0.05f;
                if (entity instanceof ClientPlayerEntity) {
                    ClientPlayerEntity clientplayerentity = (ClientPlayerEntity)entity;
                    fogDensity -= clientplayerentity.func_203719_J() * clientplayerentity.func_203719_J() * 0.03f;
                    Biome biome = clientplayerentity.field_70170_p.func_226691_t_(clientplayerentity.func_233580_cy_());
                    if (biome.func_201856_r() == Biome.Category.SWAMP) {
                        fogDensity += 0.005f;
                    }
                }
                event.setDensity(fogDensity *= 1.0f + -0.5f * this.lastStrength);
                RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
                event.setCanceled(true);
            } else if (this.landMultiplier.floatValue() < 1.0f && !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                float f3;
                float f2;
                float farPlaneDistance = event.getType() == FogRenderer.FogType.FOG_SKY ? event.getRenderer().func_205001_m() : Math.max(event.getRenderer().func_205001_m() - 16.0f, 32.0f);
                float f1 = MathHelper.func_219799_g((float)this.lastStrength, (float)farPlaneDistance, (float)5.0f);
                if (event.getType() == FogRenderer.FogType.FOG_SKY) {
                    f2 = 0.0f;
                    f3 = f1 * 0.8f;
                } else {
                    f2 = f1 * 0.25f;
                    f3 = f1;
                }
                RenderSystem.fogStart((float)f2);
                RenderSystem.fogEnd((float)f3);
                RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
                RenderSystem.setupNvFogDistance();
                ForgeHooksClient.onFogRender((FogRenderer.FogType)event.getType(), (ActiveRenderInfo)event.getInfo(), (float)((float)event.getRenderPartialTicks()), (float)f3);
                event.setDensity(0.0f);
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        FluidState fluidstate;
        if (event.getInfo().func_216773_g() == this.player && (fluidstate = event.getInfo().func_216771_k()).func_206884_a((ITag)FluidTags.field_206959_a)) {
            float multi = 1.0f + 4.0f * this.lastStrength;
            event.setRed(event.getRed() * multi);
            event.setBlue(event.getBlue() * multi);
            event.setGreen(event.getGreen() * multi);
        }
    }
}

