/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait;

import me.ichun.mods.morph.api.mob.trait.IEventBusRequired;
import me.ichun.mods.morph.api.mob.trait.Trait;
import net.minecraft.client.Minecraft;
import net.minecraft.util.DamageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MoistSkinTrait
extends Trait<MoistSkinTrait>
implements IEventBusRequired {
    public Integer maxMoistness;
    public transient int moistness = -100;
    public transient int lastAir;

    public MoistSkinTrait() {
        this.type = "traitMoistSkin";
    }

    @Override
    public void addHooks() {
        if (this.maxMoistness == null) {
            this.maxMoistness = 2400;
        }
        super.addHooks();
    }

    @Override
    public void tick(float strength) {
        if (this.moistness == -100) {
            this.moistness = this.maxMoistness;
        }
        if (this.player.func_203008_ap()) {
            this.moistness = this.maxMoistness;
        } else {
            --this.moistness;
            if (!this.player.field_70170_p.field_72995_K && this.moistness <= 0) {
                this.player.func_70097_a(DamageSource.field_205132_u, 1.0f);
            }
        }
    }

    @Override
    public MoistSkinTrait copy() {
        return new MoistSkinTrait();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && Minecraft.func_71410_x().func_175606_aa() == this.player) {
            int moistToAir = (int)Math.floor((float)this.moistness / (float)this.maxMoistness.intValue() * 300.0f);
            if (moistToAir < this.player.func_70086_ai()) {
                this.lastAir = this.player.func_70086_ai();
                this.player.func_70050_g(moistToAir);
            } else {
                this.lastAir = -1000;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlayPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && Minecraft.func_71410_x().func_175606_aa() == this.player && this.lastAir != -1000) {
            this.player.func_70050_g(this.lastAir);
        }
    }
}

