/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait;

import java.util.List;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.mob.trait.IEventBusRequired;
import me.ichun.mods.morph.api.mob.trait.Trait;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class IntimidateTrait
extends Trait<IntimidateTrait>
implements IEventBusRequired {
    public String idToIntimidate;
    public String classToIntimidate;
    public Float distance;
    public Double farRunSpeed;
    public Double nearRunSpeed;
    public transient EntityType<?> idIntimidate;
    public transient Class<? extends LivingEntity> classIntimidate;
    public transient float lastStrength = 0.0f;

    public IntimidateTrait() {
        this.type = "traitIntimidate";
    }

    @Override
    public void addHooks() {
        if (this.idToIntimidate != null) {
            this.idIntimidate = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.idToIntimidate));
        } else if (this.classToIntimidate != null) {
            try {
                Class<?> clz = Class.forName(this.classToIntimidate);
                if (LivingEntity.class.isAssignableFrom(clz)) {
                    this.classIntimidate = clz;
                } else {
                    MorphApi.getLogger().warn("Found class to intimidate that is not a LivingEntity class: {}", (Object)this.classToIntimidate);
                }
            }
            catch (ClassNotFoundException e) {
                MorphApi.getLogger().warn("Could not find class to intimidate: {}", (Object)this.classToIntimidate);
            }
        }
        if (this.idIntimidate != null || this.classIntimidate != null) {
            super.addHooks();
            if (this.distance == null) {
                this.distance = Float.valueOf(6.0f);
            }
            if (this.farRunSpeed == null) {
                this.farRunSpeed = 1.0;
            }
            if (this.nearRunSpeed == null) {
                this.nearRunSpeed = 1.0;
            }
        }
    }

    @Override
    public void tick(float strength) {
        this.lastStrength = strength;
        if (!(this.player.field_70170_p.field_72995_K || strength != 1.0f || this.idIntimidate == null && this.classIntimidate == null)) {
            List entitiesIntimidated = this.idIntimidate != null ? this.player.field_70170_p.func_217394_a(this.idIntimidate, this.player.func_174813_aQ().func_72314_b((double)this.distance.floatValue(), 3.0, (double)this.distance.floatValue()), p -> p instanceof CreatureEntity) : this.player.field_70170_p.func_175647_a(this.classIntimidate, this.player.func_174813_aQ().func_72314_b((double)this.distance.floatValue(), 3.0, (double)this.distance.floatValue()), p -> p instanceof CreatureEntity);
            for (Object o : entitiesIntimidated) {
                CreatureEntity creature = (CreatureEntity)o;
                if (creature.func_70661_as().func_75500_f() || this.player.func_70092_e((double)creature.func_70661_as().func_208485_j().func_177958_n(), (double)creature.func_70661_as().func_208485_j().func_177956_o(), (double)creature.func_70661_as().func_208485_j().func_177952_p()) < (double)(this.distance.floatValue() * this.distance.floatValue())) {
                    Path path;
                    Vector3d vector3d = RandomPositionGenerator.func_75461_b((CreatureEntity)creature, (int)16, (int)7, (Vector3d)this.player.func_213303_ch());
                    if (vector3d == null || !(this.player.func_195048_a(vector3d) > this.player.func_70068_e((Entity)creature)) || (path = creature.func_70661_as().func_225466_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0)) == null) continue;
                    double speed = creature.func_70068_e((Entity)this.player) < 49.0 ? this.nearRunSpeed : this.farRunSpeed;
                    creature.func_70661_as().func_75484_a(path, speed);
                    continue;
                }
                double speed = creature.func_70068_e((Entity)this.player) < 49.0 ? this.nearRunSpeed : this.farRunSpeed;
                creature.func_70661_as().func_75489_a(speed);
            }
        }
    }

    @Override
    public IntimidateTrait copy() {
        IntimidateTrait trait = new IntimidateTrait();
        trait.idToIntimidate = this.idToIntimidate;
        trait.classToIntimidate = this.classToIntimidate;
        trait.distance = this.distance;
        trait.farRunSpeed = this.farRunSpeed;
        trait.nearRunSpeed = this.nearRunSpeed;
        return trait;
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (this.lastStrength == 1.0f && event.getTarget() == this.player && (this.idIntimidate != null && this.idIntimidate.equals((Object)event.getEntityLiving().func_200600_R()) || this.classIntimidate != null && this.classIntimidate.isInstance(event.getEntityLiving())) && event.getEntityLiving().func_70643_av() != this.player && event.getEntityLiving().func_94060_bK() != this.player) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }
}

