/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.trait;

import me.ichun.mods.morph.api.mob.trait.IEventBusRequired;
import me.ichun.mods.morph.api.mob.trait.Trait;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectResistanceTrait
extends Trait<EffectResistanceTrait>
implements IEventBusRequired {
    public String effectId;
    public transient Effect effectObj;
    public transient float lastStrength = 0.0f;

    public EffectResistanceTrait() {
        this.type = "traitEffectResistance";
    }

    @Override
    public void addHooks() {
        if (this.effectId != null) {
            if (this.effectId.equals("*")) {
                super.addHooks();
            } else {
                ResourceLocation effectRL = new ResourceLocation(this.effectId);
                Effect theEffect = (Effect)ForgeRegistries.POTIONS.getValue(effectRL);
                if (theEffect != null) {
                    this.effectObj = theEffect;
                    super.addHooks();
                }
            }
        }
    }

    @Override
    public void tick(float strength) {
        this.lastStrength = strength;
        if (this.effectObj != null && this.lastStrength == 1.0f) {
            if (this.effectId.equals("*")) {
                for (EffectInstance effect : this.player.func_70651_bq()) {
                    this.player.func_195063_d(effect.func_188419_a());
                }
            } else {
                EffectInstance potion = this.player.func_70660_b(this.effectObj);
                if (potion != null) {
                    this.player.func_195063_d(this.effectObj);
                }
            }
        }
    }

    @Override
    public EffectResistanceTrait copy() {
        EffectResistanceTrait trait = new EffectResistanceTrait();
        trait.effectId = this.effectId;
        return trait;
    }

    @Override
    public boolean canTransitionTo(Trait<?> trait) {
        if (trait instanceof EffectResistanceTrait) {
            return this.effectId != null && this.effectId.equals(((EffectResistanceTrait)trait).effectId);
        }
        return false;
    }

    @SubscribeEvent
    public void onPotionApplicable(PotionEvent.PotionApplicableEvent event) {
        if (this.lastStrength == 1.0f && event.getEntityLiving() == this.player && (this.effectId != null && this.effectId.equals("*") || event.getPotionEffect().func_188419_a() == this.effectObj)) {
            event.setResult(Event.Result.DENY);
        }
    }
}

