/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.mob.nbt;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import me.ichun.mods.morph.api.MorphApi;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraftforge.fml.ModList;

public class NbtModifier {
    public String author;
    @Nonnull
    public String forClass = "Class Name Here";
    public Boolean isInterface;
    public ArrayList<Modifier> modifiers = new ArrayList();
    public HashMap<String, ArrayList<Modifier>> modSpecificModifiers = new HashMap();
    public transient HashSet<String> toKeep;
    public transient HashMap<String, Modifier> keyToModifier;
    public transient boolean valuesSetup;

    public void setup() {
        if (this.modifiers != null) {
            for (Modifier modifier : this.modifiers) {
                this.addModifier(modifier);
            }
        }
        if (this.modSpecificModifiers != null) {
            this.modSpecificModifiers.forEach((k, v) -> {
                if (ModList.get().isLoaded(k)) {
                    for (Modifier modifier : v) {
                        this.addModifier(modifier);
                    }
                }
            });
        }
    }

    private void addModifier(Modifier modifier) {
        if (modifier.keep != null) {
            if (modifier.keep.booleanValue()) {
                this.toKeep.add(modifier.key);
            } else {
                this.toKeep.remove(modifier.key);
            }
        } else if (this.keyToModifier.containsKey(modifier.key) && this.keyToModifier.get((Object)modifier.key).nestedModifiers != null && modifier.nestedModifiers != null) {
            this.keyToModifier.get(modifier.key).addNestedModifiers(modifier);
        } else {
            this.keyToModifier.put(modifier.key, modifier.copy());
        }
    }

    public void setupValues() {
        if (!this.valuesSetup) {
            this.keyToModifier.entrySet().removeIf(e -> !((Modifier)e.getValue()).setupValue());
            this.valuesSetup = true;
        }
    }

    public void apply(CompoundNBT tag) {
        HashSet<String> keysKept = new HashSet<String>(this.toKeep);
        keysKept.addAll(this.keyToModifier.keySet());
        HashSet tagKeys = new HashSet(tag.func_150296_c());
        for (String s : tagKeys) {
            if (keysKept.contains(s)) continue;
            tag.func_82580_o(s);
        }
        this.keyToModifier.forEach((k, v) -> v.apply(tag));
    }

    public static class Modifier {
        @Nonnull
        public String key = "UNSET";
        public Boolean keep;
        public ArrayList<Modifier> nestedModifiers;
        public String value;
        public transient INBT nbtValue;

        public Modifier copy() {
            Modifier copy = new Modifier();
            copy.key = this.key;
            copy.keep = this.keep;
            if (this.nestedModifiers != null) {
                copy.nestedModifiers = new ArrayList();
                for (Modifier nestedModifier : this.nestedModifiers) {
                    copy.nestedModifiers.add(nestedModifier.copy());
                }
            }
            copy.value = this.value;
            return copy;
        }

        public boolean setupValue() {
            if (this.keep != null) {
                return true;
            }
            if (this.nestedModifiers != null) {
                for (Modifier nestedModifier : this.nestedModifiers) {
                    if (nestedModifier.setupValue()) continue;
                    return false;
                }
            }
            if (this.value != null) {
                JsonToNBT jsonToNBT = new JsonToNBT(new StringReader(this.value));
                try {
                    this.nbtValue = jsonToNBT.func_193610_d();
                    return true;
                }
                catch (CommandSyntaxException e) {
                    MorphApi.getLogger().error("Error parsing Modifier key {} of value {}. Removing modifier.", (Object)this.key, (Object)this.value);
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        public void apply(CompoundNBT tag) {
            if (this.keep != null) {
                if (!this.keep.booleanValue()) {
                    tag.field_74784_a.remove(this.key);
                }
                return;
            }
            if (this.nestedModifiers != null && !this.nestedModifiers.isEmpty() && tag.field_74784_a.get(this.key) instanceof CompoundNBT) {
                HashSet<String> keep = new HashSet<String>();
                CompoundNBT compoundNBT = (CompoundNBT)tag.field_74784_a.get(this.key);
                for (Modifier nestedModifier : this.nestedModifiers) {
                    keep.add(nestedModifier.key);
                    nestedModifier.apply(compoundNBT);
                }
                HashSet tagKeys = new HashSet(compoundNBT.func_150296_c());
                for (String s : tagKeys) {
                    if (keep.contains(s)) continue;
                    compoundNBT.func_82580_o(s);
                }
            }
            if (this.nbtValue != null) {
                INBT ori = (INBT)tag.field_74784_a.get(this.key);
                if (ori != null && ori.func_225647_b_() != this.nbtValue.func_225647_b_()) {
                    MorphApi.getLogger().error("Error applying Modifier key {} of value {}. Incompatible INBT type of {} against {}.", (Object)this.key, (Object)this.value, (Object)this.nbtValue.func_225647_b_(), (Object)ori.func_225647_b_());
                    return;
                }
                tag.field_74784_a.put(this.key, this.nbtValue.func_74737_b());
            }
        }

        public void addNestedModifiers(Modifier modifier) {
            ArrayList<Modifier> newNesteds = new ArrayList<Modifier>(modifier.nestedModifiers);
            block0: for (int i = this.nestedModifiers.size() - 1; i >= 0; --i) {
                Modifier nested = this.nestedModifiers.get(i);
                for (int j = newNesteds.size() - 1; j >= 0; --j) {
                    Modifier newNested = newNesteds.get(j);
                    if (!nested.key.equals(newNested.key)) continue;
                    newNesteds.remove(j);
                    if (nested.nestedModifiers != null && newNested.nestedModifiers != null) {
                        nested.addNestedModifiers(newNested);
                        continue block0;
                    }
                    this.nestedModifiers.remove(i);
                    this.nestedModifiers.add(i, newNested);
                    continue block0;
                }
            }
            this.nestedModifiers.addAll(newNesteds);
            this.value = modifier.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Modifier) {
                Modifier mod = (Modifier)obj;
                if (this.key != null && this.key.equals(mod.key)) {
                    return (this.keep != null && this.keep.equals(mod.keep) || this.keep == null && mod.keep == null) && this.areNestedModifiersEqual(mod.nestedModifiers) && (this.value != null && this.value.equals(mod.value) || this.value == null && mod.value == null);
                }
            }
            return false;
        }

        private boolean areNestedModifiersEqual(ArrayList<Modifier> nested) {
            if (this.nestedModifiers == null && nested == null) {
                return true;
            }
            if (this.nestedModifiers != null && nested != null && this.nestedModifiers.size() == nested.size()) {
                boolean equal = true;
                for (int i = 0; i < this.nestedModifiers.size(); ++i) {
                    if (this.nestedModifiers.get(i).equals(nested.get(i))) continue;
                    equal = false;
                    break;
                }
                return equal;
            }
            return false;
        }
    }
}

