/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.biomass;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class BiomassUpgradeInfo {
    public String id;
    public String parentId;
    @Nullable
    public Integer maxLevel;
    @Nullable
    public Multiplier value;
    @Nullable
    public Multiplier cost;
    public ArrayList<Requirement> showRequirements;
    public ArrayList<Requirement> requirements;
    private String textureLocationOverride;
    private String keyNameOverride;
    private String keyDescOverride;
    public transient ResourceLocation textureLocation;

    public ResourceLocation getTextureLocation() {
        if (this.textureLocation == null) {
            this.textureLocation = this.textureLocationOverride != null ? new ResourceLocation(this.textureLocationOverride) : new ResourceLocation("morph", "textures/biomass/upgrade/" + this.id + ".png");
        }
        return this.textureLocation;
    }

    public static class Requirement {
        public String id;
        public Integer level;
    }

    public static class Multiplier {
        private double baseValue;
        private Double incValue;
        private double multiplier;
        private int equation;

        public double get(int level) {
            if (level <= 0) {
                return 0.0;
            }
            if (this.incValue == null) {
                this.incValue = this.baseValue;
            }
            switch (this.equation) {
                default: {
                    return this.baseValue + this.incValue * this.multiplier * (double)level;
                }
                case 2: {
                    return this.baseValue + this.incValue * Math.pow(level - 1, this.multiplier);
                }
                case 3: {
                    return this.baseValue + this.incValue * Math.pow(this.multiplier, level - 1);
                }
                case 4: {
                    return this.baseValue + this.incValue * Math.log10((double)level * this.multiplier);
                }
                case 5: 
            }
            return this.baseValue + this.incValue * Math.sqrt((double)(level - 1) * this.multiplier);
        }
    }
}

