/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.biomass;

import javax.annotation.Nullable;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.biomass.BiomassUpgradeInfo;
import net.minecraft.nbt.CompoundNBT;

public class BiomassUpgrade {
    private String mobId;
    private String id;
    private int level;
    @Nullable
    public BiomassUpgradeInfo upgradeInfo;

    public BiomassUpgrade(@Nullable String mobId, String id) {
        this.mobId = mobId;
        this.id = id;
        this.level = 0;
    }

    private BiomassUpgrade() {
    }

    public String getMobId() {
        return this.mobId;
    }

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public double getValue() {
        this.updateUpgradeInfo();
        if (this.upgradeInfo != null && this.upgradeInfo.value != null) {
            return this.upgradeInfo.value.get(this.level);
        }
        return 0.0;
    }

    public void updateUpgradeInfo() {
        this.upgradeInfo = MorphApi.getApiImpl().getBiomassUpgradeInfo(this.mobId, this.id);
    }

    public CompoundNBT write(CompoundNBT tag) {
        if (this.mobId != null) {
            tag.func_74778_a("mobId", this.mobId);
        }
        tag.func_74778_a("id", this.id);
        tag.func_74768_a("level", this.level);
        return tag;
    }

    public void read(CompoundNBT tag) {
        if (tag.func_74764_b("mobId")) {
            this.mobId = tag.func_74779_i("mobId");
        }
        this.id = tag.func_74779_i("id");
        this.level = tag.func_74762_e("level");
        this.updateUpgradeInfo();
    }

    public static BiomassUpgrade createFromNBT(CompoundNBT tag) {
        BiomassUpgrade upgrade = new BiomassUpgrade();
        upgrade.read(tag);
        return upgrade;
    }
}

