/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.morph.api.biomass.BiomassUpgrade;
import me.ichun.mods.morph.api.biomass.BiomassUpgradeInfo;
import me.ichun.mods.morph.api.mob.MobData;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.mob.trait.ability.Ability;
import me.ichun.mods.morph.api.morph.AttributeConfig;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.api.morph.MorphVariant;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public interface IApi {
    @Nonnull
    default public GameProfile getGameProfile(@Nullable UUID uuid, @Nullable String name) {
        return new GameProfile(uuid, name);
    }

    @Nonnull
    default public String getMorphModeName() {
        return "";
    }

    default public void spawnAnimation(PlayerEntity player, LivingEntity living, boolean isMorphAcquisition) {
    }

    @Nullable
    default public MorphInfo getMorphInfo(PlayerEntity player) {
        return null;
    }

    @Nullable
    default public LivingEntity getActiveMorphEntity(PlayerEntity player) {
        return null;
    }

    default public boolean isEntityAMorph(LivingEntity living) {
        return false;
    }

    @Nullable
    default public UUID getUuidOfPlayerForMorph(LivingEntity living) {
        return null;
    }

    default public boolean canShowMorphSelector(PlayerEntity player) {
        return false;
    }

    default public boolean canMorph(PlayerEntity player) {
        return false;
    }

    default public boolean canAcquireMorph(PlayerEntity player, LivingEntity living) {
        return false;
    }

    @Nullable
    default public MorphVariant createVariant(LivingEntity living) {
        return null;
    }

    default public boolean acquireMorph(ServerPlayerEntity player, MorphVariant variant) {
        return false;
    }

    default public boolean morphTo(ServerPlayerEntity player, MorphVariant variant) {
        return false;
    }

    default public boolean demorph(ServerPlayerEntity player) {
        return true;
    }

    default public Map<ResourceLocation, AttributeConfig> getSupportedAttributes() {
        return Collections.emptyMap();
    }

    @Nullable
    default public ResourceLocation getMorphSkinTexture() {
        return null;
    }

    default public List<BiConsumer<LivingEntity, PlayerEntity>> getModPlayerMorphSyncConsumers() {
        return ImmutableList.of();
    }

    default public List<BiConsumer<LivingEntity, CompoundNBT>> getVariantNbtTagSetters() {
        return ImmutableList.of();
    }

    default public List<BiConsumer<LivingEntity, CompoundNBT>> getVariantNbtTagReaders() {
        return ImmutableList.of();
    }

    default public void registerMobData(@Nonnull ResourceLocation rl, @Nonnull MobData data) {
    }

    default public void registerTrait(@Nonnull String type, @Nonnull Class<? extends Trait> clz) {
    }

    @Nonnull
    default public ArrayList<Trait<?>> getTraitsForVariant(MorphVariant variant, PlayerEntity player) {
        return new ArrayList();
    }

    default public boolean canUseAbility(PlayerEntity player, Ability<?> ability) {
        return false;
    }

    default public boolean hasUnlockedBiomass(PlayerEntity player) {
        return false;
    }

    default public boolean canAcquireBiomass(PlayerEntity player, LivingEntity living) {
        return false;
    }

    default public double getBiomassAmount(PlayerEntity player, LivingEntity living) {
        return 0.0;
    }

    @Nullable
    default public BiomassUpgradeInfo getBiomassUpgradeInfo(String entityId, String id) {
        return null;
    }

    @Nullable
    default public BiomassUpgrade getBiomassUpgrade(PlayerEntity player, String id) {
        return null;
    }
}

