/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.backtools.common;

import java.util.HashMap;
import java.util.HashSet;
import me.ichun.mods.backtools.client.core.EventHandler;
import me.ichun.mods.backtools.common.core.Config;
import me.ichun.mods.ichunutil.client.core.EventHandlerClient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="backtools")
public class BackTools {
    public static final String MOD_ID = "backtools";
    public static final String MOD_NAME = "Back Tools";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Config config;
    public static HashMap<Class<? extends Item>, Integer> imcOrientation;
    public static HashSet<ResourceLocation> imcDisabledTools;

    public BackTools() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.setupConfig();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::finishLoading);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> EventHandlerClient::getConfigGui);
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LOGGER.log(Level.ERROR, "You are loading Back Tools on a server. Back Tools is a client only mod!"));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void setupConfig() {
        config = (Config)new Config().init();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void finishLoading(FMLLoadCompleteEvent event) {
        EventHandler.addLayers();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream(m -> m.equalsIgnoreCase("blacklist")).forEach(msg -> {
            Object o = msg.getMessageSupplier().get();
            if (o instanceof ItemStack) {
                ItemStack is = (ItemStack)o;
                if (!is.func_190926_b() && imcDisabledTools.add(is.func_77973_b().getRegistryName())) {
                    LOGGER.info("IMC-{}: Disabled {}", (Object)msg.getSenderModId(), (Object)is.func_77973_b().getRegistryName());
                } else {
                    LOGGER.warn("IMC-{}: Unable to disable: {}", (Object)msg.getSenderModId(), (Object)is);
                }
            } else if (o instanceof Item) {
                Item item = (Item)o;
                if (imcDisabledTools.add(item.getRegistryName())) {
                    LOGGER.info("IMC-{}: Disabled {}", (Object)msg.getSenderModId(), (Object)item);
                } else {
                    LOGGER.warn("IMC-{}: Unable to disable: {}", (Object)msg.getSenderModId(), (Object)item);
                }
            } else if (o instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)o;
                if (imcDisabledTools.add(rl)) {
                    LOGGER.info("IMC-{}: Disabled {}", (Object)msg.getSenderModId(), (Object)rl);
                } else {
                    LOGGER.warn("IMC-{}: Unable to disable: {}", (Object)msg.getSenderModId(), (Object)rl);
                }
            } else if (o instanceof String) {
                String s = (String)o;
                if (imcDisabledTools.add(new ResourceLocation(s))) {
                    LOGGER.info("IMC-{}: Disabled {}", (Object)msg.getSenderModId(), (Object)s);
                } else {
                    LOGGER.warn("IMC-{}: Unable to disable: {}", (Object)msg.getSenderModId(), (Object)s);
                }
            }
        });
        event.getIMCStream(m -> m.equalsIgnoreCase("orientation")).forEach(msg -> {
            Object o = msg.getMessageSupplier().get();
            if (!(o instanceof String)) {
                LOGGER.warn("IMC-{}: Passed object is not a string: {}", (Object)msg.getSenderModId(), o);
                return;
            }
            String s = (String)o;
            String[] split = new String[2];
            int index = s.indexOf(58);
            if (index > 0) {
                split[0] = s.substring(0, index);
                split[1] = s.substring(index + 1);
            } else {
                LOGGER.warn("IMC-{}: Could not parse orientation: {}", (Object)msg.getSenderModId(), (Object)s);
            }
            try {
                Class<?> clz = Class.forName(split[0]);
                if (Item.class.isAssignableFrom(clz)) {
                    imcOrientation.put(clz, Integer.parseInt(split[1]));
                } else {
                    LOGGER.warn("IMC-{}: Class does not extend Item class: {}", (Object)msg.getSenderModId(), (Object)split[0]);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("IMC-{}: Could not find class to add orientation: {}", (Object)msg.getSenderModId(), (Object)split[0]);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("IMC-{}: Could not parse integer: {}", (Object)msg.getSenderModId(), (Object)s);
            }
        });
    }

    static {
        imcOrientation = new HashMap();
        imcDisabledTools = new HashSet();
    }
}

