/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.network;

import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketChannel {
    public static final PacketDistributor<ServerPlayerEntity> ALL_EXCEPT = new PacketDistributor(PacketChannel::allExcept, NetworkDirection.PLAY_TO_CLIENT);
    private final SimpleChannel channel;
    private final Object2ByteOpenHashMap<Class<? extends AbstractPacket>> clzToId;
    private final Class<? extends AbstractPacket>[] idToClz;

    @SafeVarargs
    public PacketChannel(ResourceLocation name, String protocolVersion, Class<? extends AbstractPacket> ... packetTypes) {
        this(name, protocolVersion, true, true, packetTypes);
    }

    @SafeVarargs
    public PacketChannel(ResourceLocation name, String protocolVersion, boolean clientRequired, boolean serverRequired, Class<? extends AbstractPacket> ... packetTypes) {
        this(name, protocolVersion, (String o) -> protocolVersion.equals(o) || !serverRequired, (String o) -> protocolVersion.equals(o) || !clientRequired, packetTypes);
    }

    @SafeVarargs
    public PacketChannel(ResourceLocation name, String protocolVersion, Predicate<String> clientPredicate, Predicate<String> serverPredicate, Class<? extends AbstractPacket> ... packetTypes) {
        this.clzToId = new Object2ByteOpenHashMap(packetTypes.length);
        for (int i = 0; i < packetTypes.length; ++i) {
            this.clzToId.put(packetTypes[i], (byte)i);
        }
        this.idToClz = packetTypes;
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> protocolVersion, clientPredicate, serverPredicate);
        this.channel.registerMessage(0, PacketHolder.class, (packet, buffer) -> {
            buffer.writeByte((int)this.clzToId.getByte(((PacketHolder)packet).packet.getClass()));
            ((PacketHolder)packet).packet.writeTo((PacketBuffer)buffer);
        }, buffer -> {
            Class<? extends AbstractPacket> clz = this.idToClz[buffer.readByte()];
            AbstractPacket packet = null;
            try {
                packet = clz.newInstance();
                packet.readFrom((PacketBuffer)buffer);
            }
            catch (IllegalAccessException | InstantiationException e) {
                iChunUtil.LOGGER.error("Error initialising packet.");
                e.printStackTrace();
            }
            return new PacketHolder(packet);
        }, (packet, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            ((PacketHolder)packet).packet.process(context);
            context.setPacketHandled(true);
        });
    }

    public void sendToServer(AbstractPacket packet) {
        this.channel.sendToServer((Object)new PacketHolder(packet));
    }

    public void sendTo(AbstractPacket packet, ServerPlayerEntity player) {
        this.channel.sendTo((Object)new PacketHolder(packet), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendTo(AbstractPacket packet, PacketDistributor.PacketTarget packetTarget) {
        this.channel.send(packetTarget, (Object)new PacketHolder(packet));
    }

    public void reply(AbstractPacket packet, NetworkEvent.Context context) {
        this.channel.reply((Object)new PacketHolder(packet), context);
    }

    private static Consumer<IPacket<?>> allExcept(PacketDistributor<ServerPlayerEntity> packetDistributor, Supplier<ServerPlayerEntity> entityPlayerMPSupplier) {
        return p -> {
            ServerPlayerEntity player = (ServerPlayerEntity)entityPlayerMPSupplier.get();
            for (ServerPlayerEntity serverPlayerEntity : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (serverPlayerEntity == player) continue;
                serverPlayerEntity.field_71135_a.func_147359_a(p);
            }
        };
    }

    private static class PacketHolder {
        private final AbstractPacket packet;

        private PacketHolder(AbstractPacket packet) {
            this.packet = packet;
        }
    }
}

