/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.head;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.api.common.head.HeadInfo;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class HeadHandler {
    public static final HashMap<Class<? extends LivingEntity>, String> MODEL_OFFSET_HELPERS_JSON = new HashMap();
    public static final HashMap<Class<? extends LivingEntity>, HeadInfo<?>> MODEL_OFFSET_HELPERS = new HashMap();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(HeadInfo.class, (Object)new HeadInfo.Serializer()).create();
    public static final HashSet<String> IMC_HEAD_INFO = new HashSet();
    public static final HashSet<HeadInfo.HeadHolder> IMC_HEAD_INFO_OBJ = new HashSet();
    public static final int HEAD_INFO_VERSION = 5;
    public static BooleanSupplier acidEyesBooleanSupplier = () -> false;
    private static Path headDir;
    private static boolean init;

    @Nullable
    public static HeadInfo<?> getHelper(Class<? extends LivingEntity> clz) {
        if (MODEL_OFFSET_HELPERS.containsKey(clz)) {
            return MODEL_OFFSET_HELPERS.get(clz);
        }
        HeadInfo helper = null;
        Class<? extends LivingEntity> clzz = clz.getSuperclass();
        if (clzz != LivingEntity.class && (helper = HeadHandler.getHelper(clzz)) != null) {
            helper = (HeadInfo)GSON.fromJson(GSON.toJson(helper), helper.getClass());
        }
        MODEL_OFFSET_HELPERS.put(clz, helper);
        return helper;
    }

    @Nullable
    public static String getHelperJson(Class<? extends LivingEntity> clz) {
        if (MODEL_OFFSET_HELPERS_JSON.containsKey(clz)) {
            return MODEL_OFFSET_HELPERS_JSON.get(clz);
        }
        String json = null;
        Class<? extends LivingEntity> clzz = clz.getSuperclass();
        if (clzz != LivingEntity.class) {
            json = HeadHandler.getHelperJson(clzz);
        }
        return json;
    }

    public static boolean hasInit() {
        return init;
    }

    public static synchronized void init() {
        if (!init) {
            init = true;
            HeadInfo.horseEasterEgg = () -> iChunUtil.configClient.horseEasterEgg;
            HeadInfo.acidEyesBooleanSupplier = acidEyesBooleanSupplier;
            HeadInfo.aggressiveHeadTracking = () -> iChunUtil.configClient.aggressiveHeadTracking;
            try {
                File extractedMarker;
                Path workingDir = FMLPaths.CONFIGDIR.get().resolve("ichunutil");
                if (!Files.exists(workingDir, new LinkOption[0])) {
                    Files.createDirectory(workingDir, new FileAttribute[0]);
                }
                if (!Files.exists(headDir = workingDir.resolve("head"), new LinkOption[0])) {
                    Files.createDirectory(headDir, new FileAttribute[0]);
                }
                if (!(extractedMarker = new File(headDir.toFile(), "5.extracted")).exists()) {
                    InputStream in = iChunUtil.class.getResourceAsStream("/heads.zip");
                    if (in != null) {
                        iChunUtil.LOGGER.info("Extracted {} Head Info files.", (Object)IOUtil.extractFiles(headDir, in, true));
                    } else {
                        iChunUtil.LOGGER.error("Error extracting heads.zip. InputStream was null.");
                    }
                    FileUtils.writeStringToFile((File)extractedMarker, (String)"", (Charset)StandardCharsets.UTF_8);
                }
                HeadHandler.loadHeadInfos();
            }
            catch (IOException e) {
                iChunUtil.LOGGER.fatal("Error initialising HeadInfo resources!");
                e.printStackTrace();
            }
        }
    }

    public static Path getHeadsDir() {
        return headDir;
    }

    public static int loadHeadInfos() {
        MODEL_OFFSET_HELPERS_JSON.clear();
        MODEL_OFFSET_HELPERS.clear();
        int count = HeadHandler.scourDirectory(HeadHandler.getHeadsDir().toFile());
        iChunUtil.LOGGER.info("Loaded {} HeadInfo object(s)", (Object)count);
        int modCount = 0;
        if (!IMC_HEAD_INFO.isEmpty()) {
            for (String s : IMC_HEAD_INFO) {
                try {
                    if (HeadHandler.readHeadInfoJson(s)) {
                        ++modCount;
                        continue;
                    }
                    iChunUtil.LOGGER.error("Error reading IMC HeadInfo file: {}", (Object)s);
                }
                catch (JsonSyntaxException | IllegalStateException e) {
                    iChunUtil.LOGGER.error("Error reading IMC HeadInfo file: {}", (Object)s);
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    iChunUtil.LOGGER.error("Class not found for IMC HeadInfo file: {}", (Object)s);
                }
            }
            iChunUtil.LOGGER.info("Loaded {} IMC HeadInfo object(s)", (Object)modCount);
        }
        if (!IMC_HEAD_INFO_OBJ.isEmpty()) {
            for (HeadInfo.HeadHolder headHolder : IMC_HEAD_INFO_OBJ) {
                if (!LivingEntity.class.isAssignableFrom(headHolder.clz)) continue;
                MODEL_OFFSET_HELPERS.put(headHolder.clz, headHolder.info);
            }
        }
        return count + modCount;
    }

    private static int scourDirectory(File dir) {
        File[] files;
        int count = 0;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                count += HeadHandler.scourDirectory(file);
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                if (HeadHandler.readHeadInfoJson(json)) {
                    ++count;
                    continue;
                }
                iChunUtil.LOGGER.error("Error reading HeadInfo file, no forClass: {}", (Object)file);
            }
            catch (JsonSyntaxException | IOException | IllegalStateException e) {
                iChunUtil.LOGGER.error("Error reading HeadInfo file: {}", (Object)file);
                e.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return count;
    }

    public static boolean readHeadInfoJson(String json) throws ClassNotFoundException, JsonSyntaxException, IllegalStateException {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        if (jsonObject.has("forClass")) {
            String className = jsonObject.get("forClass").getAsString();
            Class<?> clz = Class.forName(className);
            if (MODEL_OFFSET_HELPERS_JSON.containsKey(clz)) {
                iChunUtil.LOGGER.warn("We already have another HeadInfo for {}", (Object)clz.getName());
            }
            MODEL_OFFSET_HELPERS_JSON.put(clz, json);
            if (!HeadHandler.loadHeadInfo(clz, json)) {
                MODEL_OFFSET_HELPERS_JSON.remove(clz);
            }
            return true;
        }
        return false;
    }

    public static boolean loadHeadInfo(Class clz, String json) {
        try {
            HeadInfo info = (HeadInfo)GSON.fromJson(json, HeadInfo.class);
            MODEL_OFFSET_HELPERS.put(clz, info);
            return true;
        }
        catch (Throwable t) {
            iChunUtil.LOGGER.error("Error deserialising HeadInfo for {}", (Object)clz.getName());
            t.printStackTrace();
            return false;
        }
    }

    public static void serializeHeadInfos() {
        for (Map.Entry<Class<LivingEntity>, HeadInfo<?>> e : MODEL_OFFSET_HELPERS.entrySet()) {
            if (e.getKey() == PlayerEntity.class) {
                e.getValue().hasStrippedInfo = true;
            }
            e.getValue().forClass = e.getKey().getName();
            if (e.getKey() != EnderDragonEntity.class) continue;
            File file = new File(HeadHandler.getHeadsDir().toFile(), e.getKey().getSimpleName() + ".json");
            try {
                String json = GSON.toJson(e.getValue(), HeadInfo.class);
                FileUtils.writeStringToFile((File)file, (String)json, (String)"UTF-8");
            }
            catch (IOException json) {
            }
            catch (Throwable e1) {
                e1.printStackTrace();
                break;
            }
        }
    }

    public static class SerialiserHelper {
        public boolean shiftKeyDown;

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                if (this.shiftKeyDown && !Screen.func_231173_s_() && Screen.func_231172_r_()) {
                    System.out.println("dump");
                    HeadHandler.serializeHeadInfos();
                }
                this.shiftKeyDown = Screen.func_231173_s_();
            }
        }
    }
}

