/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.collect.IngredientSet;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.ingredients.RegisteredIngredient;
import mezz.jei.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientManager
implements IIngredientManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IModIdHelper modIdHelper;
    private final IngredientBlacklistInternal blacklist;
    private final ImmutableMap<IIngredientType<?>, RegisteredIngredient<?>> ingredientsMap;
    private final ImmutableList<IIngredientType<?>> registeredIngredientTypes;
    private final boolean enableDebugLogs;
    private final ImmutableMap<Class<?>, IIngredientType<?>> ingredientTypeMap;

    public IngredientManager(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, List<RegisteredIngredient<?>> registeredIngredients, boolean enableDebugLogs) {
        this.modIdHelper = modIdHelper;
        this.blacklist = blacklist;
        ImmutableMap.Builder ingredientsMapBuilder = ImmutableMap.builder();
        for (RegisteredIngredient<?> registeredIngredient : registeredIngredients) {
            IIngredientType ingredientType = registeredIngredient.getIngredientType();
            ingredientsMapBuilder.put(ingredientType, registeredIngredient);
        }
        this.ingredientsMap = ingredientsMapBuilder.build();
        this.registeredIngredientTypes = (ImmutableList)registeredIngredients.stream().map(RegisteredIngredient::getIngredientType).collect(ImmutableList.toImmutableList());
        this.enableDebugLogs = enableDebugLogs;
        ImmutableMap.Builder ingredientTypeBuilder = ImmutableMap.builder();
        for (IIngredientType ingredientType : this.ingredientsMap.keySet()) {
            ingredientTypeBuilder.put(ingredientType.getIngredientClass(), (Object)ingredientType);
        }
        this.ingredientTypeMap = ingredientTypeBuilder.build();
    }

    @Nullable
    private <V> RegisteredIngredient<V> getRegisteredIngredient(IIngredientType<V> ingredientType) {
        return (RegisteredIngredient)this.ingredientsMap.get(ingredientType);
    }

    @Override
    public <V> Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        RegisteredIngredient<V> registeredIngredient = this.getRegisteredIngredient(ingredientType);
        if (registeredIngredient == null) {
            return Collections.emptySet();
        }
        IngredientSet<V> ingredients = registeredIngredient.getIngredientSet();
        return Collections.unmodifiableCollection(ingredients);
    }

    public <V> Optional<V> getIngredientByUid(IIngredientType<V> ingredientType, String uid) {
        RegisteredIngredient<V> registeredIngredient = this.getRegisteredIngredient(ingredientType);
        if (registeredIngredient == null) {
            return Optional.empty();
        }
        IngredientSet<V> ingredients = registeredIngredient.getIngredientSet();
        return ingredients.getByUid(uid);
    }

    public <V> boolean isValidIngredient(V ingredient) {
        try {
            IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(ingredient);
            return ingredientHelper.isValidIngredient(ingredient);
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientHelper(ingredientType);
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        RegisteredIngredient<V> registeredIngredient = this.getRegisteredIngredient(ingredientType);
        if (registeredIngredient != null) {
            return registeredIngredient.getIngredientHelper();
        }
        throw new IllegalArgumentException("Unknown ingredient type: " + ingredientType.getIngredientClass());
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientRenderer(ingredientType);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        RegisteredIngredient<V> registeredIngredient = this.getRegisteredIngredient(ingredientType);
        if (registeredIngredient == null) {
            throw new IllegalArgumentException("Could not find ingredient for " + ingredientType);
        }
        return registeredIngredient.getIngredientRenderer();
    }

    @Override
    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return this.registeredIngredientTypes;
    }

    @Override
    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.addIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        RegisteredIngredient<V> registeredIngredient = this.getRegisteredIngredient(ingredientType);
        if (registeredIngredient == null) {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredientType.getIngredientClass());
        }
        LOGGER.info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        IngredientSet<V> set = registeredIngredient.getIngredientSet();
        set.addAll(ingredients);
        IIngredientHelper<V> ingredientHelper = registeredIngredient.getIngredientHelper();
        for (V ingredient : ingredients) {
            List<IIngredientListElementInfo<V>> matchingElementInfos = ingredientFilter.findMatchingElements(ingredientHelper, ingredient);
            if (!matchingElementInfos.isEmpty()) {
                for (IIngredientListElementInfo<V> matchingElementInfo : matchingElementInfos) {
                    IIngredientListElement<V> matchingElement = matchingElementInfo.getElement();
                    this.blacklist.removeIngredientFromBlacklist(matchingElement.getIngredient(), ingredientHelper);
                    ingredientFilter.updateHiddenState(matchingElement);
                }
                if (!this.enableDebugLogs) continue;
                LOGGER.debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
                continue;
            }
            IIngredientListElement<V> element = IngredientListElementFactory.createOrderedElement(ingredient);
            IIngredientListElementInfo<V> info = IngredientListElementInfo.create(element, this, this.modIdHelper);
            if (info == null) continue;
            this.blacklist.removeIngredientFromBlacklist(ingredient, ingredientHelper);
            ingredientFilter.addIngredient(info);
            if (!this.enableDebugLogs) continue;
            LOGGER.debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
        }
        ingredientFilter.invalidateCache();
    }

    @Override
    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.removeIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientType(ingredientClass);
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType ingredientType = (IIngredientType)this.ingredientTypeMap.get(ingredientClass);
        if (ingredientType != null) {
            return ingredientType;
        }
        for (IIngredientType type : this.registeredIngredientTypes) {
            if (!type.getIngredientClass().isAssignableFrom(ingredientClass)) continue;
            IIngredientType castType = type;
            return castType;
        }
        throw new IllegalArgumentException("Unknown ingredient class: " + ingredientClass);
    }

    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        RegisteredIngredient<V> registeredIngredient = this.getRegisteredIngredient(ingredientType);
        if (registeredIngredient == null) {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredientType.getIngredientClass());
        }
        LOGGER.info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        IngredientSet<V> set = registeredIngredient.getIngredientSet();
        set.removeAll(ingredients);
        IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(ingredientType);
        for (V ingredient : ingredients) {
            List<IIngredientListElementInfo<V>> matchingElementInfos = ingredientFilter.findMatchingElements(ingredientHelper, ingredient);
            if (matchingElementInfos.isEmpty()) {
                String errorInfo = ingredientHelper.getErrorInfo(ingredient);
                LOGGER.error("Could not find any matching ingredients to remove: {}", (Object)errorInfo);
            } else if (this.enableDebugLogs) {
                LOGGER.debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
            }
            for (IIngredientListElementInfo<V> matchingElementInfo : matchingElementInfos) {
                IIngredientListElement<V> matchingElement = matchingElementInfo.getElement();
                this.blacklist.addIngredientToBlacklist(matchingElement.getIngredient(), ingredientHelper);
                matchingElement.setVisible(false);
            }
        }
        ingredientFilter.invalidateCache();
    }
}

