/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.network.shared.flushconsolidation;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import me.steinborn.krypton.mod.shared.network.util.AutoFlushUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.PlayerGenerationTracker;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkManager.class})
public abstract class ThreadedAnvilChunkStorageMixin {
    @Shadow
    @Final
    private PlayerGenerationTracker field_219271_y;
    @Shadow
    @Final
    private ServerWorld field_219255_i;
    @Shadow
    @Final
    private ChunkManager.ProxyTicketManager field_219267_u;
    @Shadow
    private int field_219247_A;
    @Shadow
    @Final
    private Int2ObjectMap<ChunkManager.EntityTracker> field_219272_z;

    @Shadow
    protected abstract boolean func_219187_b(ServerPlayerEntity var1);

    @Shadow
    protected abstract SectionPos func_223489_c(ServerPlayerEntity var1);

    @Shadow
    private static int func_219232_a(ChunkPos pos, int x, int z) {
        throw new AssertionError((Object)"pedantic");
    }

    @Shadow
    protected abstract void func_219180_a(ServerPlayerEntity var1, IPacket<?>[] var2, Chunk var3);

    @Shadow
    @Nullable
    protected abstract ChunkHolder func_219219_b(long var1);

    @Shadow
    private static int func_219215_b(ChunkPos p_219215_0_, ServerPlayerEntity p_219215_1_, boolean p_219215_2_) {
        return 0;
    }

    @Overwrite
    public void func_219183_a(ServerPlayerEntity player) {
        boolean movedSections;
        for (ChunkManager.EntityTracker entityTracker : this.field_219272_z.values()) {
            if (entityTracker.field_219403_c == player) {
                entityTracker.func_219397_a(this.field_219255_i.func_217369_A());
                continue;
            }
            entityTracker.func_219400_b(player);
        }
        SectionPos oldPos = player.func_213842_M();
        SectionPos newPos = SectionPos.func_218157_a((Entity)player);
        boolean isWatchingWorld = this.field_219271_y.func_225419_d(player);
        boolean noChunkGen = this.func_219187_b(player);
        boolean bl = movedSections = !oldPos.equals((Object)newPos);
        if (movedSections || isWatchingWorld != noChunkGen) {
            this.func_223489_c(player);
            if (!isWatchingWorld) {
                this.field_219267_u.func_219367_b(oldPos, player);
            }
            if (!noChunkGen) {
                this.field_219267_u.func_219341_a(newPos, player);
            }
            if (!isWatchingWorld && noChunkGen) {
                this.field_219271_y.func_219446_a(player);
            }
            if (isWatchingWorld && !noChunkGen) {
                this.field_219271_y.func_219447_b(player);
            }
            long oldChunkPos = ChunkPos.func_77272_a((int)oldPos.func_177958_n(), (int)oldPos.func_177952_p());
            long newChunkPos = ChunkPos.func_77272_a((int)newPos.func_177958_n(), (int)newPos.func_177952_p());
            this.field_219271_y.func_219445_a(oldChunkPos, newChunkPos, player);
            if (this.field_219255_i == player.field_70170_p) {
                this.sendChunks(oldPos, player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChunks(SectionPos oldPos, ServerPlayerEntity player) {
        AutoFlushUtil.setAutoFlush(player, false);
        try {
            int oldChunkX = oldPos.func_218149_a();
            int oldChunkZ = oldPos.func_218148_c();
            int newChunkX = MathHelper.func_76128_c((double)player.func_226277_ct_()) >> 4;
            int newChunkZ = MathHelper.func_76128_c((double)player.func_226281_cx_()) >> 4;
            if (Math.abs(oldChunkX - newChunkX) <= this.field_219247_A * 2 && Math.abs(oldChunkZ - newChunkZ) <= this.field_219247_A * 2) {
                int minSendChunkX = Math.min(newChunkX, oldChunkX) - this.field_219247_A;
                int maxSendChunkZ = Math.min(newChunkZ, oldChunkZ) - this.field_219247_A;
                int q = Math.max(newChunkX, oldChunkX) + this.field_219247_A;
                int r = Math.max(newChunkZ, oldChunkZ) + this.field_219247_A;
                for (int curX = minSendChunkX; curX <= q; ++curX) {
                    for (int curZ = maxSendChunkZ; curZ <= r; ++curZ) {
                        ChunkPos chunkPos = new ChunkPos(curX, curZ);
                        boolean inOld = ThreadedAnvilChunkStorageMixin.func_219232_a(chunkPos, oldChunkX, oldChunkZ) <= this.field_219247_A;
                        boolean inNew = ThreadedAnvilChunkStorageMixin.func_219232_a(chunkPos, newChunkX, newChunkZ) <= this.field_219247_A;
                        this.sendPacketsForChunk(player, chunkPos, new IPacket[2], inOld, inNew);
                    }
                }
            } else {
                ChunkPos pos;
                int curZ;
                int curX;
                for (curX = oldChunkX - this.field_219247_A; curX <= oldChunkX + this.field_219247_A; ++curX) {
                    for (curZ = oldChunkZ - this.field_219247_A; curZ <= oldChunkZ + this.field_219247_A; ++curZ) {
                        pos = new ChunkPos(curX, curZ);
                        this.sendPacketsForChunk(player, pos, new IPacket[2], true, false);
                    }
                }
                for (curX = newChunkX - this.field_219247_A; curX <= newChunkX + this.field_219247_A; ++curX) {
                    for (curZ = newChunkZ - this.field_219247_A; curZ <= newChunkZ + this.field_219247_A; ++curZ) {
                        pos = new ChunkPos(curX, curZ);
                        this.sendPacketsForChunk(player, pos, new IPacket[2], false, true);
                    }
                }
            }
        }
        finally {
            AutoFlushUtil.setAutoFlush(player, true);
        }
    }

    protected void sendPacketsForChunk(ServerPlayerEntity player, ChunkPos pos, IPacket<?>[] packets, boolean withinMaxWatchDistance, boolean withinViewDistance) {
        ChunkHolder chunkHolder;
        if (withinViewDistance && !withinMaxWatchDistance && (chunkHolder = this.func_219219_b(pos.func_201841_a())) != null) {
            Chunk worldChunk = chunkHolder.func_219298_c();
            if (worldChunk != null) {
                this.func_219180_a(player, packets, worldChunk);
            }
            DebugPacketSender.func_218802_a((ServerWorld)this.field_219255_i, (ChunkPos)pos);
        }
        if (!withinViewDistance && withinMaxWatchDistance) {
            player.func_213845_a(pos);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void disableAutoFlushForEntityTracking(CallbackInfo info) {
        for (ServerPlayerEntity player : this.field_219255_i.func_217369_A()) {
            AutoFlushUtil.setAutoFlush(player, false);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void enableAutoFlushForEntityTracking(CallbackInfo info) {
        for (ServerPlayerEntity player : this.field_219255_i.func_217369_A()) {
            AutoFlushUtil.setAutoFlush(player, true);
        }
    }
}

