/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;

public class RenderText {
    public static final char FORMATTING_CHAR = '\u00a7';
    public static final char BOLD_FORMATTING_CHAR = 'l';
    public static final char ITALIC_FORMATTING_CHAR = 'o';
    public static final char UNDERLINE_FORMATTING_CHAR = 'n';
    public static final char STRIKETHROUGH_FORMATTING_CHAR = 'm';
    public static final char RANDOM_FORMATTING_CHAR = 'k';
    public static final char RESET_FORMATTING_CHAR = 'r';
    public static final char UNDERLINE_CHAR = '_';
    public static final char STRIKETHROUGH_CHAR = '-';
    private static final Map<String, FontData> fontDatas = new HashMap<String, FontData>();
    private static final TransformationMatrix transformHelper = new TransformationMatrix();

    public static void drawText(String text, String fontName, Point3D position, ColorRGB color, TextAlignment alignment, float scale, boolean autoScale, int wrapWidth, boolean renderLit, int worldLightValue) {
        if (!text.isEmpty()) {
            transformHelper.resetTransforms();
            transformHelper.applyTranslation(position);
            RenderText.getFontData(fontName).renderText(text, RenderText.transformHelper, null, alignment, scale, autoScale, wrapWidth, true, color, renderLit, worldLightValue, true);
        }
    }

    public static void draw3DText(String text, AEntityD_Definable<?> entity, TransformationMatrix transform, JSONText definition, boolean pixelCoords) {
        if (!text.isEmpty()) {
            ColorRGB color = entity.getTextColor(definition.inheritedColorIndex, definition.color);
            transformHelper.set(transform);
            transformHelper.applyTranslation(definition.pos);
            RenderText.getFontData(definition.fontName).renderText(text, RenderText.transformHelper, definition.rot, TextAlignment.values()[definition.renderPosition], definition.scale, definition.autoScale, definition.wrapWidth, pixelCoords, color, definition.lightsUp && entity.renderTextLit(), entity.worldLightValue, false);
        }
    }

    public static float getStringWidth(String text, String fontName) {
        return RenderText.getFontData(fontName).getStringWidth(text);
    }

    public static float getHeight(int numberLines) {
        return (float)numberLines * 9.0f;
    }

    private static FontData getFontData(String fontName) {
        FontData fontData = fontDatas.get(fontName);
        if (fontData == null) {
            fontData = new FontData(fontName);
            fontDatas.put(fontName, fontData);
        }
        return fontData;
    }

    private static class FontData {
        private static final byte CHARS_PER_ROWCOL = 16;
        private static final int CHARS_PER_TEXTURE_SHEET = 256;
        private static final byte DEFAULT_CHAR_HEIGHT_PIXELS = 7;
        private static final byte DEFAULT_PIXELS_PER_CHAR = 8;
        private static final float LINE_SPACING = 1.0f;
        private static final ColorRGB[] COLORS = new ColorRGB[]{new ColorRGB(0, 0, 0), new ColorRGB(0, 0, 170), new ColorRGB(0, 170, 0), new ColorRGB(0, 170, 170), new ColorRGB(170, 0, 0), new ColorRGB(170, 0, 170), new ColorRGB(255, 170, 0), new ColorRGB(170, 170, 170), new ColorRGB(85, 85, 85), new ColorRGB(85, 85, 255), new ColorRGB(85, 255, 85), new ColorRGB(85, 255, 255), new ColorRGB(255, 85, 85), new ColorRGB(255, 85, 255), new ColorRGB(255, 255, 85), new ColorRGB(255, 255, 255)};
        private static final FontRenderState[] STATES = FontRenderState.generateDefaults();
        private static final int MAX_VERTCIES_PER_RENDER = 6000;
        private static final Point3D adjustmentOffset = new Point3D();
        private final String[] fontLocations = new String[255];
        private final float charScale;
        private final float charTopOffset;
        private final float[] charWidths = new float[65535];
        private final float[] charSpacings = new float[65535];
        private final float[] offsetsMinU = new float[65535];
        private final float[] offsetsMaxU = new float[65535];
        private final float[] offsetsMinV = new float[65535];
        private final float[] offsetsMaxV = new float[65535];
        private static final Map<String, Map<ColorRGB, RenderableData>> createdRenderObjects = new HashMap<String, Map<ColorRGB, RenderableData>>();
        private final Set<RenderableData> activeRenderObjects = new LinkedHashSet<RenderableData>();
        private final float[] charVertex = new float[3];
        private final float[] supplementalVertex = new float[3];
        private final float[] charUV = new float[2];
        private final float[] supplementalUV = new float[2];

        private FontData(String fontName) {
            String fontBaseLocation = fontName == null ? "/assets/minecraft/textures/font/unicode_page_" : "/assets/" + fontName.substring(0, fontName.indexOf(":")) + "/textures/fonts/" + fontName.substring(fontName.indexOf(":") + 1) + "/unicode_page_";
            float scale = 1.0f;
            float charTopOffset = 0.0f;
            for (int i = 0; i < this.fontLocations.length; ++i) {
                BufferedImage bufferedImage;
                this.fontLocations[i] = String.format("%s%02x.png", fontBaseLocation, i);
                try {
                    bufferedImage = ImageIO.read(InterfaceManager.renderingInterface.getTextureStream(this.fontLocations[i]));
                }
                catch (Exception e) {
                    continue;
                }
                int pixelsPerSide = bufferedImage.getHeight();
                int pixelsPerCharRowCol = pixelsPerSide / 16;
                for (int charRow = 0; charRow < 16; ++charRow) {
                    block4: for (int charCol = 0; charCol < 16; ++charCol) {
                        int pixelValue;
                        int pixelRow;
                        int pixelCol;
                        char charChecking = (char)(i * 256 + charRow * 16 + charCol);
                        if (charChecking == '0') {
                            boolean foundTopPixel = false;
                            int topPixel = charRow * pixelsPerCharRowCol;
                            int bottomPixel = (charRow + 1) * pixelsPerCharRowCol - 1;
                            for (int pixelRow2 = charRow * pixelsPerCharRowCol; pixelRow2 < (charRow + 1) * pixelsPerCharRowCol; ++pixelRow2) {
                                boolean foundPixelThisRow = false;
                                for (int pixelCol2 = charCol * pixelsPerCharRowCol; pixelCol2 < (charCol + 1) * pixelsPerCharRowCol; ++pixelCol2) {
                                    int pixelValue2 = bufferedImage.getRGB(pixelCol2, pixelRow2);
                                    if (pixelValue2 == 0 || pixelValue2 >> 24 == 0) continue;
                                    foundPixelThisRow = true;
                                    if (foundTopPixel) continue;
                                    topPixel = pixelRow2;
                                    foundTopPixel = true;
                                    charTopOffset = 8.0f * (float)(pixelRow2 - charRow * pixelsPerCharRowCol) / (float)pixelsPerCharRowCol;
                                }
                                if (foundPixelThisRow || !foundTopPixel) continue;
                                bottomPixel = pixelRow2;
                                break;
                            }
                            scale = 0.875f / ((float)(bottomPixel - topPixel) / (float)pixelsPerCharRowCol);
                        }
                        if (charChecking == ' ') {
                            this.charWidths[charChecking] = 4.0f;
                            this.charSpacings[charChecking] = 0.0f;
                            continue;
                        }
                        this.offsetsMinU[charChecking] = (float)charCol / 16.0f;
                        this.offsetsMaxU[charChecking] = (float)(charCol + 1) / 16.0f;
                        this.offsetsMaxV[charChecking] = (float)charRow / 16.0f;
                        this.offsetsMinV[charChecking] = (float)(charRow + 1) / 16.0f;
                        this.charWidths[charChecking] = 8.0f;
                        boolean foundPixelThisCol = false;
                        for (pixelCol = charCol * pixelsPerCharRowCol; pixelCol < (charCol + 1) * pixelsPerCharRowCol; ++pixelCol) {
                            for (pixelRow = charRow * pixelsPerCharRowCol; pixelRow < (charRow + 1) * pixelsPerCharRowCol; ++pixelRow) {
                                pixelValue = bufferedImage.getRGB(pixelCol, pixelRow);
                                if (pixelValue == 0 || pixelValue >> 24 == 0) continue;
                                this.offsetsMinU[charChecking] = (float)pixelCol / (float)pixelsPerCharRowCol / 16.0f;
                                this.charSpacings[charChecking] = (float)(pixelCol - charCol * pixelsPerCharRowCol) / (float)pixelsPerCharRowCol * 8.0f;
                                foundPixelThisCol = true;
                                break;
                            }
                            if (foundPixelThisCol) break;
                        }
                        foundPixelThisCol = false;
                        for (pixelCol = (charCol + 1) * pixelsPerCharRowCol - 1; pixelCol >= charCol * pixelsPerCharRowCol; --pixelCol) {
                            for (pixelRow = charRow * pixelsPerCharRowCol; pixelRow < (charRow + 1) * pixelsPerCharRowCol; ++pixelRow) {
                                pixelValue = bufferedImage.getRGB(pixelCol, pixelRow);
                                if (pixelValue == 0 || pixelValue >> 24 == 0) continue;
                                this.offsetsMaxU[charChecking] = (float)(++pixelCol) / (float)pixelsPerCharRowCol / 16.0f;
                                this.charWidths[charChecking] = (this.offsetsMaxU[charChecking] - this.offsetsMinU[charChecking]) * 16.0f * 8.0f;
                                foundPixelThisCol = true;
                                break;
                            }
                            if (foundPixelThisCol) continue block4;
                        }
                    }
                }
            }
            this.charScale = scale;
            this.charTopOffset = charTopOffset;
        }

        private void renderText(String text, TransformationMatrix transform, RotationMatrix rotation, TextAlignment alignment, float scale, boolean autoScale, int wrapWidth, boolean pixelCoords, ColorRGB color, boolean renderLit, int worldLightValue, boolean onGUI) {
            for (RenderableData object : this.activeRenderObjects) {
                object.vertexObject.vertices.clear();
            }
            this.activeRenderObjects.clear();
            if (text.length() > 1000) {
                text = text.substring(0, 1000);
            }
            float[] normals = new float[]{0.0f, 0.0f, 1.0f};
            if (text.indexOf(274) != -1) {
                char[] textArray = text.toCharArray();
                boolean randomActive = false;
                for (int i = 0; i < textArray.length; ++i) {
                    if (textArray[i] == '\u00a7') {
                        char formattingChar;
                        if ((formattingChar = textArray[++i]) == 'k') {
                            randomActive = true;
                            continue;
                        }
                        if (formattingChar != 'r') continue;
                        randomActive = false;
                        continue;
                    }
                    if (!randomActive) continue;
                    textArray[i] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt((int)(Math.random() * 36.0));
                }
                text = String.valueOf(textArray);
            }
            adjustmentOffset.set(0.0, this.charTopOffset, 0.0);
            scale *= this.charScale;
            float stringWidth = this.getStringWidth(text);
            if (autoScale && wrapWidth > 0) {
                float scaledStringWidth = scale * stringWidth;
                if (scaledStringWidth > (float)wrapWidth) {
                    double scaleFactor = (float)wrapWidth / scaledStringWidth;
                    scale = (float)((double)scale * scaleFactor);
                    adjustmentOffset.add(0.0, 4.0 * (scaleFactor - 1.0), 0.0);
                }
                wrapWidth = 0;
            }
            if (!pixelCoords) {
                scale /= 16.0f;
            }
            float alignmentOffset = 0.0f;
            if (alignment.equals((Object)TextAlignment.CENTERED)) {
                alignmentOffset = (wrapWidth == 0 ? -stringWidth : (float)(-wrapWidth)) / 2.0f;
            } else if (alignment.equals((Object)TextAlignment.RIGHT_ALIGNED)) {
                alignmentOffset = -stringWidth;
            }
            wrapWidth = (int)((float)wrapWidth / scale);
            float currentOffset = 0.0f;
            float currentLineOffset = 0.0f;
            int indexAtLastNewline = 0;
            ColorRGB currentColor = color;
            FontRenderState currentState = STATES[0];
            block23: for (int i = 0; i < text.length(); ++i) {
                char textChar = text.charAt(i);
                if (textChar == '\u00a7') {
                    char formattingChar = text.charAt(++i);
                    switch (formattingChar) {
                        case 'l': {
                            currentState = STATES[currentState.index | 1];
                            break;
                        }
                        case 'o': {
                            currentState = STATES[currentState.index | 2];
                            break;
                        }
                        case 'n': {
                            currentState = STATES[currentState.index | 4];
                            break;
                        }
                        case 'm': {
                            currentState = STATES[currentState.index | 8];
                            break;
                        }
                        case 'r': {
                            currentState = STATES[0];
                            currentColor = color;
                            break;
                        }
                        default: {
                            try {
                                currentColor = COLORS[Integer.decode("0x" + formattingChar)];
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                    continue;
                }
                if (textChar == '\n') {
                    currentOffset = 0.0f;
                    currentLineOffset -= 9.0f;
                    indexAtLastNewline = i;
                    continue;
                }
                if (wrapWidth != 0 && currentOffset > (float)wrapWidth) {
                    if (text.substring(indexAtLastNewline + 1, i).indexOf(32) != -1) {
                        for (int j = i - 1; j > 0; --j) {
                            char priorChar = text.charAt(j);
                            if (priorChar == ' ') {
                                i = j;
                                currentOffset = 0.0f;
                                currentLineOffset -= 9.0f;
                                indexAtLastNewline = i;
                                continue block23;
                            }
                            RenderableData priorRenderObject = this.getObjectFor(priorChar, currentColor);
                            if (priorRenderObject.vertexObject.vertices.position() != 0) {
                                priorRenderObject.vertexObject.vertices.position(priorRenderObject.vertexObject.vertices.position() - 48);
                            }
                            if (currentState.bold) {
                                priorRenderObject.vertexObject.vertices.position(priorRenderObject.vertexObject.vertices.position() - 48);
                            }
                            if (currentState.underline) {
                                RenderableData underlineRenderObject = this.getObjectFor('_', currentColor);
                                underlineRenderObject.vertexObject.vertices.position(underlineRenderObject.vertexObject.vertices.position() - 48);
                            }
                            if (!currentState.strikethrough) continue;
                            RenderableData strikethroughRenderObject = this.getObjectFor('-', currentColor);
                            strikethroughRenderObject.vertexObject.vertices.position(strikethroughRenderObject.vertexObject.vertices.position() - 48);
                        }
                        continue;
                    }
                    currentOffset = 0.0f;
                    currentLineOffset -= 9.0f;
                    indexAtLastNewline = i;
                    continue;
                }
                if (textChar == ' ') {
                    currentOffset += this.charWidths[textChar] + this.charSpacings[textChar];
                    continue;
                }
                currentOffset += this.charSpacings[textChar];
                RenderableData currentRenderObject = this.getObjectFor(textChar, currentColor);
                float charWidth = this.charWidths[textChar];
                int charSteps = 6;
                if (currentState.bold) {
                    charSteps += 6;
                }
                if (currentState.underline) {
                    charSteps += 6;
                }
                if (currentState.strikethrough) {
                    charSteps += 6;
                }
                block25: for (int j = 0; j < charSteps; ++j) {
                    switch (j) {
                        case 0: 
                        case 3: {
                            this.charVertex[0] = alignmentOffset + currentOffset + charWidth;
                            this.charVertex[1] = currentLineOffset - 8.0f;
                            this.charUV[0] = this.offsetsMaxU[textChar];
                            this.charUV[1] = this.offsetsMinV[textChar];
                            break;
                        }
                        case 1: {
                            this.charVertex[0] = alignmentOffset + currentOffset + charWidth;
                            if (currentState.italic) {
                                this.charVertex[0] = this.charVertex[0] + 1.0f;
                            }
                            this.charVertex[1] = currentLineOffset;
                            this.charUV[0] = this.offsetsMaxU[textChar];
                            this.charUV[1] = this.offsetsMaxV[textChar];
                            break;
                        }
                        case 2: 
                        case 4: {
                            this.charVertex[0] = alignmentOffset + currentOffset;
                            if (currentState.italic) {
                                this.charVertex[0] = this.charVertex[0] + 1.0f;
                            }
                            this.charVertex[1] = currentLineOffset;
                            this.charUV[0] = this.offsetsMinU[textChar];
                            this.charUV[1] = this.offsetsMaxV[textChar];
                            break;
                        }
                        case 5: {
                            this.charVertex[0] = alignmentOffset + currentOffset;
                            this.charVertex[1] = currentLineOffset - 8.0f;
                            this.charUV[0] = this.offsetsMinU[textChar];
                            this.charUV[1] = this.offsetsMinV[textChar];
                            break;
                        }
                        default: {
                            char customChar;
                            int currentIndex = currentRenderObject.vertexObject.vertices.position();
                            currentRenderObject.vertexObject.vertices.position(currentIndex - (6 - j % 6 + j - 6) * 8 + 3);
                            currentRenderObject.vertexObject.vertices.get(this.supplementalUV);
                            currentRenderObject.vertexObject.vertices.get(this.supplementalVertex);
                            currentRenderObject.vertexObject.vertices.position(currentIndex);
                            if (currentState.bold && j < 12) {
                                this.supplementalVertex[0] = this.supplementalVertex[0] + 0.2f;
                                this.supplementalVertex[1] = this.supplementalVertex[1] + 0.2f;
                                currentRenderObject.vertexObject.vertices.put(normals).put(this.supplementalUV).put(this.supplementalVertex);
                                break;
                            }
                            if (currentState.underline && j < 18) {
                                customChar = '_';
                            } else {
                                if (!currentState.strikethrough) continue block25;
                                customChar = '-';
                            }
                            switch (j % 6) {
                                case 0: 
                                case 3: {
                                    this.supplementalUV[0] = this.offsetsMaxU[customChar];
                                    this.supplementalUV[1] = this.offsetsMinV[customChar];
                                    break;
                                }
                                case 1: {
                                    this.supplementalUV[0] = this.offsetsMaxU[customChar];
                                    this.supplementalUV[1] = this.offsetsMaxV[customChar];
                                    break;
                                }
                                case 2: 
                                case 4: {
                                    this.supplementalUV[0] = this.offsetsMinU[customChar];
                                    this.supplementalUV[1] = this.offsetsMaxV[customChar];
                                    break;
                                }
                                case 5: {
                                    this.supplementalUV[0] = this.offsetsMinU[customChar];
                                    this.supplementalUV[1] = this.offsetsMinV[customChar];
                                }
                            }
                            RenderableData customRenderObject = this.getObjectFor(customChar, currentColor);
                            customRenderObject.vertexObject.vertices.put(normals).put(this.supplementalUV).put(this.supplementalVertex);
                            this.activeRenderObjects.add(customRenderObject);
                        }
                    }
                    if (j >= 6) continue;
                    this.charVertex[2] = 0.0f;
                    currentRenderObject.vertexObject.vertices.put(normals).put(this.charUV).put(this.charVertex);
                }
                currentOffset += charWidth + this.charSpacings[textChar];
                this.activeRenderObjects.add(currentRenderObject);
            }
            for (RenderableData object : this.activeRenderObjects) {
                object.setLightValue(worldLightValue);
                object.setLightMode(renderLit ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : (onGUI ? RenderableData.LightingMode.IGNORE_ORIENTATION_LIGHTING : RenderableData.LightingMode.NORMAL));
                object.transform.set(transform);
                if (rotation != null) {
                    object.transform.applyRotation(rotation);
                }
                object.transform.applyScaling(scale, scale, scale);
                object.transform.applyTranslation(adjustmentOffset);
                object.vertexObject.vertices.flip();
                object.render();
            }
        }

        private RenderableData getObjectFor(char textChar, ColorRGB color) {
            String font;
            Map map1;
            RenderableData object;
            if (textChar / 256 >= this.fontLocations.length) {
                textChar = '\u0000';
            }
            if ((object = (RenderableData)(map1 = createdRenderObjects.computeIfAbsent(font = this.fontLocations[textChar / 256], k -> new HashMap())).get(color)) == null) {
                object = new RenderableData(new RenderableVertices("font_block", FloatBuffer.allocate(48000), false), font);
                object.setColor(color);
                map1.put(color, object);
            }
            return object;
        }

        private float getStringWidth(String text) {
            float stringWidth = 0.0f;
            boolean skipNext = false;
            boolean foundCharAlready = false;
            for (char textChar : text.toCharArray()) {
                if (textChar == '\u00a7') {
                    skipNext = true;
                    continue;
                }
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                stringWidth += this.charWidths[textChar] + 2.0f * this.charSpacings[textChar];
                if (foundCharAlready) continue;
                foundCharAlready = true;
            }
            return stringWidth;
        }

        private static class FontRenderState {
            private static final int BOLD_BIT_INDEX = 1;
            private static final int ITALIC_BIT_INDEX = 2;
            private static final int UNDERLINE_BIT_INDEX = 4;
            private static final int STRIKETHROUGH_BIT_INDEX = 8;
            private final int index;
            private final boolean bold;
            private final boolean italic;
            private final boolean underline;
            private final boolean strikethrough;

            private FontRenderState(int index) {
                this.index = index;
                this.bold = (index & 1) == 1;
                this.italic = (index & 2) == 2;
                this.underline = (index & 4) == 4;
                this.strikethrough = (index & 8) == 8;
            }

            public static FontRenderState[] generateDefaults() {
                FontRenderState[] states = new FontRenderState[(int)Math.pow(2.0, 4.0)];
                for (int i = 0; i < states.length; ++i) {
                    states[i] = new FontRenderState(i);
                }
                return states;
            }
        }
    }

    public static enum TextAlignment {
        CENTERED,
        LEFT_ALIGNED,
        RIGHT_ALIGNED;

    }
}

