/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.sound.SoundInstance;

public class DurationDelayClock {
    private static final double c1 = 1.70518;
    private static final double c2 = 2.6003994999999995;
    private static final double c3 = 2.70518;
    private static final double c4 = 2.0943951023931953;
    private static final double c5 = 1.3962634015954636;
    private static final double n1 = 7.5625;
    private static final double d1 = 2.75;
    public final JSONAnimationDefinition animation;
    public final double animationAxisMagnitude;
    public final Point3D animationAxisNormalized;
    public final boolean isUseful;
    private Long timeCommandedForwards = 0L;
    private Long timeCommandedReverse = 0L;
    private final boolean shouldDoFactoring;
    private boolean startedForwardsMovement = false;
    private boolean endedForwardsMovement = false;
    private boolean startedReverseMovement = false;
    private boolean endedReverseMovement = false;

    public DurationDelayClock(JSONAnimationDefinition animation) {
        this.animation = animation;
        this.animationAxisMagnitude = animation.axis != null ? animation.axis.length() : 1.0;
        this.animationAxisNormalized = animation.axis != null ? animation.axis.copy().normalize() : null;
        this.shouldDoFactoring = animation.duration != 0 || animation.forwardsDelay != 0 || animation.reverseDelay != 0;
        this.isUseful = this.shouldDoFactoring || animation.animationType.equals((Object)JSONAnimationDefinition.AnimationComponentType.VISIBILITY) || animation.animationType.equals((Object)JSONAnimationDefinition.AnimationComponentType.INHIBITOR) || animation.animationType.equals((Object)JSONAnimationDefinition.AnimationComponentType.ACTIVATOR) || animation.forwardsStartSound != null || animation.forwardsEndSound != null || animation.reverseStartSound != null || animation.reverseEndSound != null;
    }

    public double getFactoredState(AEntityD_Definable<?> entity, double value, float partialTicks) {
        boolean commandForwards = value > 0.0;
        long currentTime = (long)((double)((float)entity.ticksExisted + partialTicks) * 50.0);
        long forwardsCycleTime = (long)this.animation.forwardsDelay * 50L;
        if (!this.animation.skipForwardsMovement) {
            forwardsCycleTime += (long)this.animation.duration * 50L + (long)this.animation.reverseDelay * 50L;
        }
        long reverseCycleTime = (long)this.animation.reverseDelay * 50L;
        if (!this.animation.skipReverseMovement) {
            reverseCycleTime += (long)this.animation.duration * 50L + (long)this.animation.forwardsDelay * 50L;
        }
        if (this.timeCommandedForwards == 0L && this.timeCommandedReverse == 0L) {
            if (commandForwards) {
                this.timeCommandedForwards = currentTime - forwardsCycleTime;
            } else {
                this.timeCommandedReverse = currentTime - reverseCycleTime;
            }
            this.startedForwardsMovement = true;
            this.endedForwardsMovement = true;
            this.startedReverseMovement = true;
            this.endedReverseMovement = true;
        } else if (this.timeCommandedForwards != 0L) {
            if (!commandForwards) {
                this.timeCommandedReverse = currentTime;
                long timeForwards = currentTime - this.timeCommandedForwards;
                if (timeForwards < forwardsCycleTime) {
                    this.timeCommandedReverse = this.timeCommandedReverse + (timeForwards - forwardsCycleTime);
                } else {
                    this.startedReverseMovement = false;
                }
                this.endedReverseMovement = false;
                this.timeCommandedForwards = 0L;
            }
        } else if (commandForwards) {
            this.timeCommandedForwards = currentTime;
            long timeReverse = currentTime - this.timeCommandedReverse;
            if (timeReverse < reverseCycleTime) {
                this.timeCommandedForwards = this.timeCommandedForwards + (timeReverse - reverseCycleTime);
            } else {
                this.startedForwardsMovement = false;
            }
            this.endedForwardsMovement = false;
            this.timeCommandedReverse = 0L;
        }
        double movementFactor = 0.0;
        if (commandForwards) {
            long timedelayed = currentTime - this.timeCommandedForwards;
            if (timedelayed >= (long)this.animation.forwardsDelay * 50L) {
                SoundInstance sound;
                double distance;
                long timeMoved = currentTime - (this.timeCommandedForwards + (long)this.animation.forwardsDelay * 50L);
                if (timeMoved < (long)this.animation.duration * 50L && !this.animation.skipForwardsMovement) {
                    movementFactor = (double)timeMoved / (double)(this.animation.duration * 50);
                    if (this.animation.forwardsEasing != null) {
                        movementFactor = DurationDelayClock.getEasingType(this.animation.forwardsEasing, movementFactor);
                    }
                } else {
                    movementFactor = 1.0;
                    if (!this.endedForwardsMovement) {
                        this.endedForwardsMovement = true;
                        if (this.animation.forwardsEndSound != null && entity.world.isClient() && (distance = entity.position.distanceTo(InterfaceManager.clientInterface.getClientPlayer().getPosition())) < 32.0) {
                            sound = new SoundInstance(entity, this.animation.forwardsEndSound);
                            sound.volume = (float)(1.0 - distance / 32.0);
                            InterfaceManager.soundInterface.playQuickSound(sound);
                        }
                    }
                }
                if (!this.startedForwardsMovement) {
                    this.startedForwardsMovement = true;
                    if (this.animation.forwardsStartSound != null && entity.world.isClient() && (distance = entity.position.distanceTo(InterfaceManager.clientInterface.getClientPlayer().getPosition())) < 32.0) {
                        sound = new SoundInstance(entity, this.animation.forwardsStartSound);
                        sound.volume = (float)(1.0 - distance / 32.0);
                        InterfaceManager.soundInterface.playQuickSound(sound);
                    }
                }
            }
        } else {
            long timedelayed = currentTime - this.timeCommandedReverse;
            if (timedelayed >= (long)this.animation.reverseDelay * 50L) {
                SoundInstance sound;
                double distance;
                long timeMoved = currentTime - (this.timeCommandedReverse + (long)this.animation.reverseDelay * 50L);
                if (timeMoved < (long)this.animation.duration * 50L && !this.animation.skipReverseMovement) {
                    movementFactor = (double)timeMoved / (double)(this.animation.duration * 50);
                    if (this.animation.reverseEasing != null) {
                        movementFactor = DurationDelayClock.getEasingType(this.animation.reverseEasing, movementFactor);
                    }
                } else {
                    movementFactor = 1.0;
                    if (!this.endedReverseMovement) {
                        this.endedReverseMovement = true;
                        if (this.animation.reverseEndSound != null && entity.world.isClient() && (distance = entity.position.distanceTo(InterfaceManager.clientInterface.getClientPlayer().getPosition())) < 32.0) {
                            sound = new SoundInstance(entity, this.animation.reverseEndSound);
                            sound.volume = (float)(1.0 - distance / 32.0);
                            InterfaceManager.soundInterface.playQuickSound(sound);
                        }
                    }
                }
                if (!this.startedReverseMovement) {
                    this.startedReverseMovement = true;
                    if (this.animation.reverseStartSound != null && entity.world.isClient() && (distance = entity.position.distanceTo(InterfaceManager.clientInterface.getClientPlayer().getPosition())) < 32.0) {
                        sound = new SoundInstance(entity, this.animation.reverseStartSound);
                        sound.volume = (float)(1.0 - distance / 32.0);
                        InterfaceManager.soundInterface.playQuickSound(sound);
                    }
                }
            }
            movementFactor = 1.0 - movementFactor;
        }
        return this.shouldDoFactoring ? movementFactor : value;
    }

    private static double getEasingType(JSONAnimationDefinition.AnimationEasingType direction, double time) {
        switch (direction) {
            case LINEAR: {
                return time;
            }
            case EASEINSINE: {
                return 1.0 - Math.cos(time * Math.PI / 2.0);
            }
            case EASEOUTSINE: {
                return Math.sin(time * Math.PI / 2.0);
            }
            case EASEINOUTSINE: {
                return -1.0 * (Math.cos(time * Math.PI) - 1.0) / 2.0;
            }
            case EASEINQUAD: {
                return time * time;
            }
            case EASEOUTQUAD: {
                return time * (2.0 - time);
            }
            case EASEINOUTQUAD: {
                return time < 0.5 ? 2.0 * time * time : -1.0 + (4.0 - 2.0 * time) * time;
            }
            case EASEINCUBIC: {
                return time * time * time;
            }
            case EASEOUTCUBIC: {
                return (time -= 1.0) * time * time + 1.0;
            }
            case EASEINOUTCUBIC: {
                return time < 0.5 ? 4.0 * time * time * time : (time - 1.0) * (2.0 * time - 2.0) * (2.0 * time - 2.0) + 1.0;
            }
            case EASEINQUART: {
                return time * time * time * time;
            }
            case EASEOUTQUART: {
                return 1.0 - (time -= 1.0) * time * time * time;
            }
            case EASEINOUTQUART: {
                return time < 0.5 ? 8.0 * time * time * time * time : 1.0 - 8.0 * (time -= 1.0) * time * time * time;
            }
            case EASEINQUINT: {
                return time * time * time * time * time;
            }
            case EASEOUTQUINT: {
                return 1.0 + (time -= 1.0) * time * time * time * time;
            }
            case EASEINOUTQUINT: {
                return time < 0.5 ? 16.0 * time * time * time * time * time : 1.0 + 16.0 * (time -= 1.0) * time * time * time * time;
            }
            case EASEINCIRC: {
                return 1.0 - Math.sqrt(1.0 - Math.pow(time, 2.0));
            }
            case EASEOUTCIRC: {
                return Math.sqrt(1.0 - Math.pow(time - 1.0, 2.0));
            }
            case EASEINOUTCIRC: {
                return time < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * time, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * time + 2.0, 2.0)) + 1.0) / 2.0;
            }
            case EASEINBACK: {
                return 2.70518 * time * time * time - 1.70518 * time * time;
            }
            case EASEOUTBACK: {
                return 1.0 + 2.70518 * Math.pow(time - 1.0, 3.0) + 1.70518 * Math.pow(time - 1.0, 2.0);
            }
            case EASEINOUTBACK: {
                return time < 0.5 ? Math.pow(2.0 * time, 2.0) * (7.200798999999999 * time - 2.6003994999999995) / 2.0 : (Math.pow(2.0 * time - 2.0, 2.0) * (3.6003994999999995 * (time * 2.0 - 2.0) + 2.6003994999999995) + 2.0) / 2.0;
            }
            case EASEINELASTIC: {
                if (time == 0.0) {
                    return 0.0;
                }
                if (time == 1.0) {
                    return 1.0;
                }
                return -Math.pow(2.0, 10.0 * time - 10.0) * Math.sin((time * 10.0 - 10.75) * 2.0943951023931953);
            }
            case EASEOUTELASTIC: {
                if (time == 0.0) {
                    return 0.0;
                }
                if (time == 1.0) {
                    return 1.0;
                }
                return Math.pow(2.0, -10.0 * time) * Math.sin((time * 10.0 - 0.75) * 2.0943951023931953) + 1.0;
            }
            case EASEINOUTELASTIC: {
                if (time == 0.0) {
                    return 0.0;
                }
                if (time == 1.0) {
                    return 1.0;
                }
                if (time < 0.5) {
                    return -(Math.pow(2.0, 20.0 * time - 10.0) * Math.sin((20.0 * time - 11.125) * 1.3962634015954636)) / 2.0;
                }
                return Math.pow(2.0, -20.0 * time + 10.0) * Math.sin((20.0 * time - 11.125) * 1.3962634015954636) / 2.0 + 1.0;
            }
            case EASEINBOUNCE: {
                return 1.0 - DurationDelayClock.getEasingType(JSONAnimationDefinition.AnimationEasingType.EASEOUTBOUNCE, 1.0 - time);
            }
            case EASEOUTBOUNCE: {
                if (time < 0.36363636363636365) {
                    return 7.5625 * time * time;
                }
                if (time < 0.7272727272727273) {
                    return 7.5625 * (time -= 0.5454545454545454) * time + 0.75;
                }
                if (time < 0.9090909090909091) {
                    return 7.5625 * (time -= 0.8181818181818182) * time + 0.9375;
                }
                return 7.5625 * (time -= 0.9545454545454546) * time + 0.984375;
            }
            case EASEINOUTBOUNCE: {
                return time < 0.5 ? (1.0 - DurationDelayClock.getEasingType(JSONAnimationDefinition.AnimationEasingType.EASEOUTBOUNCE, 1.0 - 2.0 * time)) / 2.0 : (1.0 + DurationDelayClock.getEasingType(JSONAnimationDefinition.AnimationEasingType.EASEINBOUNCE, 2.0 * time - 1.0)) / 2.0;
            }
        }
        return time;
    }
}

