/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.rendering.ModelParserLT;
import minecrafttransportsimulator.rendering.ModelParserOBJ;
import minecrafttransportsimulator.rendering.RenderableModelObject;
import minecrafttransportsimulator.rendering.RenderableVertices;

public abstract class AModelParser {
    private static final Map<String, AModelParser> parsers = new HashMap<String, AModelParser>();
    private static final Map<String, List<RenderableVertices>> parsedVertices = new HashMap<String, List<RenderableVertices>>();
    public static final String WINDOW_OBJECT_NAME = "window";
    public static final String ONLINE_TEXTURE_OBJECT_NAME = "url";
    public static final String TRANSLUCENT_OBJECT_NAME = "translucent";

    public AModelParser() {
        parsers.put(this.getModelSuffix(), this);
    }

    protected abstract String getModelSuffix();

    protected abstract List<RenderableVertices> parseModelInternal(String var1);

    public static List<RenderableVertices> parseModel(String modelLocation, boolean returnCached) {
        List<RenderableVertices> vertices = null;
        if (returnCached) {
            vertices = parsedVertices.get(modelLocation);
        }
        if (vertices == null) {
            AModelParser parser = parsers.get(modelLocation.substring(modelLocation.lastIndexOf(".") + 1));
            if (parser != null) {
                vertices = parser.parseModelInternal(modelLocation);
                if (returnCached) {
                    parsedVertices.put(modelLocation, vertices);
                }
            } else {
                throw new IllegalArgumentException("No parser found for model format of " + modelLocation.substring(modelLocation.lastIndexOf(".") + 1));
            }
        }
        return vertices;
    }

    public static List<RenderableModelObject> generateRenderables(AEntityD_Definable<?> entity) {
        String modelLocation = ((AJSONMultiModelProvider)entity.definition).getModelLocation(entity.subDefinition);
        ArrayList<RenderableModelObject> modelObjects = new ArrayList<RenderableModelObject>();
        for (RenderableVertices parsedObject : AModelParser.parseModel(modelLocation, true)) {
            modelObjects.add(new RenderableModelObject(entity, parsedObject));
        }
        return modelObjects;
    }

    static {
        new ModelParserOBJ();
        new ModelParserLT();
    }
}

