/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.packloading.PackMaterialComponent;

public class PacketPlayerCraftItem
extends APacketEntityInteract<AEntityD_Definable<?>, IWrapperPlayer> {
    private final AItemPack<?> itemToCraft;
    private final int recipeIndex;
    private final boolean forRepair;

    public PacketPlayerCraftItem(AEntityD_Definable<?> entity, IWrapperPlayer player, AItemPack<?> itemToCraft, int recipeIndex, boolean forRepair) {
        super(entity, player);
        this.itemToCraft = itemToCraft;
        this.recipeIndex = recipeIndex;
        this.forRepair = forRepair;
    }

    public PacketPlayerCraftItem(ByteBuf buf) {
        super(buf);
        this.itemToCraft = PacketPlayerCraftItem.readItemFromBuffer(buf);
        this.recipeIndex = buf.readInt();
        this.forRepair = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketPlayerCraftItem.writeItemToBuffer(this.itemToCraft, buf);
        buf.writeInt(this.recipeIndex);
        buf.writeBoolean(this.forRepair);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityD_Definable<?> entity, IWrapperPlayer player) {
        if (!world.isClient()) {
            IWrapperInventory inventory = player.getInventory();
            if (player.isCreative() || inventory.hasMaterials(PackMaterialComponent.parseFromJSON(this.itemToCraft, this.recipeIndex, true, true, this.forRepair, false))) {
                if (this.forRepair) {
                    int repairIndex = inventory.getRepairIndex(this.itemToCraft);
                    if (repairIndex != -1) {
                        IWrapperItemStack stack = inventory.getStack(repairIndex);
                        AItemPack item = (AItemPack)stack.getItem();
                        IWrapperNBT stackData = stack.getData();
                        item.repair(stackData);
                        stack.setData(stackData);
                        if (!player.isCreative()) {
                            inventory.removeMaterials(this.itemToCraft, this.recipeIndex, true, true, this.forRepair);
                        }
                        inventory.setStack(stack, repairIndex);
                        return true;
                    }
                } else if (inventory.addStack(this.itemToCraft.getNewStack(null))) {
                    if (!player.isCreative()) {
                        inventory.removeMaterials(this.itemToCraft, this.recipeIndex, true, true, this.forRepair);
                    }
                    return true;
                }
            }
        }
        entity.playerCraftedItem = true;
        return false;
    }
}

