/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.guis.instances.GUIFurnace;
import minecrafttransportsimulator.guis.instances.GUIInventoryContainer;
import minecrafttransportsimulator.guis.instances.GUIPartBench;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;

public class PacketPartInteractable
extends APacketEntityInteract<PartInteractable, IWrapperPlayer> {
    private final UUID linkedID;

    public PacketPartInteractable(PartInteractable interactable, IWrapperPlayer player) {
        super(interactable, player);
        this.linkedID = interactable.linkedVehicle != null ? interactable.linkedVehicle.uniqueUUID : (interactable.linkedPart != null ? interactable.linkedPart.uniqueUUID : null);
    }

    public PacketPartInteractable(ByteBuf buf) {
        super(buf);
        this.linkedID = buf.readBoolean() ? PacketPartInteractable.readUUIDFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        if (this.linkedID != null) {
            buf.writeBoolean(true);
            PacketPartInteractable.writeUUIDToBuffer(this.linkedID, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public boolean handle(AWrapperWorld world, PartInteractable interactable, IWrapperPlayer player) {
        if (this.linkedID != null) {
            Object linkedEntity = world.getEntity(this.linkedID);
            if (linkedEntity != null) {
                if (linkedEntity instanceof EntityVehicleF_Physics) {
                    interactable.linkedVehicle = (EntityVehicleF_Physics)linkedEntity;
                } else {
                    interactable.linkedPart = (PartInteractable)linkedEntity;
                }
            }
        } else {
            switch (((JSONPart)interactable.definition).interactable.interactionType) {
                case CRAFTING_BENCH: {
                    new GUIPartBench(interactable, ((JSONPart)interactable.definition).interactable.crafting);
                    break;
                }
                case CRATE: {
                    new GUIInventoryContainer(interactable.inventory, ((JSONPart)interactable.definition).interactable.inventoryTexture, false);
                    break;
                }
                case FURNACE: {
                    new GUIFurnace(interactable.furnace, ((JSONPart)interactable.definition).interactable.inventoryTexture);
                    break;
                }
                default: {
                    return false;
                }
            }
            InterfaceManager.packetInterface.sendToServer(new PacketEntityInteractGUI(interactable, player, true));
        }
        return true;
    }
}

