/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketEntityTextChange
extends APacketEntity<AEntityD_Definable<?>> {
    private final LinkedHashMap<String, String> textLines;

    public PacketEntityTextChange(AEntityD_Definable<?> entity, LinkedHashMap<String, String> textLines) {
        super(entity);
        this.textLines = textLines;
    }

    public PacketEntityTextChange(ByteBuf buf) {
        super(buf);
        byte textLineCount = buf.readByte();
        this.textLines = new LinkedHashMap();
        for (byte i = 0; i < textLineCount; i = (byte)(i + 1)) {
            this.textLines.put(PacketEntityTextChange.readStringFromBuffer(buf), PacketEntityTextChange.readStringFromBuffer(buf));
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.textLines.size());
        this.textLines.forEach((key, value) -> {
            PacketEntityTextChange.writeStringToBuffer(key, buf);
            PacketEntityTextChange.writeStringToBuffer(value, buf);
        });
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityD_Definable<?> entity) {
        entity.updateText(this.textLines);
        return true;
    }
}

