/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.packloading.PackMaterialComponent;

public class PacketEntityColorChange
extends APacketEntityInteract<AEntityD_Definable<?>, IWrapperPlayer> {
    private final AItemSubTyped<?> newItem;
    private final int recipeIndex;

    public PacketEntityColorChange(AEntityD_Definable<?> entity, IWrapperPlayer player, AItemSubTyped<?> newItem, int recipeIndex) {
        super(entity, player);
        this.newItem = newItem;
        this.recipeIndex = recipeIndex;
    }

    public PacketEntityColorChange(ByteBuf buf) {
        super(buf);
        this.newItem = (AItemSubTyped)PacketEntityColorChange.readItemFromBuffer(buf);
        this.recipeIndex = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityColorChange.writeItemToBuffer(this.newItem, buf);
        buf.writeInt(this.recipeIndex);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityD_Definable<?> entity, IWrapperPlayer player) {
        IWrapperInventory inventory = player.getInventory();
        if (player.isCreative() || inventory.hasMaterials(PackMaterialComponent.parseFromJSON(this.newItem, this.recipeIndex, false, true, false, false))) {
            if (!player.isCreative()) {
                inventory.removeMaterials(this.newItem, this.recipeIndex, false, true, false);
            }
            entity.updateSubDefinition(this.newItem.subDefinition.subName);
            if (entity instanceof AEntityF_Multipart) {
                ((AEntityF_Multipart)entity).parts.forEach(part -> part.updateTone(true));
            }
            return true;
        }
        return false;
    }
}

