/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;

public class ItemVehicle
extends AItemSubTyped<JSONVehicle>
implements IItemEntityProvider {
    public ItemVehicle(JSONVehicle definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean onBlockClicked(AWrapperWorld world, IWrapperPlayer player, Point3D position, ABlockBase.Axis axis) {
        if (!world.isClient()) {
            IWrapperNBT data = player.getHeldStack().getData();
            if (data != null) {
                data.deleteAllUUIDTags();
            }
            EntityVehicleF_Physics vehicle = new EntityVehicleF_Physics(world, player, this, data);
            vehicle.addPartsPostAddition(player, data);
            vehicle.position.set(position).add(0.5, 1.0, 0.5);
            vehicle.prevPosition.set(position);
            vehicle.orientation.setToAngles(new Point3D(0.0, player.getYaw() + 90.0f, 0.0));
            vehicle.prevOrientation.set(vehicle.orientation);
            vehicle.motion.set(0.0, 0.0, 0.0);
            vehicle.prevMotion.set(vehicle.motion);
            vehicle.world.spawnEntity(vehicle);
            if (!player.isCreative()) {
                player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
            }
        }
        return true;
    }

    @Override
    public void repair(IWrapperNBT data) {
        super.repair(data);
        data.setDouble("electricPower", 12.0);
    }

    @Override
    public void registerEntities(Map<String, IItemEntityProvider.IItemEntityFactory> entityMap) {
        entityMap.put(EntityVehicleF_Physics.class.getSimpleName(), (world, data) -> new EntityVehicleF_Physics(world, null, (ItemVehicle)data.getPackItem(), data));
    }
}

