/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemPartEngine
extends AItemPart {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("engine");
        }

        @Override
        public ItemPartEngine createItem(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
            return new ItemPartEngine(definition, subDefinition, sourcePackID);
        }
    };

    public ItemPartEngine(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, JSONSubDefinition subDefinition, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subDefinition, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).engine.fuelConsumption && placementDefinition.maxValue >= ((JSONPart)this.definition).engine.fuelConsumption);
    }

    @Override
    public PartEngine createPart(AEntityF_Multipart<?> entity, IWrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, IWrapperNBT partData) {
        return new PartEngine(entity, placingPlayer, packVehicleDef, this, partData);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_MAXRPM.getCurrentValue() + ((JSONPart)this.definition).engine.maxRPM);
        tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_MAXSAFERPM.getCurrentValue() + ((JSONPart)this.definition).engine.maxSafeRPM);
        tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_FUELCONSUMPTION.getCurrentValue() + ((JSONPart)this.definition).engine.fuelConsumption);
        if (((JSONPart)this.definition).engine.superchargerEfficiency != 0.0f) {
            tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_SUPERCHARGERFUELCONSUMPTION.getCurrentValue() + ((JSONPart)this.definition).engine.superchargerFuelConsumption);
            tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_SUPERCHARGEREFFICIENCY.getCurrentValue() + ((JSONPart)this.definition).engine.superchargerEfficiency);
        }
        if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f) {
            tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_JETPOWERFACTOR.getCurrentValue() + (int)(100.0f * ((JSONPart)this.definition).engine.jetPowerFactor) + "%");
            tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_BYPASSRATIO.getCurrentValue() + ((JSONPart)this.definition).engine.bypassRatio);
        }
        tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_FUELTYPE.getCurrentValue() + ((JSONPart)this.definition).engine.fuelType);
        if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.MAGIC) {
            tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_MAGIC.getCurrentValue());
        } else if (ConfigSystem.settings.fuel.fuels.containsKey(((JSONPart)this.definition).engine.fuelType)) {
            StringBuilder line = new StringBuilder(LanguageSystem.ITEMINFO_ENGINE_FLUIDS.getCurrentValue());
            for (Map.Entry<String, Double> fuelEntry : ConfigSystem.settings.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).entrySet()) {
                if (!InterfaceManager.coreInterface.isFluidValid(fuelEntry.getKey())) continue;
                line.append(InterfaceManager.clientInterface.getFluidName(fuelEntry.getKey())).append("@").append(fuelEntry.getValue()).append(", ");
            }
            tooltipLines.add(line.substring(0, line.length() - 2));
        }
        tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_HOURS.getCurrentValue() + (double)Math.round(data.getDouble("hours") * 100.0) / 100.0);
        if (((JSONPart)this.definition).engine.gearRatios.size() > 3) {
            tooltipLines.add(((JSONPart)this.definition).engine.isAutomatic ? LanguageSystem.ITEMINFO_ENGINE_AUTOMATIC.getCurrentValue() : LanguageSystem.ITEMINFO_ENGINE_MANUAL.getCurrentValue());
            tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_GEARRATIOS.getCurrentValue());
            for (int i = 0; i < ((JSONPart)this.definition).engine.gearRatios.size(); i = (int)((byte)(i + 5))) {
                String gearRatios = "";
                for (int j = i; j < i + 5 && j < ((JSONPart)this.definition).engine.gearRatios.size(); j = (int)((byte)(j + 1))) {
                    gearRatios = gearRatios + String.valueOf(((JSONPart)this.definition).engine.gearRatios.get(j));
                    if (j >= ((JSONPart)this.definition).engine.gearRatios.size() - 1) continue;
                    gearRatios = gearRatios + ",  ";
                }
                tooltipLines.add(gearRatios);
            }
        } else {
            tooltipLines.add(LanguageSystem.ITEMINFO_ENGINE_GEARRATIOS.getCurrentValue() + ((JSONPart)this.definition).engine.gearRatios.get(((JSONPart)this.definition).engine.gearRatios.size() - 1));
        }
    }

    @Override
    public boolean needsRepair(IWrapperNBT data) {
        return super.needsRepair(data) || data != null && data.getDouble("hours") > 0.0;
    }

    @Override
    public void repair(IWrapperNBT data) {
        super.repair(data);
        data.setDouble("hours", 0.0);
    }
}

