/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONDummyPartProvider;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityPlacedPart
extends AEntityF_Multipart<JSONDummyPartProvider> {
    private static final List<String> allPartTypes = new ArrayList<String>();
    public APart currentPart;
    private boolean foundPart;
    private final Point3D motionApplied = new Point3D();
    private boolean partRequiresDeltaUpdates;

    public EntityPlacedPart(AWrapperWorld world, IWrapperPlayer placingPlayer, IWrapperNBT data) {
        super(world, placingPlayer, null, data);
    }

    @Override
    public JSONDummyPartProvider generateDefaultDefinition() {
        JSONDummyPartProvider defaultDefinition = JSONDummyPartProvider.generateDummy();
        if (allPartTypes.isEmpty()) {
            for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
                if (!(packItem instanceof AItemPart)) continue;
                AItemPart partItem = (AItemPart)packItem;
                if (allPartTypes.contains(((JSONPart)partItem.definition).generic.type)) continue;
                allPartTypes.add(((JSONPart)partItem.definition).generic.type);
            }
        }
        ((JSONPartDefinition)defaultDefinition.parts.get((int)0)).types.addAll(allPartTypes);
        return defaultDefinition;
    }

    @Override
    public void update() {
        super.update();
        if (this.parts.isEmpty()) {
            if (this.foundPart || this.ticksExisted > 100L) {
                this.remove();
            }
        } else if (this.currentPart != null) {
            this.foundPart = true;
            if (((JSONPart)this.currentPart.definition).generic.fallsToGround) {
                this.partRequiresDeltaUpdates = this.currentPart.requiresDeltaUpdates();
                if (this.ticksExisted > 1L) {
                    if (this.motion.y > -3.9) {
                        this.motion.y += -0.08;
                    }
                    double maxCollisionDepth = 0.0;
                    this.motionApplied.set(0.0, 0.0, 0.0);
                    while (this.motionApplied.y > this.motion.y) {
                        this.motionApplied.y -= 1.0;
                        if (this.motionApplied.y < this.motion.y) {
                            this.motionApplied.y = this.motion.y;
                        }
                        for (BoundingBox box : this.allCollisionBoxes) {
                            if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.BLOCK)) continue;
                            box.updateCollisions(this.world, this.motionApplied, false);
                            if (!(box.currentCollisionDepth.y <= maxCollisionDepth)) continue;
                            maxCollisionDepth = box.currentCollisionDepth.y;
                        }
                    }
                    this.position.add(this.motion);
                    if (maxCollisionDepth != 0.0) {
                        this.motion.y = 0.0;
                        this.position.y -= maxCollisionDepth;
                    }
                }
            }
        }
    }

    @Override
    public void addPart(APart part, boolean sendPacket) {
        super.addPart(part, sendPacket);
        this.currentPart = part;
        this.currentPart.placementDefinition.pos.y = ((JSONPart)this.currentPart.definition).generic.placedOffset;
    }

    @Override
    public void removePart(APart part, boolean removeFromWorld, Iterator<APart> iterator) {
        super.removePart(part, removeFromWorld, iterator);
        this.currentPart = null;
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return this.partRequiresDeltaUpdates;
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.client.renderingSettings.vehicleBeams.value;
    }

    @Override
    public boolean disableRendering() {
        return true;
    }
}

