/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketFurnaceFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketFurnaceTimeSet;

public class EntityFurnace
extends EntityInventoryContainer {
    public int ticksAddedOfFuel;
    public int ticksLeftOfFuel;
    public int ticksNeededToSmelt;
    public int ticksLeftToSmelt;
    public double powerToDrawPerTick;
    public final JSONPart.JSONPartInteractable definition;
    public static final int SMELTING_ITEM_SLOT = 0;
    public static final int SMELTED_ITEM_SLOT = 1;
    public static final int FUEL_ITEM_SLOT = 2;
    public static final String FURNACE_FUEL_NAME = "furnace";

    public EntityFurnace(AWrapperWorld world, IWrapperNBT data, JSONPart.JSONPartInteractable definition) {
        super(world, data, 3);
        this.definition = definition;
        if (data != null) {
            this.ticksAddedOfFuel = data.getInteger("ticksAddedOfFuel");
            this.ticksLeftOfFuel = data.getInteger("ticksLeftOfFuel");
            this.ticksNeededToSmelt = data.getInteger("ticksNeededToSmelt");
            this.ticksLeftToSmelt = data.getInteger("ticksLeftToSmelt");
            this.powerToDrawPerTick = data.getDouble("powerToDrawPerTick");
        }
    }

    @Override
    public void update() {
        IWrapperItemStack smeltingStack;
        super.update();
        if (this.ticksLeftToSmelt > 0) {
            IWrapperItemStack fuelStack;
            if (!this.world.isClient() && this.ticksLeftOfFuel == 0 && this.definition.furnaceType.equals((Object)JSONPart.FurnaceComponentType.STANDARD) && !(fuelStack = this.getStack(2)).isEmpty()) {
                this.ticksLeftOfFuel = this.ticksAddedOfFuel = fuelStack.getFuelValue();
                InterfaceManager.packetInterface.sendToAllClients(new PacketFurnaceFuelAdd(this));
                this.removeFromSlot(2, 1);
            }
            IWrapperItemStack smeltingStack2 = this.getStack(0);
            if (!this.world.isClient() && smeltingStack2.isEmpty()) {
                this.ticksLeftToSmelt = this.ticksNeededToSmelt = 0;
                InterfaceManager.packetInterface.sendToAllClients(new PacketFurnaceTimeSet(this));
            }
            if (this.ticksLeftOfFuel > 0) {
                --this.ticksLeftOfFuel;
                if (this.world.isClient()) {
                    if (this.ticksLeftToSmelt > 0) {
                        --this.ticksLeftToSmelt;
                    }
                } else if (--this.ticksLeftToSmelt == 0) {
                    IWrapperItemStack smeltingResult = smeltingStack2.getSmeltedItem(this.world);
                    IWrapperItemStack stackInResult = this.getStack(1);
                    if (stackInResult.isEmpty()) {
                        stackInResult = smeltingResult;
                    } else {
                        stackInResult.add(smeltingResult.getSize());
                    }
                    this.setStack(stackInResult, 1);
                    this.removeFromSlot(0, 1);
                    this.ticksNeededToSmelt = 0;
                }
            } else {
                this.ticksAddedOfFuel = 0;
            }
        } else if (!this.world.isClient() && !(smeltingStack = this.getStack(0)).isEmpty()) {
            IWrapperItemStack smeltingResult = smeltingStack.getSmeltedItem(this.world);
            IWrapperItemStack stackInResult = this.getStack(1);
            if (stackInResult.isEmpty() || stackInResult.isCompleteMatch(smeltingResult) && stackInResult.getMaxSize() - stackInResult.getSize() >= smeltingResult.getSize()) {
                this.ticksLeftToSmelt = this.ticksNeededToSmelt = (int)((float)smeltingStack.getSmeltingTime(this.world) * 1.0f / this.definition.furnaceRate);
                InterfaceManager.packetInterface.sendToAllClients(new PacketFurnaceTimeSet(this));
            }
        }
    }

    @Override
    public boolean isStackValid(IWrapperItemStack stackToCheck, int index) {
        if (index == 0) {
            return !stackToCheck.getSmeltedItem(this.world).isEmpty();
        }
        if (index == 2) {
            return this.definition.furnaceType.equals((Object)JSONPart.FurnaceComponentType.STANDARD) && stackToCheck.getFuelValue() != 0;
        }
        return false;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("ticksAddedOfFuel", this.ticksAddedOfFuel);
        data.setInteger("ticksLeftOfFuel", this.ticksLeftOfFuel);
        data.setInteger("ticksNeededToSmelt", this.ticksNeededToSmelt);
        data.setInteger("ticksLeftToSmelt", this.ticksLeftToSmelt);
        data.setDouble("powerToDrawPerTick", this.powerToDrawPerTick);
        return data;
    }
}

