/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.NavBeacon;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.AEntityVehicleD_Moving;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class AEntityVehicleE_Powered
extends AEntityVehicleD_Moving {
    public static final String RUNNINGLIGHT_VARIABLE = "running_light";
    public static final String HEADLIGHT_VARIABLE = "headlight";
    public static final String NAVIGATIONLIGHT_VARIABLE = "navigation_light";
    public static final String STROBELIGHT_VARIABLE = "strobe_light";
    public static final String TAXILIGHT_VARIABLE = "taxi_light";
    public static final String LANDINGLIGHT_VARIABLE = "landing_light";
    public static final String HORN_VARIABLE = "horn";
    public static final String GEAR_VARIABLE = "gear_setpoint";
    public static final String THROTTLE_VARIABLE = "throttle";
    public static final String REVERSE_THRUST_VARIABLE = "reverser";
    public boolean reverseThrust;
    public boolean beingFueled;
    public boolean enginesOn;
    public boolean enginesStarting;
    public boolean enginesRunning;
    public boolean isCreative;
    public double throttle;
    public static final double MAX_THROTTLE = 1.0;
    public boolean hasReverseThrust;
    public int gearMovementTime;
    public int ticksOutOfHealth;
    public double electricPower;
    public double electricUsage;
    public double electricFlow;
    public String selectedBeaconName;
    public NavBeacon selectedBeacon;
    public final EntityFluidTank fuelTank;
    public final List<PartEngine> engines = new ArrayList<PartEngine>();
    public final List<EntityBullet> missilesIncoming = new ArrayList<EntityBullet>();
    public final List<AEntityD_Definable<?>> radarsTracking = new ArrayList();

    public AEntityVehicleE_Powered(AWrapperWorld world, IWrapperPlayer placingPlayer, ItemVehicle item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        if (data != null) {
            this.electricPower = data.getDouble("electricPower");
            this.selectedBeaconName = data.getString("selectedBeaconName");
            this.selectedBeacon = NavBeacon.getByNameFromWorld(world, this.selectedBeaconName);
            this.fuelTank = new EntityFluidTank(world, data.getData("fuelTank"), ((JSONVehicle)this.definition).motorized.fuelCapacity);
        } else {
            this.electricPower = 12.0;
            this.selectedBeaconName = "";
            this.fuelTank = new EntityFluidTank(world, null, ((JSONVehicle)this.definition).motorized.fuelCapacity);
        }
        world.addEntity(this.fuelTank);
    }

    @Override
    public void update() {
        block20: {
            block18: {
                block19: {
                    super.update();
                    this.world.beginProfiling("VehicleE_Level", true);
                    this.throttle = this.getVariable(THROTTLE_VARIABLE);
                    this.reverseThrust = this.isVariableActive(REVERSE_THRUST_VARIABLE);
                    if (!this.world.isClient() && this.fuelTank.getFluidLevel() < (double)(((JSONVehicle)this.definition).motorized.fuelCapacity - 100)) {
                        for (APart part : this.allParts) {
                            double amountFilled;
                            EntityFluidTank tank;
                            if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || (tank = ((PartInteractable)part).tank) == null || !((amountFilled = tank.drain(this.fuelTank.getFluid(), 1.0, true)) > 0.0)) continue;
                            this.fuelTank.fill(this.fuelTank.getFluid(), amountFilled, true);
                        }
                    }
                    if (((JSONVehicle)this.definition).motorized.isAircraft && this.ticksExisted % 20L == 0L) {
                        this.selectedBeacon = !this.selectedBeaconName.isEmpty() ? NavBeacon.getByNameFromWorld(this.world, this.selectedBeaconName) : null;
                    }
                    if (!((JSONVehicle)this.definition).motorized.isTrailer) break block18;
                    if (this.towedByConnection == null) break block19;
                    if (this.parkingBrakeOn) {
                        this.toggleVariable("p_brake");
                    }
                    this.setVariable("brake", this.towedByConnection.towingVehicle.brake);
                    break block20;
                }
                if (!this.parkingBrakeOn) {
                    this.toggleVariable("p_brake");
                }
                if (this.brake == 0.0) break block20;
                this.setVariable("brake", 0.0);
                break block20;
            }
            this.enginesOn = false;
            this.enginesStarting = false;
            this.enginesRunning = false;
            for (PartEngine engine : this.engines) {
                if (!engine.magnetoOn) continue;
                this.enginesOn = true;
                if (engine.electricStarterEngaged) {
                    this.enginesStarting = true;
                }
                if (!engine.running) continue;
                this.enginesRunning = true;
                break;
            }
        }
        if (((JSONVehicle)this.definition).motorized.isTrailer) {
            if (this.towedByConnection != null) {
                this.electricPower = this.towedByConnection.towingVehicle.electricPower;
            }
        } else if (!this.outOfHealth) {
            this.electricPower = Math.max(0.0, Math.min(13.0, this.electricPower -= this.electricUsage));
            this.electricFlow = this.electricUsage;
            this.electricUsage = 0.0;
        } else {
            this.electricPower = 0.0;
            this.electricFlow = 0.0;
            this.electricUsage = 0.0;
        }
        if (this.isVariableActive(GEAR_VARIABLE)) {
            if (this.gearMovementTime < ((JSONVehicle)this.definition).motorized.gearSequenceDuration) {
                ++this.gearMovementTime;
            }
        } else if (this.gearMovementTime > 0) {
            --this.gearMovementTime;
        }
        this.missilesIncoming.sort((missle1, missile2) -> missle1.targetDistance < missile2.targetDistance ? -1 : 1);
        this.radarsTracking.removeIf(tracker -> !tracker.isValid || !tracker.aircraftOnRadar.contains(this) && !tracker.groundersOnRadar.contains(this));
        if (this.outOfHealth && (Double)ConfigSystem.settings.general.vehicleDeathDespawnTime.value > 0.0) {
            int n;
            ++this.ticksOutOfHealth;
            if ((double)n > (Double)ConfigSystem.settings.general.vehicleDeathDespawnTime.value * 20.0) {
                this.remove();
            }
        }
        this.world.endProfiling();
    }

    @Override
    public void destroy(BoundingBox box) {
        for (ItemInstrument instrument : this.instruments) {
            if (instrument == null) continue;
            this.world.spawnItemStack(instrument.getNewStack(null), box.globalCenter, null);
        }
        if (((Boolean)ConfigSystem.settings.damage.vehicleExplosions.value).booleanValue()) {
            double explosivePower = 0.0;
            for (APart part : this.allParts) {
                if (!(part instanceof PartInteractable)) continue;
                explosivePower += ((PartInteractable)part).getExplosiveContribution();
            }
            this.world.spawnExplosion(box.globalCenter, explosivePower + this.fuelTank.getExplosiveness() + 1.0, true);
        }
        super.destroy(box);
    }

    @Override
    public double getMass() {
        return super.getMass() + this.fuelTank.getMass();
    }

    @Override
    public void addPartsPostAddition(IWrapperPlayer placingPlayer, IWrapperNBT data) {
        super.addPartsPostAddition(placingPlayer, data);
        if (data == null && ((JSONVehicle)this.definition).motorized.defaultFuelQty > 0) {
            for (APart part : this.allParts) {
                if (!(part instanceof PartEngine)) continue;
                String mostPotentFluid = "";
                if (((JSONPart)part.definition).engine.type == JSONPart.EngineType.ELECTRIC) {
                    mostPotentFluid = PartEngine.ELECTRICITY_FUEL;
                } else {
                    for (String fluidName : ConfigSystem.settings.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).keySet()) {
                        if (!InterfaceManager.coreInterface.isFluidValid(fluidName) || !mostPotentFluid.isEmpty() && !(ConfigSystem.settings.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).get(mostPotentFluid) < ConfigSystem.settings.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).get(fluidName))) continue;
                        mostPotentFluid = fluidName;
                    }
                }
                this.fuelTank.manuallySet(mostPotentFluid, ((JSONVehicle)this.definition).motorized.defaultFuelQty);
                break;
            }
            if (this.fuelTank.getFluid().isEmpty() && placingPlayer != null) {
                placingPlayer.sendPacket(new PacketPlayerChatMessage(placingPlayer, LanguageSystem.SYSTEM_DEBUG, "A defaultFuelQty was specified for: " + ((JSONVehicle)this.definition).packID + ":" + ((JSONVehicle)this.definition).systemName + ", but no engine was noted as a defaultPart, so we don't know what fuel to put in the vehicle.  Vehicle will be spawned without fuel and engine."));
            }
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.engines.clear();
        this.allParts.forEach(part -> {
            if (part instanceof PartEngine) {
                this.engines.add((PartEngine)part);
            }
        });
        this.hasReverseThrust = false;
        if (((JSONVehicle)this.definition).motorized.isBlimp) {
            this.hasReverseThrust = true;
        } else {
            for (APart part2 : this.allParts) {
                if (part2 instanceof PartPropeller) {
                    if (!((JSONPart)part2.definition).propeller.isDynamicPitch) continue;
                    this.hasReverseThrust = true;
                    break;
                }
                if (!(part2 instanceof PartEngine) || !(((JSONPart)part2.definition).engine.jetPowerFactor > 0.0f)) continue;
                this.hasReverseThrust = true;
                break;
            }
        }
    }

    public FuelTankResult checkFuelTankCompatibility(String fluid) {
        if (!this.fuelTank.getFluid().isEmpty() && !fluid.equals(this.fuelTank.getFluid())) {
            return FuelTankResult.MISMATCH;
        }
        boolean foundEngine = false;
        for (APart part : this.allParts) {
            if (!(part instanceof PartEngine)) continue;
            foundEngine = true;
            if (!ConfigSystem.settings.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).containsKey(fluid)) continue;
            return FuelTankResult.VALID;
        }
        return foundEngine ? FuelTankResult.INVALID : FuelTankResult.NOENGINE;
    }

    public boolean canPlayerStartEngines(IWrapperPlayer player) {
        UUID itemKeyUUID;
        IWrapperNBT data;
        if (!((Boolean)ConfigSystem.settings.general.keyRequiredToStartVehicles.value).booleanValue()) {
            return true;
        }
        if (player.isHoldingItemType(JSONItem.ItemComponentType.KEY) && (data = player.getHeldStack().getData()) != null && (itemKeyUUID = data.getUUID("keyUUID")) != null && itemKeyUUID.equals(this.keyUUID)) {
            return true;
        }
        if (this.world.isClient()) {
            player.displayChatMessage(LanguageSystem.INTERACT_VEHICLE_NEEDKEY, new Object[0]);
        }
        return false;
    }

    @Override
    public boolean hasRadio() {
        return true;
    }

    @Override
    public boolean renderTextLit() {
        if (super.renderTextLit() && this.electricPower > 3.0) {
            return this.getCleanRawVariableValue(((JSONVehicle)this.definition).motorized.litVariable, 0.0f) > 0.0;
        }
        return false;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setDouble("electricPower", this.electricPower);
        data.setString("selectedBeaconName", this.selectedBeaconName);
        data.setData("fuelTank", this.fuelTank.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        return data;
    }

    public static enum FuelTankResult {
        NOENGINE,
        VALID,
        INVALID,
        MISMATCH;

    }
}

