/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;

public class TileEntityRadio
extends TileEntityDecor {
    public TileEntityRadio(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.radio.position.set(position);
    }

    @Override
    public boolean hasRadio() {
        return true;
    }

    @Override
    public void remove() {
        super.remove();
        this.radio.remove();
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (this.radio.interact(player)) {
            this.playersInteracting.add(player);
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, true));
            return true;
        }
        return false;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "radio_active": {
                return this.radio.isPlaying() ? 1.0 : 0.0;
            }
            case "radio_volume": {
                return this.radio.volume;
            }
            case "radio_preset": {
                return this.radio.preset;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }
}

